/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.FuturesGetCheckedInputs;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import junit.framework.TestCase;

public class FuturesGetUncheckedTest
extends TestCase {
    public void testGetUnchecked_success() {
        FuturesGetUncheckedTest.assertEquals((String)"foo", (String)((String)Futures.getUnchecked((Future)Futures.immediateFuture((Object)"foo"))));
    }

    public void testGetUnchecked_interrupted() {
        Thread.currentThread().interrupt();
        try {
            FuturesGetUncheckedTest.assertEquals((String)"foo", (String)((String)Futures.getUnchecked((Future)Futures.immediateFuture((Object)"foo"))));
            FuturesGetUncheckedTest.assertTrue((boolean)Thread.currentThread().isInterrupted());
        }
        finally {
            Thread.interrupted();
        }
    }

    public void testGetUnchecked_cancelled() {
        SettableFuture future = SettableFuture.create();
        future.cancel(true);
        try {
            Futures.getUnchecked((Future)future);
            FuturesGetUncheckedTest.fail();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void testGetUnchecked_ExecutionExceptionChecked() {
        try {
            Futures.getUnchecked(FuturesGetCheckedInputs.FAILED_FUTURE_CHECKED_EXCEPTION);
            FuturesGetUncheckedTest.fail();
        }
        catch (UncheckedExecutionException expected) {
            FuturesGetUncheckedTest.assertEquals((Object)FuturesGetCheckedInputs.CHECKED_EXCEPTION, (Object)expected.getCause());
        }
    }

    public void testGetUnchecked_ExecutionExceptionUnchecked() {
        try {
            Futures.getUnchecked(FuturesGetCheckedInputs.FAILED_FUTURE_UNCHECKED_EXCEPTION);
            FuturesGetUncheckedTest.fail();
        }
        catch (UncheckedExecutionException expected) {
            FuturesGetUncheckedTest.assertEquals((Object)FuturesGetCheckedInputs.UNCHECKED_EXCEPTION, (Object)expected.getCause());
        }
    }

    public void testGetUnchecked_ExecutionExceptionError() {
        try {
            Futures.getUnchecked(FuturesGetCheckedInputs.FAILED_FUTURE_ERROR);
            FuturesGetUncheckedTest.fail();
        }
        catch (ExecutionError expected) {
            FuturesGetUncheckedTest.assertEquals((Object)FuturesGetCheckedInputs.ERROR, (Object)expected.getCause());
        }
    }

    public void testGetUnchecked_ExecutionExceptionOtherThrowable() {
        try {
            Futures.getUnchecked(FuturesGetCheckedInputs.FAILED_FUTURE_OTHER_THROWABLE);
            FuturesGetUncheckedTest.fail();
        }
        catch (UncheckedExecutionException expected) {
            FuturesGetUncheckedTest.assertEquals((Object)FuturesGetCheckedInputs.OTHER_THROWABLE, (Object)expected.getCause());
        }
    }

    public void testGetUnchecked_RuntimeException() {
        try {
            Futures.getUnchecked(FuturesGetCheckedInputs.RUNTIME_EXCEPTION_FUTURE);
            FuturesGetUncheckedTest.fail();
        }
        catch (RuntimeException expected) {
            FuturesGetUncheckedTest.assertEquals((Object)FuturesGetCheckedInputs.RUNTIME_EXCEPTION, (Object)expected);
        }
    }

    public void testGetUnchecked_Error() {
        try {
            Futures.getUnchecked(FuturesGetCheckedInputs.ERROR_FUTURE);
        }
        catch (Error expected) {
            FuturesGetUncheckedTest.assertEquals((Object)FuturesGetCheckedInputs.ERROR, (Object)expected);
            return;
        }
        FuturesGetUncheckedTest.fail();
    }
}

