/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.testing.TestLogHandler;
import com.google.common.util.concurrent.ListenerCallQueue;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import junit.framework.TestCase;

public class ListenerCallQueueTest
extends TestCase {
    private static final ListenerCallQueue.Event<Object> THROWING_EVENT = new ListenerCallQueue.Event<Object>(){

        public void call(Object object) {
            throw new RuntimeException();
        }

        public String toString() {
            return "throwing()";
        }
    };

    public void testEnqueueAndDispatch() {
        Object listener = new Object();
        ListenerCallQueue queue = new ListenerCallQueue();
        queue.addListener(listener, MoreExecutors.directExecutor());
        ConcurrentHashMultiset counters = ConcurrentHashMultiset.create();
        queue.enqueue(this.incrementingEvent((Multiset<Object>)counters, listener, 1));
        queue.enqueue(this.incrementingEvent((Multiset<Object>)counters, listener, 2));
        queue.enqueue(this.incrementingEvent((Multiset<Object>)counters, listener, 3));
        queue.enqueue(this.incrementingEvent((Multiset<Object>)counters, listener, 4));
        ListenerCallQueueTest.assertEquals((int)0, (int)counters.size());
        queue.dispatch();
        ListenerCallQueueTest.assertEquals(ListenerCallQueueTest.multiset(listener, 4), (Object)counters);
    }

    public void testEnqueueAndDispatch_multipleListeners() {
        Object listener1 = new Object();
        ListenerCallQueue queue = new ListenerCallQueue();
        queue.addListener(listener1, MoreExecutors.directExecutor());
        ConcurrentHashMultiset counters = ConcurrentHashMultiset.create();
        queue.enqueue(this.incrementingEvent((Multiset<Object>)counters, listener1, 1));
        queue.enqueue(this.incrementingEvent((Multiset<Object>)counters, listener1, 2));
        Object listener2 = new Object();
        queue.addListener(listener2, MoreExecutors.directExecutor());
        queue.enqueue(this.incrementingEvent((Multiset<Object>)counters, (Multiset<Object>)ListenerCallQueueTest.multiset(listener1, 3, listener2, 1)));
        queue.enqueue(this.incrementingEvent((Multiset<Object>)counters, (Multiset<Object>)ListenerCallQueueTest.multiset(listener1, 4, listener2, 2)));
        ListenerCallQueueTest.assertEquals((int)0, (int)counters.size());
        queue.dispatch();
        ListenerCallQueueTest.assertEquals(ListenerCallQueueTest.multiset(listener1, 4, listener2, 2), (Object)counters);
    }

    public void testEnqueueAndDispatch_withExceptions() {
        Object listener = new Object();
        ListenerCallQueue queue = new ListenerCallQueue();
        queue.addListener(listener, MoreExecutors.directExecutor());
        ConcurrentHashMultiset counters = ConcurrentHashMultiset.create();
        queue.enqueue(this.incrementingEvent((Multiset<Object>)counters, listener, 1));
        queue.enqueue(THROWING_EVENT);
        queue.enqueue(this.incrementingEvent((Multiset<Object>)counters, listener, 2));
        queue.enqueue(THROWING_EVENT);
        queue.enqueue(this.incrementingEvent((Multiset<Object>)counters, listener, 3));
        queue.enqueue(THROWING_EVENT);
        queue.enqueue(this.incrementingEvent((Multiset<Object>)counters, listener, 4));
        queue.enqueue(THROWING_EVENT);
        ListenerCallQueueTest.assertEquals((int)0, (int)counters.size());
        queue.dispatch();
        ListenerCallQueueTest.assertEquals(ListenerCallQueueTest.multiset(listener, 4), (Object)counters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnqueueAndDispatch_withLabeledExceptions() {
        MyListener listener = new MyListener();
        ListenerCallQueue queue = new ListenerCallQueue();
        queue.addListener((Object)listener, MoreExecutors.directExecutor());
        queue.enqueue(THROWING_EVENT, "custom-label");
        Logger logger = Logger.getLogger(ListenerCallQueue.class.getName());
        logger.setLevel(Level.SEVERE);
        TestLogHandler logHandler = new TestLogHandler();
        logger.addHandler((Handler)logHandler);
        try {
            queue.dispatch();
        }
        finally {
            logger.removeHandler((Handler)logHandler);
        }
        ListenerCallQueueTest.assertEquals((int)1, (int)logHandler.getStoredLogRecords().size());
        ListenerCallQueueTest.assertEquals((String)"Exception while executing callback: MyListener custom-label", (String)((LogRecord)logHandler.getStoredLogRecords().get(0)).getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnqueueAndDispatch_multithreaded() throws InterruptedException {
        Object listener = new Object();
        ExecutorService service = Executors.newFixedThreadPool(4);
        ListenerCallQueue queue = new ListenerCallQueue();
        try {
            queue.addListener(listener, (Executor)service);
            CountDownLatch latch = new CountDownLatch(1);
            ConcurrentHashMultiset counters = ConcurrentHashMultiset.create();
            queue.enqueue(this.incrementingEvent((Multiset<Object>)counters, listener, 1));
            queue.enqueue(this.incrementingEvent((Multiset<Object>)counters, listener, 2));
            queue.enqueue(this.incrementingEvent((Multiset<Object>)counters, listener, 3));
            queue.enqueue(this.incrementingEvent((Multiset<Object>)counters, listener, 4));
            queue.enqueue(this.countDownEvent(latch));
            ListenerCallQueueTest.assertEquals((int)0, (int)counters.size());
            queue.dispatch();
            latch.await();
            ListenerCallQueueTest.assertEquals(ListenerCallQueueTest.multiset(listener, 4), (Object)counters);
        }
        finally {
            service.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnqueueAndDispatch_multithreaded_withThrowingRunnable() throws InterruptedException {
        Object listener = new Object();
        ExecutorService service = Executors.newFixedThreadPool(4);
        ListenerCallQueue queue = new ListenerCallQueue();
        try {
            queue.addListener(listener, (Executor)service);
            CountDownLatch latch = new CountDownLatch(1);
            ConcurrentHashMultiset counters = ConcurrentHashMultiset.create();
            queue.enqueue(this.incrementingEvent((Multiset<Object>)counters, listener, 1));
            queue.enqueue(THROWING_EVENT);
            queue.enqueue(this.incrementingEvent((Multiset<Object>)counters, listener, 2));
            queue.enqueue(THROWING_EVENT);
            queue.enqueue(this.incrementingEvent((Multiset<Object>)counters, listener, 3));
            queue.enqueue(THROWING_EVENT);
            queue.enqueue(this.incrementingEvent((Multiset<Object>)counters, listener, 4));
            queue.enqueue(THROWING_EVENT);
            queue.enqueue(this.countDownEvent(latch));
            ListenerCallQueueTest.assertEquals((int)0, (int)counters.size());
            queue.dispatch();
            latch.await();
            ListenerCallQueueTest.assertEquals(ListenerCallQueueTest.multiset(listener, 4), (Object)counters);
        }
        finally {
            service.shutdown();
        }
    }

    private ListenerCallQueue.Event<Object> incrementingEvent(Multiset<Object> counters, Object expectedListener, int expectedCount) {
        return this.incrementingEvent(counters, (Multiset<Object>)ListenerCallQueueTest.multiset(expectedListener, expectedCount));
    }

    private static <T> ImmutableMultiset<T> multiset(T value, int count) {
        return ListenerCallQueueTest.multiset(ImmutableMap.of(value, (Object)count));
    }

    private static <T> ImmutableMultiset<T> multiset(T value1, int count1, T value2, int count2) {
        return ListenerCallQueueTest.multiset(ImmutableMap.of(value1, (Object)count1, value2, (Object)count2));
    }

    private static <T> ImmutableMultiset<T> multiset(Map<T, Integer> counts) {
        ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
        for (Map.Entry<T, Integer> entry : counts.entrySet()) {
            builder.addCopies(entry.getKey(), entry.getValue().intValue());
        }
        return builder.build();
    }

    private ListenerCallQueue.Event<Object> incrementingEvent(final Multiset<Object> counters, final Multiset<Object> expected) {
        return new ListenerCallQueue.Event<Object>(){

            public void call(Object listener) {
                counters.add(listener);
                TestCase.assertEquals((int)expected.count(listener), (int)counters.count(listener));
            }

            public String toString() {
                return "incrementing";
            }
        };
    }

    private ListenerCallQueue.Event<Object> countDownEvent(final CountDownLatch latch) {
        return new ListenerCallQueue.Event<Object>(){

            public void call(Object listener) {
                latch.countDown();
            }

            public String toString() {
                return "countDown";
            }
        };
    }

    static final class MyListener {
        MyListener() {
        }

        public String toString() {
            return "MyListener";
        }
    }
}

