/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.collect.ObjectArrays;
import com.google.common.util.concurrent.Monitor;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@CanIgnoreReturnValue
public class MonitorBasedArrayBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    final E[] items;
    int takeIndex;
    int putIndex;
    private int count;
    final Monitor monitor;
    private final Monitor.Guard notEmpty;
    private final Monitor.Guard notFull;

    final int inc(int i) {
        return ++i == this.items.length ? 0 : i;
    }

    private void insert(E x) {
        this.items[this.putIndex] = x;
        this.putIndex = this.inc(this.putIndex);
        ++this.count;
    }

    private E extract() {
        E[] items = this.items;
        E x = items[this.takeIndex];
        items[this.takeIndex] = null;
        this.takeIndex = this.inc(this.takeIndex);
        --this.count;
        return x;
    }

    void removeAt(int i) {
        E[] items = this.items;
        if (i == this.takeIndex) {
            items[this.takeIndex] = null;
            this.takeIndex = this.inc(this.takeIndex);
        } else {
            int nexti;
            while ((nexti = this.inc(i)) != this.putIndex) {
                items[i] = items[nexti];
                i = nexti;
            }
            items[i] = null;
            this.putIndex = i;
        }
        --this.count;
    }

    public MonitorBasedArrayBlockingQueue(int capacity) {
        this(capacity, false);
    }

    public MonitorBasedArrayBlockingQueue(int capacity, boolean fair) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.items = MonitorBasedArrayBlockingQueue.newEArray(capacity);
        this.monitor = new Monitor(fair);
        this.notEmpty = new Monitor.Guard(this.monitor){

            public boolean isSatisfied() {
                return MonitorBasedArrayBlockingQueue.this.count > 0;
            }
        };
        this.notFull = new Monitor.Guard(this.monitor){

            public boolean isSatisfied() {
                return MonitorBasedArrayBlockingQueue.this.count < MonitorBasedArrayBlockingQueue.this.items.length;
            }
        };
    }

    private static <E> E[] newEArray(int capacity) {
        return new Object[capacity];
    }

    public MonitorBasedArrayBlockingQueue(int capacity, boolean fair, Collection<? extends E> c) {
        this(capacity, fair);
        if (capacity < c.size()) {
            throw new IllegalArgumentException();
        }
        for (E e : c) {
            this.add(e);
        }
    }

    @Override
    public boolean add(E e) {
        return super.add(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        Monitor monitor = this.monitor;
        if (monitor.enterIf(this.notFull)) {
            try {
                this.insert(e);
                boolean bl = true;
                return bl;
            }
            finally {
                monitor.leave();
            }
        }
        return false;
    }

    @Override
    public void put(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        Monitor monitor = this.monitor;
        monitor.enterWhen(this.notFull);
        try {
            this.insert(e);
        }
        finally {
            monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        Monitor monitor = this.monitor;
        if (monitor.enterWhen(this.notFull, timeout, unit)) {
            try {
                this.insert(e);
                boolean bl = true;
                return bl;
            }
            finally {
                monitor.leave();
            }
        }
        return false;
    }

    @Override
    public E poll() {
        Monitor monitor = this.monitor;
        if (monitor.enterIf(this.notEmpty)) {
            try {
                E e = this.extract();
                return e;
            }
            finally {
                monitor.leave();
            }
        }
        return null;
    }

    @Override
    public E take() throws InterruptedException {
        Monitor monitor = this.monitor;
        monitor.enterWhen(this.notEmpty);
        try {
            E e = this.extract();
            return e;
        }
        finally {
            monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        Monitor monitor = this.monitor;
        if (monitor.enterWhen(this.notEmpty, timeout, unit)) {
            try {
                E e = this.extract();
                return e;
            }
            finally {
                monitor.leave();
            }
        }
        return null;
    }

    @Override
    public E peek() {
        Monitor monitor = this.monitor;
        if (monitor.enterIf(this.notEmpty)) {
            try {
                E e = this.items[this.takeIndex];
                return e;
            }
            finally {
                monitor.leave();
            }
        }
        return null;
    }

    @Override
    public int size() {
        Monitor monitor = this.monitor;
        monitor.enter();
        try {
            int n = this.count;
            return n;
        }
        finally {
            monitor.leave();
        }
    }

    @Override
    public int remainingCapacity() {
        Monitor monitor = this.monitor;
        monitor.enter();
        try {
            int n = this.items.length - this.count;
            return n;
        }
        finally {
            monitor.leave();
        }
    }

    @Override
    public boolean remove(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        E[] items = this.items;
        Monitor monitor = this.monitor;
        monitor.enter();
        try {
            int i = this.takeIndex;
            int k = 0;
            while (true) {
                if (k++ >= this.count) {
                    boolean bl = false;
                    return bl;
                }
                if (o.equals(items[i])) {
                    this.removeAt(i);
                    boolean bl = true;
                    return bl;
                }
                i = this.inc(i);
            }
        }
        finally {
            monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        E[] items = this.items;
        Monitor monitor = this.monitor;
        monitor.enter();
        try {
            int i = this.takeIndex;
            int k = 0;
            while (k++ < this.count) {
                if (o.equals(items[i])) {
                    boolean bl = true;
                    return bl;
                }
                i = this.inc(i);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        E[] items = this.items;
        Monitor monitor = this.monitor;
        monitor.enter();
        try {
            Object[] a = new Object[this.count];
            int k = 0;
            int i = this.takeIndex;
            while (k < this.count) {
                a[k++] = items[i];
                i = this.inc(i);
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        E[] items = this.items;
        Monitor monitor = this.monitor;
        monitor.enter();
        try {
            if (a.length < this.count) {
                a = ObjectArrays.newArray((Object[])a, (int)this.count);
            }
            int k = 0;
            int i = this.takeIndex;
            while (k < this.count) {
                E t = items[i];
                a[k++] = t;
                i = this.inc(i);
            }
            if (a.length > this.count) {
                a[this.count] = null;
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            monitor.leave();
        }
    }

    @Override
    public String toString() {
        Monitor monitor = this.monitor;
        monitor.enter();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        E[] items = this.items;
        Monitor monitor = this.monitor;
        monitor.enter();
        try {
            int i = this.takeIndex;
            int k = this.count;
            while (k-- > 0) {
                items[i] = null;
                i = this.inc(i);
            }
            this.count = 0;
            this.putIndex = 0;
            this.takeIndex = 0;
        }
        finally {
            monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        E[] items = this.items;
        Monitor monitor = this.monitor;
        monitor.enter();
        try {
            int n;
            int i = this.takeIndex;
            int max = this.count;
            for (n = 0; n < max; ++n) {
                c.add(items[i]);
                items[i] = null;
                i = this.inc(i);
            }
            if (n > 0) {
                this.count = 0;
                this.putIndex = 0;
                this.takeIndex = 0;
            }
            int n2 = n;
            return n2;
        }
        finally {
            monitor.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        E[] items = this.items;
        Monitor monitor = this.monitor;
        monitor.enter();
        try {
            int n;
            int max;
            int i = this.takeIndex;
            int n2 = max = maxElements < this.count ? maxElements : this.count;
            for (n = 0; n < max; ++n) {
                c.add(items[i]);
                items[i] = null;
                i = this.inc(i);
            }
            if (n > 0) {
                this.count -= n;
                this.takeIndex = i;
            }
            int n3 = n;
            return n3;
        }
        finally {
            monitor.leave();
        }
    }

    @Override
    public Iterator<E> iterator() {
        Monitor monitor = this.monitor;
        monitor.enter();
        try {
            Itr itr = new Itr();
            return itr;
        }
        finally {
            monitor.leave();
        }
    }

    private class Itr
    implements Iterator<E> {
        private int nextIndex;
        private E nextItem;
        private int lastRet = -1;

        Itr() {
            if (MonitorBasedArrayBlockingQueue.this.count == 0) {
                this.nextIndex = -1;
            } else {
                this.nextIndex = MonitorBasedArrayBlockingQueue.this.takeIndex;
                this.nextItem = MonitorBasedArrayBlockingQueue.this.items[MonitorBasedArrayBlockingQueue.this.takeIndex];
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        private void checkNext() {
            if (this.nextIndex == MonitorBasedArrayBlockingQueue.this.putIndex) {
                this.nextIndex = -1;
                this.nextItem = null;
            } else {
                this.nextItem = MonitorBasedArrayBlockingQueue.this.items[this.nextIndex];
                if (this.nextItem == null) {
                    this.nextIndex = -1;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            Monitor monitor = MonitorBasedArrayBlockingQueue.this.monitor;
            monitor.enter();
            try {
                if (this.nextIndex < 0) {
                    throw new NoSuchElementException();
                }
                this.lastRet = this.nextIndex;
                Object x = this.nextItem;
                this.nextIndex = MonitorBasedArrayBlockingQueue.this.inc(this.nextIndex);
                this.checkNext();
                Object e = x;
                return e;
            }
            finally {
                monitor.leave();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Monitor monitor = MonitorBasedArrayBlockingQueue.this.monitor;
            monitor.enter();
            try {
                int i = this.lastRet;
                if (i == -1) {
                    throw new IllegalStateException();
                }
                this.lastRet = -1;
                int ti = MonitorBasedArrayBlockingQueue.this.takeIndex;
                MonitorBasedArrayBlockingQueue.this.removeAt(i);
                this.nextIndex = i == ti ? MonitorBasedArrayBlockingQueue.this.takeIndex : i;
                this.checkNext();
            }
            finally {
                monitor.leave();
            }
        }
    }
}

