/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.testing.NullPointerTester;
import com.google.common.testing.TearDownStack;
import com.google.common.util.concurrent.Monitor;
import com.google.common.util.concurrent.TestThread;
import java.util.Random;
import junit.framework.TestCase;

public abstract class MonitorTestCase
extends TestCase {
    private final boolean interruptible;
    private Monitor monitor;
    private final TearDownStack tearDownStack = new TearDownStack(true);
    private TestThread<Monitor> thread1;
    private TestThread<Monitor> thread2;

    protected MonitorTestCase(boolean interruptible) {
        this.interruptible = interruptible;
    }

    protected final void setUp() throws Exception {
        boolean fair = new Random().nextBoolean();
        this.monitor = new Monitor(fair);
        this.thread1 = new TestThread<Monitor>(this.monitor, "TestThread #1");
        this.tearDownStack.addTearDown(this.thread1);
        this.thread2 = new TestThread<Monitor>(this.monitor, "TestThread #2");
        this.tearDownStack.addTearDown(this.thread2);
    }

    protected final void tearDown() {
        this.tearDownStack.runTearDown();
    }

    private String enter() {
        return this.interruptible ? "enterInterruptibly" : "enter";
    }

    private String tryEnter() {
        return "tryEnter";
    }

    private String enterIf() {
        return this.interruptible ? "enterIfInterruptibly" : "enterIf";
    }

    private String tryEnterIf() {
        return "tryEnterIf";
    }

    private String enterWhen() {
        return this.interruptible ? "enterWhen" : "enterWhenUninterruptibly";
    }

    private String waitFor() {
        return this.interruptible ? "waitFor" : "waitForUninterruptibly";
    }

    private String leave() {
        return "leave";
    }

    public final void testMutualExclusion() throws Exception {
        this.thread1.callAndAssertReturns(this.enter(), new Object[0]);
        this.thread2.callAndAssertBlocks(this.enter(), new Object[0]);
        this.thread1.callAndAssertReturns(this.leave(), new Object[0]);
        this.thread2.assertPriorCallReturns(this.enter());
    }

    public final void testTryEnter() throws Exception {
        this.thread1.callAndAssertReturns(true, this.tryEnter(), new Object[0]);
        this.thread2.callAndAssertReturns(false, this.tryEnter(), new Object[0]);
        this.thread1.callAndAssertReturns(true, this.tryEnter(), new Object[0]);
        this.thread2.callAndAssertReturns(false, this.tryEnter(), new Object[0]);
        this.thread1.callAndAssertReturns(this.leave(), new Object[0]);
        this.thread2.callAndAssertReturns(false, this.tryEnter(), new Object[0]);
        this.thread1.callAndAssertReturns(this.leave(), new Object[0]);
        this.thread2.callAndAssertReturns(true, this.tryEnter(), new Object[0]);
    }

    public final void testSystemStateMethods() throws Exception {
        this.checkSystemStateMethods(0);
        this.thread1.callAndAssertReturns(this.enter(), new Object[0]);
        this.checkSystemStateMethods(1);
        this.thread1.callAndAssertReturns(this.enter(), new Object[0]);
        this.checkSystemStateMethods(2);
        this.thread1.callAndAssertReturns(this.leave(), new Object[0]);
        this.checkSystemStateMethods(1);
        this.thread1.callAndAssertReturns(this.leave(), new Object[0]);
        this.checkSystemStateMethods(0);
    }

    private void checkSystemStateMethods(int enterCount) throws Exception {
        this.thread1.callAndAssertReturns(enterCount != 0, "isOccupied", new Object[0]);
        this.thread1.callAndAssertReturns(enterCount != 0, "isOccupiedByCurrentThread", new Object[0]);
        this.thread1.callAndAssertReturns(enterCount, "getOccupiedDepth", new Object[0]);
        this.thread2.callAndAssertReturns(enterCount != 0, "isOccupied", new Object[0]);
        this.thread2.callAndAssertReturns(false, "isOccupiedByCurrentThread", new Object[0]);
        this.thread2.callAndAssertReturns(0, "getOccupiedDepth", new Object[0]);
    }

    public final void testEnterWhen_initiallyTrue() throws Exception {
        TestGuard guard = new TestGuard(true);
        this.thread1.callAndAssertReturns(this.enterWhen(), new Object[]{guard});
        this.thread1.callAndAssertReturns(this.enterWhen(), this.monitor.newGuard(() -> true));
    }

    public final void testEnterWhen_initiallyFalse() throws Exception {
        TestGuard guard = new TestGuard(false);
        this.thread1.callAndAssertWaits(this.enterWhen(), (Object)guard);
        this.monitor.enter();
        guard.setSatisfied(true);
        this.monitor.leave();
        this.thread1.assertPriorCallReturns(this.enterWhen());
    }

    public final void testEnterWhen_alreadyOccupied() throws Exception {
        TestGuard guard = new TestGuard(true);
        this.thread2.callAndAssertReturns(this.enter(), new Object[0]);
        this.thread1.callAndAssertBlocks(this.enterWhen(), new Object[]{guard});
        this.thread2.callAndAssertReturns(this.leave(), new Object[0]);
        this.thread1.assertPriorCallReturns(this.enterWhen());
    }

    public final void testEnterIf_initiallyTrue() throws Exception {
        TestGuard guard = new TestGuard(true);
        this.thread1.callAndAssertReturns(true, this.enterIf(), new Object[]{guard});
        this.thread2.callAndAssertBlocks(this.enter(), new Object[0]);
    }

    public final void testEnterIf_initiallyFalse() throws Exception {
        TestGuard guard = new TestGuard(false);
        this.thread1.callAndAssertReturns(false, this.enterIf(), new Object[]{guard});
        this.thread2.callAndAssertReturns(this.enter(), new Object[0]);
    }

    public final void testEnterIf_alreadyOccupied() throws Exception {
        TestGuard guard = new TestGuard(true);
        this.thread2.callAndAssertReturns(this.enter(), new Object[0]);
        this.thread1.callAndAssertBlocks(this.enterIf(), new Object[]{guard});
        this.thread2.callAndAssertReturns(this.leave(), new Object[0]);
        this.thread1.assertPriorCallReturns(true, this.enterIf());
    }

    public final void testTryEnterIf_initiallyTrue() throws Exception {
        TestGuard guard = new TestGuard(true);
        this.thread1.callAndAssertReturns(true, this.tryEnterIf(), new Object[]{guard});
        this.thread2.callAndAssertBlocks(this.enter(), new Object[0]);
    }

    public final void testTryEnterIf_initiallyFalse() throws Exception {
        TestGuard guard = new TestGuard(false);
        this.thread1.callAndAssertReturns(false, this.tryEnterIf(), new Object[]{guard});
        this.thread2.callAndAssertReturns(this.enter(), new Object[0]);
    }

    public final void testTryEnterIf_alreadyOccupied() throws Exception {
        TestGuard guard = new TestGuard(true);
        this.thread2.callAndAssertReturns(this.enter(), new Object[0]);
        this.thread1.callAndAssertReturns(false, this.tryEnterIf(), new Object[]{guard});
    }

    public final void testWaitFor_initiallyTrue() throws Exception {
        TestGuard guard = new TestGuard(true);
        this.thread1.callAndAssertReturns(this.enter(), new Object[0]);
        this.thread1.callAndAssertReturns(this.waitFor(), new Object[]{guard});
    }

    public final void testWaitFor_initiallyFalse() throws Exception {
        TestGuard guard = new TestGuard(false);
        this.thread1.callAndAssertReturns(this.enter(), new Object[0]);
        this.thread1.callAndAssertWaits(this.waitFor(), (Object)guard);
        this.monitor.enter();
        guard.setSatisfied(true);
        this.monitor.leave();
        this.thread1.assertPriorCallReturns(this.waitFor());
    }

    public final void testWaitFor_withoutEnter() throws Exception {
        TestGuard guard = new TestGuard(true);
        this.thread1.callAndAssertThrows(IllegalMonitorStateException.class, this.waitFor(), new Object[]{guard});
    }

    public void testNulls() {
        this.monitor.enter();
        new NullPointerTester().setDefault(Monitor.Guard.class, (Object)new TestGuard(true)).testAllPublicInstanceMethods((Object)this.monitor);
    }

    public class TestGuard
    extends Monitor.Guard {
        private volatile boolean satisfied;

        public TestGuard(boolean satisfied) {
            super(MonitorTestCase.this.monitor);
            this.satisfied = satisfied;
        }

        public boolean isSatisfied() {
            return this.satisfied;
        }

        public void setSatisfied(boolean satisfied) {
            this.satisfied = satisfied;
        }
    }
}

