/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Range;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.TimeLimiter;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;

public class SimpleTimeLimiterTest
extends TestCase {
    private static final long DELAY_MS = 50L;
    private static final long ENOUGH_MS = 500L;
    private static final long NOT_ENOUGH_MS = 5L;
    private static final String GOOD_CALLABLE_RESULT = "good callable result";
    private static final Callable<String> GOOD_CALLABLE = new Callable<String>(){

        @Override
        public String call() throws InterruptedException {
            TimeUnit.MILLISECONDS.sleep(50L);
            return SimpleTimeLimiterTest.GOOD_CALLABLE_RESULT;
        }
    };
    private static final Callable<String> BAD_CALLABLE = new Callable<String>(){

        @Override
        public String call() throws InterruptedException, SampleException {
            TimeUnit.MILLISECONDS.sleep(50L);
            throw new SampleException();
        }
    };
    private static final Runnable GOOD_RUNNABLE = new Runnable(){

        @Override
        public void run() {
            try {
                TimeUnit.MILLISECONDS.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private static final Runnable BAD_RUNNABLE = new Runnable(){

        @Override
        public void run() {
            try {
                TimeUnit.MILLISECONDS.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            throw new SampleRuntimeException();
        }
    };
    private TimeLimiter service;
    private static final ExecutorService executor = Executors.newFixedThreadPool(1);

    protected void setUp() throws Exception {
        super.setUp();
        this.service = SimpleTimeLimiter.create((ExecutorService)executor);
    }

    public void testNewProxy_goodMethodWithEnoughTime() throws Exception {
        SampleImpl target = new SampleImpl(50L);
        Sample proxy = (Sample)this.service.newProxy((Object)target, Sample.class, 500L, TimeUnit.MILLISECONDS);
        Stopwatch stopwatch = Stopwatch.createStarted();
        String result = proxy.sleepThenReturnInput("x");
        Truth.assertThat((String)result).isEqualTo((Object)"x");
        Truth.assertThat((Long)stopwatch.elapsed(TimeUnit.MILLISECONDS)).isIn(Range.closed((Comparable)Long.valueOf(50L), (Comparable)Long.valueOf(500L)));
        Truth.assertThat((Boolean)target.finished).isTrue();
    }

    public void testNewProxy_goodMethodWithNotEnoughTime() throws Exception {
        SampleImpl target = new SampleImpl(9999L);
        Sample proxy = (Sample)this.service.newProxy((Object)target, Sample.class, 5L, TimeUnit.MILLISECONDS);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            proxy.sleepThenReturnInput("x");
            SimpleTimeLimiterTest.fail((String)"no exception thrown");
        }
        catch (UncheckedTimeoutException uncheckedTimeoutException) {
            // empty catch block
        }
        Truth.assertThat((Long)stopwatch.elapsed(TimeUnit.MILLISECONDS)).isIn(Range.closed((Comparable)Long.valueOf(5L), (Comparable)Long.valueOf(100L)));
        Truth.assertThat((Boolean)target.finished).isFalse();
        TimeUnit.MILLISECONDS.sleep(500L);
        Truth.assertThat((Boolean)target.finished).isFalse();
    }

    public void testNewProxy_badMethodWithEnoughTime() throws Exception {
        SampleImpl target = new SampleImpl(50L);
        Sample proxy = (Sample)this.service.newProxy((Object)target, Sample.class, 500L, TimeUnit.MILLISECONDS);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            proxy.sleepThenThrowException();
            SimpleTimeLimiterTest.fail((String)"no exception thrown");
        }
        catch (SampleException sampleException) {
            // empty catch block
        }
        Truth.assertThat((Long)stopwatch.elapsed(TimeUnit.MILLISECONDS)).isIn(Range.closed((Comparable)Long.valueOf(50L), (Comparable)Long.valueOf(500L)));
    }

    public void testNewProxy_badMethodWithNotEnoughTime() throws Exception {
        SampleImpl target = new SampleImpl(9999L);
        Sample proxy = (Sample)this.service.newProxy((Object)target, Sample.class, 5L, TimeUnit.MILLISECONDS);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            proxy.sleepThenThrowException();
            SimpleTimeLimiterTest.fail((String)"no exception thrown");
        }
        catch (UncheckedTimeoutException uncheckedTimeoutException) {
            // empty catch block
        }
        Truth.assertThat((Long)stopwatch.elapsed(TimeUnit.MILLISECONDS)).isIn(Range.closed((Comparable)Long.valueOf(5L), (Comparable)Long.valueOf(100L)));
    }

    public void testCallWithTimeout_goodCallableWithEnoughTime() throws Exception {
        Stopwatch stopwatch = Stopwatch.createStarted();
        String result = (String)this.service.callWithTimeout(GOOD_CALLABLE, 500L, TimeUnit.MILLISECONDS);
        Truth.assertThat((String)result).isEqualTo((Object)GOOD_CALLABLE_RESULT);
        Truth.assertThat((Long)stopwatch.elapsed(TimeUnit.MILLISECONDS)).isIn(Range.closed((Comparable)Long.valueOf(50L), (Comparable)Long.valueOf(500L)));
    }

    public void testCallWithTimeout_goodCallableWithNotEnoughTime() throws Exception {
        try {
            this.service.callWithTimeout(GOOD_CALLABLE, 5L, TimeUnit.MILLISECONDS);
            SimpleTimeLimiterTest.fail((String)"no exception thrown");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public void testCallWithTimeout_badCallableWithEnoughTime() throws Exception {
        try {
            this.service.callWithTimeout(BAD_CALLABLE, 500L, TimeUnit.MILLISECONDS);
            SimpleTimeLimiterTest.fail((String)"no exception thrown");
        }
        catch (ExecutionException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(SampleException.class);
        }
    }

    public void testCallUninterruptiblyWithTimeout_goodCallableWithEnoughTime() throws Exception {
        Stopwatch stopwatch = Stopwatch.createStarted();
        String result = (String)this.service.callUninterruptiblyWithTimeout(GOOD_CALLABLE, 500L, TimeUnit.MILLISECONDS);
        Truth.assertThat((String)result).isEqualTo((Object)GOOD_CALLABLE_RESULT);
        Truth.assertThat((Long)stopwatch.elapsed(TimeUnit.MILLISECONDS)).isIn(Range.closed((Comparable)Long.valueOf(50L), (Comparable)Long.valueOf(500L)));
    }

    public void testCallUninterruptiblyWithTimeout_goodCallableWithNotEnoughTime() throws Exception {
        try {
            this.service.callUninterruptiblyWithTimeout(GOOD_CALLABLE, 5L, TimeUnit.MILLISECONDS);
            SimpleTimeLimiterTest.fail((String)"no exception thrown");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public void testCallUninterruptiblyWithTimeout_badCallableWithEnoughTime() throws Exception {
        try {
            this.service.callUninterruptiblyWithTimeout(BAD_CALLABLE, 500L, TimeUnit.MILLISECONDS);
            SimpleTimeLimiterTest.fail((String)"no exception thrown");
        }
        catch (ExecutionException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(SampleException.class);
        }
    }

    public void testRunWithTimeout_goodRunnableWithEnoughTime() throws Exception {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.service.runWithTimeout(GOOD_RUNNABLE, 500L, TimeUnit.MILLISECONDS);
        Truth.assertThat((Long)stopwatch.elapsed(TimeUnit.MILLISECONDS)).isIn(Range.closed((Comparable)Long.valueOf(50L), (Comparable)Long.valueOf(500L)));
    }

    public void testRunWithTimeout_goodRunnableWithNotEnoughTime() throws Exception {
        try {
            this.service.runWithTimeout(GOOD_RUNNABLE, 5L, TimeUnit.MILLISECONDS);
            SimpleTimeLimiterTest.fail((String)"no exception thrown");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public void testRunWithTimeout_badRunnableWithEnoughTime() throws Exception {
        try {
            this.service.runWithTimeout(BAD_RUNNABLE, 500L, TimeUnit.MILLISECONDS);
            SimpleTimeLimiterTest.fail((String)"no exception thrown");
        }
        catch (UncheckedExecutionException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(SampleRuntimeException.class);
        }
    }

    public void testRunUninterruptiblyWithTimeout_goodRunnableWithEnoughTime() throws Exception {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.service.runUninterruptiblyWithTimeout(GOOD_RUNNABLE, 500L, TimeUnit.MILLISECONDS);
        Truth.assertThat((Long)stopwatch.elapsed(TimeUnit.MILLISECONDS)).isIn(Range.closed((Comparable)Long.valueOf(50L), (Comparable)Long.valueOf(500L)));
    }

    public void testRunUninterruptiblyWithTimeout_goodRunnableWithNotEnoughTime() throws Exception {
        try {
            this.service.runUninterruptiblyWithTimeout(GOOD_RUNNABLE, 5L, TimeUnit.MILLISECONDS);
            SimpleTimeLimiterTest.fail((String)"no exception thrown");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public void testRunUninterruptiblyWithTimeout_badRunnableWithEnoughTime() throws Exception {
        try {
            this.service.runUninterruptiblyWithTimeout(BAD_RUNNABLE, 500L, TimeUnit.MILLISECONDS);
            SimpleTimeLimiterTest.fail((String)"no exception thrown");
        }
        catch (UncheckedExecutionException expected) {
            Truth.assertThat((Throwable)expected.getCause()).isInstanceOf(SampleRuntimeException.class);
        }
    }

    private static class SampleImpl
    implements Sample {
        final long delayMillis;
        boolean finished;

        SampleImpl(long delayMillis) {
            this.delayMillis = delayMillis;
        }

        @Override
        public String sleepThenReturnInput(String input) {
            try {
                TimeUnit.MILLISECONDS.sleep(this.delayMillis);
                this.finished = true;
                return input;
            }
            catch (InterruptedException e) {
                return null;
            }
        }

        @Override
        public void sleepThenThrowException() throws SampleException {
            try {
                TimeUnit.MILLISECONDS.sleep(this.delayMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new SampleException();
        }
    }

    private static class SampleRuntimeException
    extends RuntimeException {
        private SampleRuntimeException() {
        }
    }

    private static class SampleException
    extends Exception {
        private SampleException() {
        }
    }

    private static interface Sample {
        public String sleepThenReturnInput(String var1);

        public void sleepThenThrowException() throws SampleException;
    }
}

