/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.caliper.api.Footprint;
import com.google.caliper.api.VmOptions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Striped;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@VmOptions(value={"-Xms12g", "-Xmx12g", "-d64"})
public class StripedBenchmark {
    private static final Supplier<Lock> LOCK_SUPPLIER = new Supplier<Lock>(){

        public Lock get() {
            return new ReentrantLock();
        }
    };
    @Param(value={"2", "8", "64", "1024", "65536"})
    int numStripes;
    @Param
    Impl impl;
    private Striped<Lock> striped;
    private int[] stripes;
    private List<Integer> bulkGetSet;
    final List<Lock> locks;

    public StripedBenchmark() {
        this.locks = new ArrayList<Lock>(this.numStripes);
    }

    @BeforeExperiment
    void setUp() {
        this.striped = this.impl.get(this.numStripes);
        this.stripes = new int[this.numStripes];
        for (int i = 0; i < this.numStripes; ++i) {
            this.stripes[i] = i;
        }
        List asList = Ints.asList((int[])this.stripes);
        Collections.shuffle(asList, new Random(-559038737L));
        this.bulkGetSet = ImmutableList.copyOf((Iterable)Iterables.limit((Iterable)Iterables.cycle((Iterable)asList), (int)10));
    }

    @Footprint
    Object sizeOfStriped() {
        return this.impl.get(this.numStripes);
    }

    @Footprint
    Object sizeOfPopulatedStriped() {
        this.locks.clear();
        Striped<Lock> striped = this.impl.get(this.numStripes);
        for (int i : this.stripes) {
            this.locks.add((Lock)striped.getAt(i));
        }
        return striped;
    }

    @Benchmark
    long timeConstruct(long reps) {
        long rvalue = 0L;
        int numStripesLocal = this.numStripes;
        Impl implLocal = this.impl;
        for (long i = 0L; i < reps; ++i) {
            rvalue += (long)implLocal.get(numStripesLocal).hashCode();
        }
        return rvalue;
    }

    @Benchmark
    long timeGetAt(long reps) {
        long rvalue = 0L;
        int[] stripesLocal = this.stripes;
        int mask = this.numStripes - 1;
        Striped<Lock> stripedLocal = this.striped;
        for (long i = 0L; i < reps; ++i) {
            rvalue += (long)((Lock)stripedLocal.getAt(stripesLocal[(int)(i & (long)mask)])).hashCode();
        }
        return rvalue;
    }

    @Benchmark
    long timeBulkGet(long reps) {
        long rvalue = 0L;
        List<Integer> bulkGetSetLocal = this.bulkGetSet;
        Striped<Lock> stripedLocal = this.striped;
        for (long i = 0L; i < reps; ++i) {
            rvalue += (long)stripedLocal.bulkGet(bulkGetSetLocal).hashCode();
        }
        return rvalue;
    }

    static enum Impl {
        EAGER{

            @Override
            Striped<Lock> get(int stripes) {
                return Striped.lock((int)stripes);
            }
        }
        ,
        LAZY_SMALL{

            @Override
            Striped<Lock> get(int stripes) {
                return new Striped.SmallLazyStriped(stripes, LOCK_SUPPLIER);
            }
        }
        ,
        LAZY_LARGE{

            @Override
            Striped<Lock> get(int stripes) {
                return new Striped.LargeLazyStriped(stripes, LOCK_SUPPLIER);
            }
        };


        abstract Striped<Lock> get(int var1);
    }
}

