/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.util.concurrent.Callables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.TestPlatform;
import com.google.common.util.concurrent.TrustedListenableFutureTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class TrustedListenableFutureTaskTest
extends TestCase {
    public void testSuccessful() throws Exception {
        TrustedListenableFutureTask task = TrustedListenableFutureTask.create((Callable)Callables.returning((Object)2));
        TrustedListenableFutureTaskTest.assertFalse((boolean)task.isDone());
        task.run();
        TrustedListenableFutureTaskTest.assertTrue((boolean)task.isDone());
        TrustedListenableFutureTaskTest.assertFalse((boolean)task.isCancelled());
        TrustedListenableFutureTaskTest.assertEquals((int)2, (int)((Integer)Futures.getDone((Future)task)));
    }

    public void testCancelled() throws Exception {
        TrustedListenableFutureTask task = TrustedListenableFutureTask.create((Callable)Callables.returning((Object)2));
        TrustedListenableFutureTaskTest.assertFalse((boolean)task.isDone());
        task.cancel(false);
        TrustedListenableFutureTaskTest.assertTrue((boolean)task.isDone());
        TrustedListenableFutureTaskTest.assertTrue((boolean)task.isCancelled());
        TrustedListenableFutureTaskTest.assertFalse((boolean)task.wasInterrupted());
        try {
            Futures.getDone((Future)task);
            TrustedListenableFutureTaskTest.fail();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        TestPlatform.verifyThreadWasNotInterrupted();
    }

    public void testFailed() throws Exception {
        final Exception e = new Exception();
        TrustedListenableFutureTask task = TrustedListenableFutureTask.create((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                throw e;
            }
        });
        task.run();
        TrustedListenableFutureTaskTest.assertTrue((boolean)task.isDone());
        TrustedListenableFutureTaskTest.assertFalse((boolean)task.isCancelled());
        try {
            Futures.getDone((Future)task);
            TrustedListenableFutureTaskTest.fail();
        }
        catch (ExecutionException executionException) {
            TrustedListenableFutureTaskTest.assertEquals((Object)e, (Object)executionException.getCause());
        }
    }

    @GwtIncompatible
    public void testCancel_interrupted() throws Exception {
        final AtomicBoolean interruptedExceptionThrown = new AtomicBoolean();
        final CountDownLatch enterLatch = new CountDownLatch(1);
        final CountDownLatch exitLatch = new CountDownLatch(1);
        final TrustedListenableFutureTask task = TrustedListenableFutureTask.create((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                enterLatch.countDown();
                try {
                    new CountDownLatch(1).await();
                    throw new AssertionError();
                }
                catch (InterruptedException e) {
                    interruptedExceptionThrown.set(true);
                    throw e;
                }
            }
        });
        TrustedListenableFutureTaskTest.assertFalse((boolean)task.isDone());
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    task.run();
                }
                finally {
                    exitLatch.countDown();
                }
            }
        });
        thread.start();
        enterLatch.await();
        TrustedListenableFutureTaskTest.assertFalse((boolean)task.isDone());
        task.cancel(true);
        TrustedListenableFutureTaskTest.assertTrue((boolean)task.isDone());
        TrustedListenableFutureTaskTest.assertTrue((boolean)task.isCancelled());
        TrustedListenableFutureTaskTest.assertTrue((boolean)task.wasInterrupted());
        try {
            task.get();
            TrustedListenableFutureTaskTest.fail();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        exitLatch.await();
        TrustedListenableFutureTaskTest.assertTrue((boolean)interruptedExceptionThrown.get());
    }

    @GwtIncompatible
    public void testRunIdempotency() throws Exception {
        int numThreads = 10;
        ExecutorService executor = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 1000; ++i) {
            final AtomicInteger counter = new AtomicInteger();
            final TrustedListenableFutureTask task = TrustedListenableFutureTask.create((Callable)new Callable<Integer>(){

                @Override
                public Integer call() {
                    return counter.incrementAndGet();
                }
            });
            final CyclicBarrier barrier = new CyclicBarrier(11);
            Runnable wrapper = new Runnable(){

                @Override
                public void run() {
                    TrustedListenableFutureTaskTest.this.awaitUnchecked(barrier);
                    task.run();
                    TrustedListenableFutureTaskTest.this.awaitUnchecked(barrier);
                }
            };
            for (int j = 0; j < 10; ++j) {
                executor.execute(wrapper);
            }
            barrier.await();
            barrier.await();
            TrustedListenableFutureTaskTest.assertEquals((int)1, (int)((Integer)task.get()));
            TrustedListenableFutureTaskTest.assertEquals((int)1, (int)counter.get());
        }
        executor.shutdown();
    }

    @GwtIncompatible
    private void awaitUnchecked(CyclicBarrier barrier) {
        try {
            barrier.await();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

