/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.truth.Truth;
import com.google.common.util.concurrent.WrappingScheduledExecutorService;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;

public class WrappingScheduledExecutorServiceTest
extends TestCase {
    private static final Runnable DO_NOTHING = new Runnable(){

        @Override
        public void run() {
        }
    };

    public void testSchedule() {
        MockExecutor mock = new MockExecutor();
        TestExecutor testExecutor = new TestExecutor(mock);
        ScheduledFuture possiblyIgnoredError = testExecutor.schedule(DO_NOTHING, 10L, TimeUnit.MINUTES);
        mock.assertLastMethodCalled("scheduleRunnable", 10L, TimeUnit.MINUTES);
        ScheduledFuture possiblyIgnoredError1 = testExecutor.schedule(Executors.callable(DO_NOTHING), 5L, TimeUnit.SECONDS);
        mock.assertLastMethodCalled("scheduleCallable", 5L, TimeUnit.SECONDS);
    }

    public void testSchedule_repeating() {
        MockExecutor mock = new MockExecutor();
        TestExecutor testExecutor = new TestExecutor(mock);
        ScheduledFuture possiblyIgnoredError = testExecutor.scheduleWithFixedDelay(DO_NOTHING, 100L, 10L, TimeUnit.MINUTES);
        mock.assertLastMethodCalled("scheduleWithFixedDelay", 100L, 10L, TimeUnit.MINUTES);
        ScheduledFuture possiblyIgnoredError1 = testExecutor.scheduleAtFixedRate(DO_NOTHING, 3L, 7L, TimeUnit.SECONDS);
        mock.assertLastMethodCalled("scheduleAtFixedRate", 3L, 7L, TimeUnit.SECONDS);
    }

    private static final class MockExecutor
    implements ScheduledExecutorService {
        String lastMethodCalled = "";
        long lastInitialDelay;
        long lastDelay;
        TimeUnit lastUnit;

        private MockExecutor() {
        }

        void assertLastMethodCalled(String method, long delay, TimeUnit unit) {
            TestCase.assertEquals((String)method, (String)this.lastMethodCalled);
            TestCase.assertEquals((long)delay, (long)this.lastDelay);
            TestCase.assertEquals((Object)((Object)unit), (Object)((Object)this.lastUnit));
        }

        void assertLastMethodCalled(String method, long initialDelay, long delay, TimeUnit unit) {
            TestCase.assertEquals((String)method, (String)this.lastMethodCalled);
            TestCase.assertEquals((long)initialDelay, (long)this.lastInitialDelay);
            TestCase.assertEquals((long)delay, (long)this.lastDelay);
            TestCase.assertEquals((Object)((Object)unit), (Object)((Object)this.lastUnit));
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            Truth.assertThat((Object)command).isInstanceOf(WrappedRunnable.class);
            this.lastMethodCalled = "scheduleRunnable";
            this.lastDelay = delay;
            this.lastUnit = unit;
            return null;
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            Truth.assertThat(callable).isInstanceOf(WrappedCallable.class);
            this.lastMethodCalled = "scheduleCallable";
            this.lastDelay = delay;
            this.lastUnit = unit;
            return null;
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            Truth.assertThat((Object)command).isInstanceOf(WrappedRunnable.class);
            this.lastMethodCalled = "scheduleAtFixedRate";
            this.lastInitialDelay = initialDelay;
            this.lastDelay = period;
            this.lastUnit = unit;
            return null;
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            Truth.assertThat((Object)command).isInstanceOf(WrappedRunnable.class);
            this.lastMethodCalled = "scheduleWithFixedDelay";
            this.lastInitialDelay = initialDelay;
            this.lastDelay = delay;
            this.lastUnit = unit;
            return null;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws ExecutionException, InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isShutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isTerminated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void shutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Future<?> submit(Runnable task) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void execute(Runnable command) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class TestExecutor
    extends WrappingScheduledExecutorService {
        public TestExecutor(MockExecutor mock) {
            super((ScheduledExecutorService)mock);
        }

        protected <T> Callable<T> wrapTask(Callable<T> callable) {
            return new WrappedCallable<T>(callable);
        }

        protected Runnable wrapTask(Runnable command) {
            return new WrappedRunnable(command);
        }
    }

    private static final class WrappedRunnable
    implements Runnable {
        private final Runnable delegate;

        public WrappedRunnable(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            this.delegate.run();
        }
    }

    private static final class WrappedCallable<T>
    implements Callable<T> {
        private final Callable<T> delegate;

        public WrappedCallable(Callable<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public T call() throws Exception {
            return this.delegate.call();
        }
    }
}

