/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.benchmarks.viewer.server;

import com.google.gwt.benchmarks.viewer.client.Benchmark;
import com.google.gwt.benchmarks.viewer.client.BrowserInfo;
import com.google.gwt.benchmarks.viewer.client.Category;
import com.google.gwt.benchmarks.viewer.client.Report;
import com.google.gwt.benchmarks.viewer.client.Result;
import com.google.gwt.benchmarks.viewer.client.Trial;
import com.google.gwt.benchmarks.viewer.server.ReportDatabase;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.encoders.EncoderUtil;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportImageServer
extends HttpServlet {
    private static final String charset = "UTF-8";

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.handleRequest(request, response);
        }
        catch (Exception e) {
            if (!e.getClass().getName().endsWith(".ClientAbortException") && !e.getClass().getName().endsWith(".EofException")) {
                this.logException("An error occured while trying to create the chart.", e, response);
            }
            return;
        }
    }

    private JFreeChart createChart(String testName, Result result, String title, List<Result> comparativeResults) {
        XYPlot plot;
        JFreeChart chart;
        DefaultCategoryDataset data;
        double maxTime = 0.0;
        for (Result r : comparativeResults) {
            for (Trial t : r.getTrials()) {
                maxTime = Math.max(maxTime, t.getRunTimeMillis());
            }
        }
        List trials = result.getTrials();
        Trial firstTrial = new Trial();
        int numVariables = 0;
        if (trials.size() > 0) {
            firstTrial = (Trial)trials.get(0);
            numVariables = firstTrial.getVariables().size();
        }
        String domainVariable = null;
        String seriesVariable = null;
        HashMap variableValues = null;
        if (numVariables == 1) {
            domainVariable = (String)firstTrial.getVariables().keySet().iterator().next();
        } else {
            variableValues = new HashMap();
            for (int i = 0; i < trials.size(); ++i) {
                Trial trial = (Trial)trials.get(i);
                Map variables = trial.getVariables();
                for (Map.Entry entry : variables.entrySet()) {
                    String variable = (String)entry.getKey();
                    TreeSet set = (TreeSet)variableValues.get(variable);
                    if (set == null) {
                        set = new TreeSet();
                        variableValues.put(variable, set);
                    }
                    set.add(entry.getValue());
                }
            }
            TreeMap numValuesMap = new TreeMap();
            for (Map.Entry entry : variableValues.entrySet()) {
                Integer numValues = new Integer(((Set)entry.getValue()).size());
                ArrayList variables = (ArrayList)numValuesMap.get(numValues);
                if (variables == null) {
                    variables = new ArrayList();
                    numValuesMap.put(numValues, variables);
                }
                variables.add(entry.getKey());
            }
            if (numValuesMap.values().size() > 0) {
                domainVariable = (String)((List)numValuesMap.get(numValuesMap.lastKey())).get(0);
                seriesVariable = (String)((List)numValuesMap.get(numValuesMap.firstKey())).get(0);
            }
        }
        String valueTitle = "time (ms)";
        if (numVariables == 0) {
            data = new DefaultCategoryDataset();
            data.addValue(firstTrial.getRunTimeMillis(), (Comparable)((Object)"result"), (Comparable)((Object)"result"));
            JFreeChart chart2 = ChartFactory.createBarChart((String)title, (String)testName, (String)valueTitle, (CategoryDataset)data, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            CategoryPlot p = chart2.getCategoryPlot();
            ValueAxis axis = p.getRangeAxis();
            axis.setUpperBound(maxTime + maxTime * 0.1);
            return chart2;
        }
        if (numVariables == 1) {
            data = new XYSeriesCollection();
            XYSeries series = new XYSeries((Comparable)((Object)domainVariable));
            for (Trial trial : trials) {
                double time = trial.getRunTimeMillis();
                String domainValue = (String)trial.getVariables().get(domainVariable);
                series.add(Double.parseDouble(domainValue), time);
            }
            data.addSeries(series);
            chart = ChartFactory.createXYLineChart((String)title, (String)domainVariable, (String)valueTitle, (XYDataset)data, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            plot = chart.getXYPlot();
            plot.getRangeAxis().setUpperBound(maxTime + maxTime * 0.1);
            double maxDomainValue = this.getMaxValue(comparativeResults, domainVariable);
            plot.getDomainAxis().setUpperBound(maxDomainValue + maxDomainValue * 0.1);
            return chart;
        }
        if (numVariables == 2) {
            data = new XYSeriesCollection();
            Set seriesValues = (Set)variableValues.get(seriesVariable);
            for (String seriesValue : seriesValues) {
                XYSeries series = new XYSeries((Comparable)((Object)seriesValue));
                for (Trial trial : trials) {
                    Map variables = trial.getVariables();
                    if (!((String)variables.get(seriesVariable)).equals(seriesValue)) continue;
                    double time = trial.getRunTimeMillis();
                    String domainValue = (String)trial.getVariables().get(domainVariable);
                    series.add(Double.parseDouble(domainValue), time);
                }
                data.addSeries(series);
            }
            chart = ChartFactory.createXYLineChart((String)title, (String)domainVariable, (String)valueTitle, (XYDataset)data, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            plot = chart.getXYPlot();
            plot.getRangeAxis().setUpperBound(maxTime + maxTime * 0.1);
            double maxDomainValue = this.getMaxValue(comparativeResults, domainVariable);
            plot.getDomainAxis().setUpperBound(maxDomainValue + maxDomainValue * 0.1);
            return chart;
        }
        throw new RuntimeException("The ReportImageServer is not yet able to create charts for benchmarks with more than two variables.");
    }

    private Benchmark getBenchmarkByName(List<Benchmark> benchmarks, String name) {
        for (Benchmark benchmark : benchmarks) {
            if (!benchmark.getName().equals(name)) continue;
            return benchmark;
        }
        return null;
    }

    private Category getCategoryByName(List<Category> categories, String categoryName) {
        for (Category category : categories) {
            if (!category.getName().equals(categoryName)) continue;
            return category;
        }
        return null;
    }

    private DrawingSupplier getDrawingSupplier() {
        Paint[] colors = new Color[]{new Color(176, 29, 29, 175), new Color(10, 130, 86, 175), new Color(8, 26, 203, 175), new Color(145, 162, 66, 175), new Color(196, 140, 6, 175)};
        float size = 8.0f;
        float offset = size / 2.0f;
        int iOffset = (int)offset;
        Rectangle2D.Double square = new Rectangle2D.Double(-offset, -offset, size, size);
        Ellipse2D.Double circle = new Ellipse2D.Double(-offset, -offset, size, size);
        Polygon triangle = new Polygon(new int[]{0, iOffset, -iOffset}, new int[]{-iOffset, iOffset, iOffset}, 3);
        Polygon diamond = new Polygon(new int[]{0, iOffset, 0, -iOffset}, new int[]{-iOffset, 0, iOffset, 0}, 4);
        Ellipse2D.Double ellipse = new Ellipse2D.Double(-offset, -offset / 2.0f, size, size / 2.0f);
        return new DefaultDrawingSupplier(colors, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, new Shape[]{circle, square, triangle, diamond, ellipse});
    }

    private double getMaxValue(List<Result> results, String variable) {
        double value = 0.0;
        for (int i = 0; i < results.size(); ++i) {
            Result r = results.get(i);
            List resultTrials = r.getTrials();
            for (int j = 0; j < resultTrials.size(); ++j) {
                Trial t = (Trial)resultTrials.get(j);
                Map variables = t.getVariables();
                value = Math.max(value, Double.parseDouble((String)variables.get(variable)));
            }
        }
        return value;
    }

    private Result getResultsByAgent(List<Result> results, String agent) {
        for (Result element : results) {
            Result result = element;
            if (!result.getAgent().equals(agent)) continue;
            return result;
        }
        return null;
    }

    private void handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String uri = request.getRequestURI();
        String requestString = uri.split("test_images/")[1];
        String[] requestParams = requestString.split("/");
        String reportName = URLDecoder.decode(requestParams[0], charset);
        String categoryName = URLDecoder.decode(requestParams[1], charset);
        String testName = URLDecoder.decode(requestParams[3], charset);
        String agent = URLDecoder.decode(requestParams[4], charset);
        ReportDatabase db = ReportDatabase.getInstance();
        Report report = db.getReport(reportName);
        List categories = report.getCategories();
        Category category = this.getCategoryByName(categories, categoryName);
        List benchmarks = category.getBenchmarks();
        Benchmark benchmark = this.getBenchmarkByName(benchmarks, testName);
        List results = benchmark.getResults();
        Result result = this.getResultsByAgent(results, agent);
        String title = BrowserInfo.getBrowser((String)agent);
        JFreeChart chart = this.createChart(testName, result, title, results);
        chart.getTitle().setFont(Font.decode("Verdana BOLD 12"));
        chart.setAntiAlias(true);
        chart.setBorderVisible(true);
        chart.setBackgroundPaint((Paint)new Color(241, 241, 241));
        Plot plot = chart.getPlot();
        plot.setDrawingSupplier(this.getDrawingSupplier());
        plot.setBackgroundPaint((Paint)new GradientPaint(0.0f, 0.0f, Color.white, 640.0f, 480.0f, new Color(200, 200, 200)));
        if (plot instanceof XYPlot) {
            XYPlot xyplot = (XYPlot)plot;
            Font labelFont = Font.decode("Verdana PLAIN");
            xyplot.getDomainAxis().setLabelFont(labelFont);
            xyplot.getRangeAxis().setLabelFont(labelFont);
            XYItemRenderer xyitemrenderer = xyplot.getRenderer();
            xyitemrenderer.setStroke((Stroke)new BasicStroke(4.0f));
            if (xyitemrenderer instanceof XYLineAndShapeRenderer) {
                XYLineAndShapeRenderer xylineandshaperenderer = (XYLineAndShapeRenderer)xyitemrenderer;
                xylineandshaperenderer.setShapesVisible(true);
                xylineandshaperenderer.setShapesFilled(true);
            }
        }
        int graphWidth = Math.max(240, Math.min(480, (1024 - 10 * results.size()) / results.size()));
        BufferedImage img = chart.createBufferedImage(graphWidth, 240);
        byte[] image = EncoderUtil.encode((BufferedImage)img, (String)"png");
        response.setHeader("Cache-Control", "max-age=0");
        response.setHeader("Expires", "Fri, 2 Jan 1970 00:00:00 GMT");
        response.setContentType("image/png");
        response.setContentLength(image.length);
        ServletOutputStream output = response.getOutputStream();
        output.write(image);
    }

    private void logException(String msg, Exception e, HttpServletResponse response) {
        ServletContext servletContext = this.getServletContext();
        servletContext.log(msg, (Throwable)e);
        response.setStatus(500);
    }
}

