/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.benchmarks.viewer.client;

import com.google.gwt.benchmarks.viewer.client.Benchmark;
import com.google.gwt.benchmarks.viewer.client.BrowserInfo;
import com.google.gwt.benchmarks.viewer.client.Category;
import com.google.gwt.benchmarks.viewer.client.Report;
import com.google.gwt.benchmarks.viewer.client.ReportServer;
import com.google.gwt.benchmarks.viewer.client.ReportServerAsync;
import com.google.gwt.benchmarks.viewer.client.ReportSummary;
import com.google.gwt.benchmarks.viewer.client.ReportViewer;
import com.google.gwt.benchmarks.viewer.client.Result;
import com.google.gwt.benchmarks.viewer.client.Trial;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.HistoryListener;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TableListener;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ReportViewer
implements EntryPoint,
HistoryListener {
    private static final String imageServer = GWT.getModuleBaseURL() + "test_images/";
    HTML detailsLabel;
    Report report;
    VerticalPanel reportPanel;
    ReportServerAsync reportServer;
    FlexTable reportTable;
    HTML statusLabel;
    List<ReportSummary> summaries;
    VerticalPanel summariesPanel;
    FlexTable summariesTable;
    CellPanel topPanel;
    private int currentSelectedRow;
    private String currentToken;

    public void onHistoryChanged(String token) {
        assert (this.summaries != null);
        int row = 1;
        for (ReportSummary summary : this.summaries) {
            if (summary.getId().equals(token)) {
                this.selectReport(row, token);
                return;
            }
            ++row;
        }
        this.selectReport(0, token);
    }

    public void onModuleLoad() {
        this.init();
        this.reportServer = (ReportServerAsync)GWT.create(ReportServer.class);
        this.reportServer.getReportSummaries((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void selectReport(int row, String token) {
        if (row == this.currentSelectedRow && token.equals(this.currentToken)) {
            return;
        }
        if (this.currentSelectedRow != -1) {
            this.summariesTable.getRowFormatter().removeStyleName(this.currentSelectedRow, "viewer-SelectedRow");
        }
        this.currentToken = token;
        this.currentSelectedRow = row;
        if (row < 1) {
            this.clearReport();
        } else {
            this.fetchReport(row, token);
        }
    }

    private void clearReport() {
        this.statusLabel.setText("Select a report.");
        this.detailsLabel.setHTML("<h3>Report Details</h3>");
        this.reportPanel.remove((Widget)this.reportTable);
    }

    private FlexTable createReportTable() {
        FlexTable topTable = new FlexTable();
        FlexTable tempReportTable = new FlexTable();
        tempReportTable.setBorderWidth(1);
        tempReportTable.setCellPadding(5);
        tempReportTable.setWidget(0, 0, (Widget)new Label("Date Created"));
        tempReportTable.setWidget(0, 1, (Widget)new Label("GWT Version"));
        if (this.report == null) {
            tempReportTable.setWidget(1, 0, (Widget)new Label("No currently selected report."));
            tempReportTable.getFlexCellFormatter().setColSpan(1, 0, 3);
            return tempReportTable;
        }
        this.detailsLabel.setHTML("<h3>" + this.report.getId() + " details </h3>");
        tempReportTable.setWidget(1, 0, (Widget)new Label(this.report.getDateString()));
        tempReportTable.setWidget(1, 1, (Widget)new Label(this.report.getGwtVersion()));
        int currentRow = 1;
        Collections.sort(this.report.getCategories(), new /* Unavailable Anonymous Inner Class!! */);
        for (int i = 0; i < this.report.getCategories().size(); ++i) {
            Category c = (Category)this.report.getCategories().get(i);
            if (!c.getName().equals("")) {
                FlexTable categoryTable = new FlexTable();
                categoryTable.setBorderWidth(0);
                categoryTable.setCellPadding(5);
                categoryTable.setText(0, 0, c.getName());
                categoryTable.getFlexCellFormatter().setStyleName(0, 0, "benchmark-category");
                categoryTable.setWidget(0, 1, (Widget)new Label("Description"));
                categoryTable.setWidget(1, 0, (Widget)new Label(c.getName()));
                categoryTable.setWidget(1, 1, (Widget)new Label(c.getDescription()));
                topTable.setWidget(currentRow++, 0, (Widget)categoryTable);
            }
            Collections.sort(c.getBenchmarks(), new /* Unavailable Anonymous Inner Class!! */);
            for (int j = 0; j < c.getBenchmarks().size(); ++j) {
                Result sampleResult;
                String codeHtml;
                Benchmark benchmark = (Benchmark)c.getBenchmarks().get(j);
                FlexTable benchmarkTable = new FlexTable();
                benchmarkTable.setBorderWidth(0);
                benchmarkTable.setCellPadding(5);
                benchmarkTable.setText(0, 0, benchmark.getName());
                String sourceText = benchmark.getSourceCode();
                if (sourceText != null) {
                    Element tempElem = DOM.createDiv();
                    DOM.setInnerText((Element)tempElem, (String)sourceText);
                    String escapedCodeHtml = DOM.getInnerHTML((Element)tempElem);
                    codeHtml = "<pre>" + escapedCodeHtml + "</pre>";
                } else {
                    codeHtml = "<i>(source not available)</i>";
                }
                benchmarkTable.setWidget(1, 0, (Widget)new HTML(codeHtml));
                benchmarkTable.getFlexCellFormatter().setStyleName(0, 0, "benchmark-name");
                benchmarkTable.getFlexCellFormatter().setStyleName(1, 0, "benchmark-code");
                topTable.setWidget(currentRow++, 0, (Widget)benchmarkTable);
                FlexTable resultsTable = new FlexTable();
                resultsTable.setBorderWidth(0);
                resultsTable.setCellPadding(5);
                FlexTable.FlexCellFormatter resultsFormatter = resultsTable.getFlexCellFormatter();
                topTable.setWidget(currentRow++, 0, (Widget)resultsTable);
                Collections.sort(benchmark.getResults(), new /* Unavailable Anonymous Inner Class!! */);
                ArrayList<FlexTable> trialsTables = new ArrayList<FlexTable>();
                int numVariables = 0;
                ArrayList variableNames = null;
                if (benchmark.getResults().size() > 0 && (sampleResult = (Result)benchmark.getResults().get(0)).getTrials().size() > 0) {
                    Trial sampleTrial = (Trial)sampleResult.getTrials().get(0);
                    numVariables = sampleTrial.getVariables().size();
                    Map variables = sampleTrial.getVariables();
                    variableNames = new ArrayList(variables.keySet());
                    Collections.sort(variableNames);
                }
                MutableBool isVisible = new MutableBool(numVariables > 2);
                String buttonName = isVisible.value ? "Hide Data" : "Show Data";
                Button visibilityButton = new Button(buttonName, (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
                for (int k = 0; k < benchmark.getResults().size(); ++k) {
                    Result result = (Result)benchmark.getResults().get(k);
                    if (numVariables <= 2) {
                        resultsTable.setWidget(0, k, (Widget)new Image(this.getImageUrl(this.report.getId(), c.getName(), benchmark.getClassName(), benchmark.getName(), result.getAgent())));
                    } else if (k == 0) {
                        resultsTable.setHTML(0, k, "<b>" + BrowserInfo.getBrowser((String)result.getAgent()) + "</b><br><font size=\"-1\">(Graphs are not yet available " + "for benchmarks with more than two parameters)</font>");
                    }
                    resultsFormatter.setAlignment(2, k, HasHorizontalAlignment.ALIGN_LEFT, HasVerticalAlignment.ALIGN_TOP);
                    FlexTable trialsTable = new FlexTable();
                    trialsTable.setVisible(isVisible.value);
                    trialsTables.add(trialsTable);
                    trialsTable.setBorderWidth(1);
                    trialsTable.setCellPadding(5);
                    if (k == 0) {
                        resultsTable.setWidget(1, k, (Widget)visibilityButton);
                        resultsFormatter.setColSpan(1, k, benchmark.getResults().size());
                        resultsFormatter.setAlignment(1, k, HasHorizontalAlignment.ALIGN_LEFT, HasVerticalAlignment.ALIGN_MIDDLE);
                    }
                    resultsTable.setWidget(2, k, (Widget)trialsTable);
                    for (int varIndex = 0; varIndex < numVariables; ++varIndex) {
                        String varName = (String)variableNames.get(varIndex);
                        trialsTable.setHTML(0, varIndex, varName);
                    }
                    trialsTable.setHTML(0, numVariables, "Timing (ms)");
                    int l = 0;
                    for (Trial trial : result.getTrials()) {
                        for (int varIndex = 0; varIndex < numVariables; ++varIndex) {
                            String varName = (String)variableNames.get(varIndex);
                            String varValue = (String)trial.getVariables().get(varName);
                            trialsTable.setHTML(l + 1, varIndex, varValue);
                        }
                        String data = trial.getRunTimeMillis() + "";
                        trialsTable.setHTML(l + 1, numVariables, data);
                        ++l;
                    }
                    if (result.getException() == null) continue;
                    trialsTable.setHTML(l + 1, numVariables, result.getException());
                }
            }
        }
        return topTable;
    }

    private FlexTable createSummariesTable() {
        FlexTable tempSummariesTable = new FlexTable();
        tempSummariesTable.addStyleName("viewer-List");
        tempSummariesTable.setCellPadding(5);
        tempSummariesTable.setBorderWidth(1);
        tempSummariesTable.setCellSpacing(0);
        tempSummariesTable.setWidget(0, 0, (Widget)new Label("Report"));
        tempSummariesTable.setWidget(0, 1, (Widget)new Label("Date Created"));
        tempSummariesTable.setWidget(0, 2, (Widget)new Label("Tests"));
        tempSummariesTable.getRowFormatter().addStyleName(0, "viewer-ListHeader");
        if (this.summaries == null) {
            tempSummariesTable.setWidget(1, 0, (Widget)new Label("Fetching reports..."));
            tempSummariesTable.getFlexCellFormatter().setColSpan(1, 0, 4);
            return tempSummariesTable;
        }
        for (int i = 0; i < this.summaries.size(); ++i) {
            ReportSummary summary = (ReportSummary)this.summaries.get(i);
            int index = i + 1;
            tempSummariesTable.setWidget(index, 0, (Widget)new Hyperlink(summary.getId(), summary.getId()));
            tempSummariesTable.setWidget(index, 1, (Widget)new Label(summary.getDateString()));
            tempSummariesTable.setWidget(index, 2, (Widget)new Label(String.valueOf(summary.getNumTests())));
        }
        tempSummariesTable.addTableListener((TableListener)new SummariesTableListener(this, null));
        return tempSummariesTable;
    }

    private void displayReport() {
        FlexTable table = this.createReportTable();
        this.reportPanel.remove((Widget)this.reportTable);
        this.reportTable = table;
        this.reportPanel.insert((Widget)this.reportTable, 1);
    }

    private void displaySummaries() {
        FlexTable table = this.createSummariesTable();
        this.summariesPanel.remove((Widget)this.summariesTable);
        this.summariesTable = table;
        this.summariesPanel.insert((Widget)this.summariesTable, 1);
    }

    private String encode(String str) {
        if (str.equals("")) {
            return str;
        }
        return URL.encodeComponent((String)str);
    }

    private void fetchReport(int row, String token) {
        this.summariesTable.getRowFormatter().addStyleName(row, "viewer-SelectedRow");
        this.statusLabel.setText("Retrieving the report...");
        this.reportServer.getReport(token, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String getImageUrl(String report, String category, String testClass, String testMethod, String agent) {
        return imageServer + this.encode(report) + "/" + this.encode(category) + "/" + this.encode(testClass) + "/" + this.encode(testMethod) + "/" + this.encode(agent);
    }

    private void init() {
        this.topPanel = new VerticalPanel();
        this.summariesPanel = new VerticalPanel();
        this.summariesPanel.add((Widget)new HTML("<h3>Benchmark Reports</h3>"));
        this.summariesTable = this.createSummariesTable();
        this.summariesPanel.add((Widget)this.summariesTable);
        this.reportPanel = new VerticalPanel();
        this.detailsLabel = new HTML();
        this.reportPanel.add((Widget)this.detailsLabel);
        this.reportTable = this.createReportTable();
        this.topPanel.add((Widget)this.summariesPanel);
        HorizontalPanel spacerPanel = new HorizontalPanel();
        spacerPanel.setSpacing(10);
        spacerPanel.add((Widget)new Label());
        this.topPanel.add((Widget)spacerPanel);
        this.topPanel.add((Widget)this.reportPanel);
        RootPanel root = RootPanel.get();
        root.add((Widget)this.topPanel);
        this.statusLabel = new HTML();
        root.add((Widget)this.statusLabel);
        this.selectReport(0, "");
    }

    static /* synthetic */ void access$000(ReportViewer x0) {
        x0.displaySummaries();
    }

    static /* synthetic */ void access$200(ReportViewer x0) {
        x0.displayReport();
    }
}

