/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSNode_H
#define JSNode_H

#include "kjs_binding.h"

namespace WebCore {

class Node;

class JSNode : public KJS::DOMObject {
public:
    JSNode(KJS::ExecState*, Node*);
    virtual ~JSNode();
    virtual bool getOwnPropertySlot(KJS::ExecState*, const KJS::Identifier&, KJS::PropertySlot&);
    KJS::JSValue* getValueProperty(KJS::ExecState*, int token) const;
    virtual void put(KJS::ExecState*, const KJS::Identifier&, KJS::JSValue*, int attr = KJS::None);
    void putValueProperty(KJS::ExecState*, int, KJS::JSValue*, int attr);
    virtual const KJS::ClassInfo* classInfo() const { return &info; }
    static const KJS::ClassInfo info;

    virtual void mark();

    static KJS::JSValue* getConstructor(KJS::ExecState*);
    enum {
        // Attributes
        NodeNameAttrNum, NodeValueAttrNum, NodeTypeAttrNum, ParentNodeAttrNum, 
        ChildNodesAttrNum, FirstChildAttrNum, LastChildAttrNum, PreviousSiblingAttrNum, 
        NextSiblingAttrNum, AttributesAttrNum, OwnerDocumentAttrNum, NamespaceURIAttrNum, 
        PrefixAttrNum, LocalNameAttrNum, BaseURIAttrNum, TextContentAttrNum, 
        ParentElementAttrNum, 

        // The Constructor Attribute
        ConstructorAttrNum, 

        // Functions
        InsertBeforeFuncNum, ReplaceChildFuncNum, RemoveChildFuncNum, AppendChildFuncNum, 
        HasChildNodesFuncNum, CloneNodeFuncNum, NormalizeFuncNum, IsSupportedFuncNum, 
        HasAttributesFuncNum, IsSameNodeFuncNum, IsEqualNodeFuncNum, LookupPrefixFuncNum, 
        IsDefaultNamespaceFuncNum, LookupNamespaceURIFuncNum
    };

    // Custom functions
    KJS::JSValue* insertBefore(KJS::ExecState*, const KJS::List&);
    KJS::JSValue* replaceChild(KJS::ExecState*, const KJS::List&);
    KJS::JSValue* removeChild(KJS::ExecState*, const KJS::List&);
    KJS::JSValue* appendChild(KJS::ExecState*, const KJS::List&);
    Node* impl() const { return m_impl.get(); }

private:
    RefPtr<Node> m_impl;
};

KJS::JSValue* toJS(KJS::ExecState*, PassRefPtr<Node>);
Node* toNode(KJS::JSValue*);

class JSNodePrototype : public KJS::JSObject {
public:
    static KJS::JSObject* self(KJS::ExecState* exec);
    virtual const KJS::ClassInfo* classInfo() const { return &info; }
    static const KJS::ClassInfo info;
    bool getOwnPropertySlot(KJS::ExecState*, const KJS::Identifier&, KJS::PropertySlot&);
    KJS::JSValue* getValueProperty(KJS::ExecState*, int token) const;
    JSNodePrototype(KJS::ExecState* exec)
        : KJS::JSObject(exec->lexicalInterpreter()->builtinObjectPrototype()) { }
};

class JSNodePrototypeFunction : public KJS::InternalFunctionImp {
public:
    JSNodePrototypeFunction(KJS::ExecState* exec, int i, int len, const KJS::Identifier& name)
        : KJS::InternalFunctionImp(static_cast<KJS::FunctionPrototype*>(exec->lexicalInterpreter()->builtinFunctionPrototype()), name)
        , id(i)
    {
        put(exec, exec->propertyNames().length, KJS::jsNumber(len), KJS::DontDelete|KJS::ReadOnly|KJS::DontEnum);
    }
    virtual KJS::JSValue* callAsFunction(KJS::ExecState*, KJS::JSObject*, const KJS::List&);

private:
    int id;
};

} // namespace WebCore

#endif
