/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.rpc.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.impl.AbstractSerializationStreamWriter;
import com.google.gwt.user.client.rpc.impl.Serializer;
import java.util.List;

public final class ClientSerializationStreamWriter
extends AbstractSerializationStreamWriter {
    private StringBuffer encodeBuffer;
    private final String moduleBaseURL;
    private final String serializationPolicyStrongName;
    private final Serializer serializer;

    private static void append(StringBuffer sb, String token) {
        assert (token != null);
        sb.append(token);
        sb.append('\uffff');
    }

    private static native double[] makeLongComponents0(long var0);

    public ClientSerializationStreamWriter(Serializer serializer, String moduleBaseURL, String serializationPolicyStrongName) {
        this.serializer = serializer;
        this.moduleBaseURL = moduleBaseURL;
        this.serializationPolicyStrongName = serializationPolicyStrongName;
    }

    public void prepareToWrite() {
        super.prepareToWrite();
        this.encodeBuffer = new StringBuffer();
        this.writeString(this.moduleBaseURL);
        this.writeString(this.serializationPolicyStrongName);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.writeHeader(buffer);
        this.writeStringTable(buffer);
        this.writePayload(buffer);
        return buffer.toString();
    }

    public void writeLong(long fieldValue) {
        double[] parts = GWT.isScript() ? ClientSerializationStreamWriter.makeLongComponents0(fieldValue) : ClientSerializationStreamWriter.makeLongComponents((int)(fieldValue >> 32), (int)fieldValue);
        assert (parts.length == 2);
        this.writeDouble(parts[0]);
        this.writeDouble(parts[1]);
    }

    protected void append(String token) {
        ClientSerializationStreamWriter.append(this.encodeBuffer, token);
    }

    protected String getObjectTypeSignature(Object o) {
        String typeName;
        String serializationSignature;
        Class<Object> clazz = o.getClass();
        if (o instanceof Enum) {
            Enum e = (Enum)o;
            clazz = e.getDeclaringClass();
        }
        if ((serializationSignature = this.serializer.getSerializationSignature(typeName = clazz.getName())) != null) {
            typeName = typeName + "/" + serializationSignature;
        }
        return typeName;
    }

    protected void serialize(Object instance, String typeSignature) throws SerializationException {
        this.serializer.serialize(this, instance, typeSignature);
    }

    private void writeHeader(StringBuffer buffer) {
        ClientSerializationStreamWriter.append(buffer, String.valueOf(this.getVersion()));
        ClientSerializationStreamWriter.append(buffer, String.valueOf(this.getFlags()));
    }

    private void writePayload(StringBuffer buffer) {
        buffer.append(this.encodeBuffer.toString());
    }

    private StringBuffer writeStringTable(StringBuffer buffer) {
        List<String> stringTable = this.getStringTable();
        ClientSerializationStreamWriter.append(buffer, String.valueOf(stringTable.size()));
        for (String s : stringTable) {
            ClientSerializationStreamWriter.append(buffer, s);
        }
        return buffer;
    }
}

