/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.tools.apichecker;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JAbstractMethod;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.tools.apichecker.ApiAbstractMethod;
import com.google.gwt.tools.apichecker.ApiChange;
import com.google.gwt.tools.apichecker.ApiConstructor;
import com.google.gwt.tools.apichecker.ApiContainer;
import com.google.gwt.tools.apichecker.ApiElement;
import com.google.gwt.tools.apichecker.ApiField;
import com.google.gwt.tools.apichecker.ApiMethod;
import com.google.gwt.tools.apichecker.ApiPackage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ApiClass
implements Comparable<ApiClass>,
ApiElement {
    private HashMap<String, ApiField> apiFields = null;
    private EnumMap<MethodType, Map<String, Set<ApiAbstractMethod>>> apiMembersByName = null;
    private final ApiPackage apiPackage;
    private final JClassType classType;
    private final boolean isInstantiableApiClass;
    private final boolean isNotsubclassableApiClass;
    private final boolean isSubclassableApiClass;
    private final TreeLogger logger;

    ApiClass(JClassType classType, ApiPackage apiPackage) {
        this.classType = classType;
        this.apiPackage = apiPackage;
        this.logger = apiPackage.getApiContainer().getLogger();
        ApiContainer apiContainer = apiPackage.getApiContainer();
        this.isSubclassableApiClass = apiContainer.isSubclassableApiClass(classType);
        this.isNotsubclassableApiClass = apiContainer.isNotsubclassableApiClass(classType);
        this.isInstantiableApiClass = apiContainer.isInstantiableApiClass(classType);
    }

    @Override
    public int compareTo(ApiClass other) {
        return this.getName().compareTo(other.getName());
    }

    @Override
    public String getRelativeSignature() {
        return this.classType.getQualifiedSourceName();
    }

    public String toString() {
        return this.classType.toString();
    }

    String getApiAsString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\t" + this.getName() + "\n");
        if (this.apiFields != null) {
            ArrayList<ApiField> apiFieldsList = new ArrayList<ApiField>(this.apiFields.values());
            Collections.sort(apiFieldsList);
            for (ApiField apiField : apiFieldsList) {
                sb.append("\t\t" + apiField.getRelativeSignature() + "\n");
            }
        }
        if (this.apiMembersByName != null && this.apiMembersByName.get((Object)MethodType.METHOD) != null) {
            for (MethodType method : MethodType.values()) {
                HashSet<ApiAbstractMethod> apiMethodsSet = new HashSet<ApiAbstractMethod>();
                for (Set<ApiAbstractMethod> methodsSets : this.apiMembersByName.get((Object)method).values()) {
                    apiMethodsSet.addAll(methodsSets);
                }
                ArrayList apiMethodsList = new ArrayList(apiMethodsSet);
                Collections.sort(apiMethodsList);
                for (ApiAbstractMethod apiMethod : apiMethodsList) {
                    sb.append("\t\t" + apiMethod.getRelativeSignature() + "\n");
                }
            }
        }
        return sb.toString();
    }

    ApiField getApiFieldByName(String name) {
        return this.apiFields.get(name);
    }

    Set<String> getApiFieldNames() {
        if (this.apiFields == null) {
            this.initializeApiFields();
        }
        return new HashSet<String>(this.apiFields.keySet());
    }

    Set<ApiField> getApiFieldsBySet(Set<String> names) {
        HashSet<ApiField> ret = new HashSet<ApiField>();
        for (String name : names) {
            ret.add(this.apiFields.get(name));
        }
        return ret;
    }

    Set<String> getApiMemberNames(MethodType type) {
        if (this.apiMembersByName == null) {
            this.initializeApiConstructorsAndMethods();
        }
        return new HashSet<String>(this.apiMembersByName.get((Object)type).keySet());
    }

    Set<ApiAbstractMethod> getApiMembersBySet(Set<String> methodNames, MethodType type) {
        Map<String, Set<ApiAbstractMethod>> current = this.apiMembersByName.get((Object)type);
        HashSet<ApiAbstractMethod> tempMethods = new HashSet<ApiAbstractMethod>();
        for (String methodName : methodNames) {
            tempMethods.addAll((Collection<ApiAbstractMethod>)current.get(methodName));
        }
        return tempMethods;
    }

    Set<ApiAbstractMethod> getApiMethodsByName(String name, MethodType type) {
        return this.apiMembersByName.get((Object)type).get(name);
    }

    JClassType getClassObject() {
        return this.classType;
    }

    String getFullName() {
        return this.classType.getQualifiedSourceName();
    }

    List<ApiChange.Status> getModifierChanges(ApiClass newClass) {
        JClassType newClassType = newClass.getClassObject();
        ArrayList<ApiChange.Status> statuses = new ArrayList<ApiChange.Status>(5);
        if (!this.classType.isFinal() && newClassType.isFinal()) {
            statuses.add(ApiChange.Status.FINAL_ADDED);
        }
        if (!this.classType.isAbstract() && newClassType.isAbstract()) {
            statuses.add(ApiChange.Status.ABSTRACT_ADDED);
        }
        if (!this.classType.isStatic() && newClassType.isStatic()) {
            statuses.add(ApiChange.Status.STATIC_ADDED);
        }
        if (this.classType.isStatic() && !newClassType.isStatic()) {
            statuses.add(ApiChange.Status.STATIC_REMOVED);
        }
        if (!this.classType.isAbstract() && newClassType.isInterface() != null) {
            statuses.add(ApiChange.Status.NONABSTRACT_CLASS_MADE_INTERFACE);
        }
        if (this.apiPackage.getApiContainer().isSubclassableApiClass(this.classType)) {
            if (this.classType.isClass() != null && newClassType.isInterface() != null) {
                statuses.add(ApiChange.Status.SUBCLASSABLE_API_CLASS_MADE_INTERFACE);
            }
            if (this.classType.isInterface() != null && newClassType.isClass() != null) {
                statuses.add(ApiChange.Status.SUBCLASSABLE_API_INTERFACE_MADE_CLASS);
            }
        }
        return statuses;
    }

    String getName() {
        return this.classType.getName();
    }

    ApiPackage getPackage() {
        return this.apiPackage;
    }

    void initializeApiFields() {
        JField[] fields;
        this.apiFields = new HashMap();
        ArrayList<String> notAddedFields = new ArrayList<String>();
        for (JField field : fields = this.getAccessibleFields()) {
            if (this.isApiMember(field)) {
                this.apiFields.put(field.getName(), new ApiField(field, this));
                continue;
            }
            notAddedFields.add(field.toString());
        }
        if (notAddedFields.size() > 0) {
            this.logger.log(TreeLogger.SPAM, "class " + this.getName() + " " + ", not adding " + notAddedFields.size() + " nonApi fields: " + notAddedFields, null);
        }
    }

    boolean isSubclassableApiClass() {
        return this.isSubclassableApiClass;
    }

    private JField[] getAccessibleFields() {
        HashMap<String, JField> fieldsBySignature = new HashMap<String, JField>();
        JClassType tempClassType = this.classType;
        do {
            JField[] declaredFields;
            for (JField field : declaredFields = tempClassType.getFields()) {
                String signature;
                JField existing;
                if (field.isPrivate() || (existing = fieldsBySignature.put(signature = field.toString(), field)) == null) continue;
                fieldsBySignature.put(signature, existing);
            }
        } while ((tempClassType = tempClassType.getSuperclass()) != null);
        return fieldsBySignature.values().toArray(new JField[0]);
    }

    private JMethod[] getAccessibleMethods() {
        boolean isInterface = false;
        if (this.classType.isInterface() != null) {
            isInterface = true;
        }
        HashMap<String, JMethod> methodsBySignature = new HashMap<String, JMethod>();
        LinkedList<JClassType> classesToBeProcessed = new LinkedList<JClassType>();
        classesToBeProcessed.add(this.classType);
        JClassType tempClassType = null;
        while (classesToBeProcessed.peek() != null) {
            JMethod[] declaredMethods;
            tempClassType = (JClassType)classesToBeProcessed.remove();
            for (JMethod method : declaredMethods = tempClassType.getMethods()) {
                String signature;
                JMethod existing;
                if (method.isPrivate() || (existing = methodsBySignature.put(signature = ApiAbstractMethod.computeInternalSignature((JAbstractMethod)method), method)) == null || !existing.getEnclosingType().isAssignableTo(method.getEnclosingType())) continue;
                methodsBySignature.put(signature, existing);
            }
            if (isInterface) {
                classesToBeProcessed.addAll(Arrays.asList(tempClassType.getImplementedInterfaces()));
                continue;
            }
            classesToBeProcessed.add(tempClassType.getSuperclass());
        }
        return methodsBySignature.values().toArray(new JMethod[0]);
    }

    private JAbstractMethod[] getAccessibleMethods(MethodType member) {
        switch (member) {
            case CONSTRUCTOR: {
                return this.classType.getConstructors();
            }
            case METHOD: {
                return this.getAccessibleMethods();
            }
        }
        throw new AssertionError((Object)("Unknown value : " + (Object)((Object)member)));
    }

    private void initializeApiConstructorsAndMethods() {
        this.apiMembersByName = new EnumMap(MethodType.class);
        for (MethodType method : MethodType.values()) {
            JAbstractMethod[] jams;
            this.apiMembersByName.put(method, new HashMap());
            Map<String, Set<ApiAbstractMethod>> pointer = this.apiMembersByName.get((Object)method);
            ArrayList<String> notAddedMembers = new ArrayList<String>();
            for (JAbstractMethod jam : jams = this.getAccessibleMethods(method)) {
                if (this.isApiMember(jam)) {
                    String tempName = jam.getName() + jam.getParameters().length;
                    Set<ApiAbstractMethod> existingMembers = pointer.get(tempName);
                    if (existingMembers == null) {
                        existingMembers = new HashSet<ApiAbstractMethod>();
                    }
                    switch (method) {
                        case CONSTRUCTOR: {
                            existingMembers.add(new ApiConstructor(jam, this));
                            break;
                        }
                        case METHOD: {
                            existingMembers.add(new ApiMethod(jam, this));
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Unknown memberType : " + (Object)((Object)method)));
                        }
                    }
                    pointer.put(tempName, existingMembers);
                    continue;
                }
                notAddedMembers.add(jam.toString());
            }
            if (notAddedMembers.size() <= 0) continue;
            this.logger.log(TreeLogger.SPAM, "class " + this.getName() + ", removing " + notAddedMembers.size() + " nonApi members: " + notAddedMembers, null);
        }
    }

    private boolean isApiMember(Object member) {
        boolean isPublic = false;
        boolean isPublicOrProtected = false;
        boolean isStatic = false;
        if (member instanceof JField) {
            JField field = (JField)member;
            isPublic = field.isPublic();
            isPublicOrProtected = isPublic || field.isProtected();
            isStatic = field.isStatic();
        }
        if (member instanceof JAbstractMethod) {
            JAbstractMethod method = (JAbstractMethod)member;
            isPublic = method.isPublic();
            boolean bl = isPublicOrProtected = isPublic || method.isProtected();
            if (method instanceof JMethod) {
                JMethod temp = (JMethod)method;
                isStatic = temp.isStatic();
            } else {
                isStatic = false;
            }
        }
        if (!(this.isInstantiableApiClass || isStatic || this.isSubclassableApiClass)) {
            return false;
        }
        return this.isSubclassableApiClass && isPublicOrProtected || this.isNotsubclassableApiClass && isPublic;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MethodType {
        CONSTRUCTOR,
        METHOD;

    }
}

