/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class FastStringMap
extends AbstractMap {
    private JavaScriptObject map;

    public FastStringMap() {
        this.init();
    }

    public void clear() {
        this.init();
    }

    public boolean containsKey(Object key) {
        return this.containsKey(this.keyMustBeString(key), this.map);
    }

    public boolean containsValue(Object arg0) {
        return this.values().contains(arg0);
    }

    public Set entrySet() {
        return new AbstractSet(){

            public boolean contains(Object key) {
                Map.Entry s = (Map.Entry)key;
                Object value = FastStringMap.this.get(s.getKey());
                if (value == null) {
                    return value == s.getValue();
                }
                return value.equals(s.getValue());
            }

            public Iterator iterator() {
                Iterator custom = new Iterator(){
                    Iterator keys;
                    {
                        this.keys = FastStringMap.this.keySet().iterator();
                    }

                    public boolean hasNext() {
                        return this.keys.hasNext();
                    }

                    public Object next() {
                        String key = (String)this.keys.next();
                        return new ImplMapEntry(key, FastStringMap.this.get(key));
                    }

                    public void remove() {
                        this.keys.remove();
                    }
                };
                return custom;
            }

            public int size() {
                return FastStringMap.this.size();
            }
        };
    }

    public Object get(Object key) {
        return this.get(this.keyMustBeString(key));
    }

    public native Object get(String var1);

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractSet(){

            public boolean contains(Object key) {
                return FastStringMap.this.containsKey(key);
            }

            public Iterator iterator() {
                ArrayList l = new ArrayList();
                FastStringMap.this.addAllKeysFromJavascriptObject(l, FastStringMap.this.map);
                return l.iterator();
            }

            public int size() {
                return FastStringMap.this.size();
            }
        };
    }

    public Object put(Object key, Object widget) {
        return this.put(this.keyMustBeString(key), widget);
    }

    public native Object put(String var1, Object var2);

    public void putAll(Map arg0) {
        Iterator iter = arg0.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        return this.remove(this.keyMustBeString(key));
    }

    public native int size();

    public Collection values() {
        ArrayList values = new ArrayList();
        this.addAllValuesFromJavascriptObject(values, this.map);
        return values;
    }

    private native void addAllKeysFromJavascriptObject(Collection var1, JavaScriptObject var2);

    private native void addAllValuesFromJavascriptObject(Collection var1, JavaScriptObject var2);

    private native boolean containsKey(String var1, JavaScriptObject var2);

    private native void init();

    private String keyMustBeString(Object key) {
        if (key instanceof String) {
            return (String)key;
        }
        throw new IllegalArgumentException(GWT.getTypeName(this) + " can only have Strings as keys, not" + key);
    }

    private native Object remove(String var1);

    private static class ImplMapEntry
    implements Map.Entry {
        private Object key;
        private Object value;

        ImplMapEntry(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object a) {
            Map.Entry s;
            return a instanceof Map.Entry && this.equalsWithNullCheck(this.key, (s = (Map.Entry)a).getKey()) && this.equalsWithNullCheck(this.value, s.getValue());
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            int keyHash = 0;
            int valueHash = 0;
            if (this.key != null) {
                keyHash = this.key.hashCode();
            }
            if (this.value != null) {
                valueHash = this.value.hashCode();
            }
            return keyHash ^ valueHash;
        }

        public Object setValue(Object object) {
            Object old = this.value;
            this.value = object;
            return old;
        }

        private boolean equalsWithNullCheck(Object a, Object b) {
            if (a == b) {
                return true;
            }
            if (a == null) {
                return false;
            }
            return a.equals(b);
        }
    }
}

