/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.tools.apichecker;

import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.tools.apichecker.ApiChange;
import com.google.gwt.tools.apichecker.ApiClass;
import com.google.gwt.tools.apichecker.ApiClassDiffGenerator;
import com.google.gwt.tools.apichecker.ApiDiffGenerator;
import com.google.gwt.tools.apichecker.ApiPackage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ApiPackageDiffGenerator
implements Comparable<ApiPackageDiffGenerator> {
    private final ApiDiffGenerator apiDiffGenerator;
    private Map<String, ApiClassDiffGenerator> intersectingClasses = new HashMap<String, ApiClassDiffGenerator>();
    private Set<String> missingClassNames = null;
    private final String name;
    private final ApiPackage newPackage;
    private final ApiPackage oldPackage;

    ApiPackageDiffGenerator(String packageName, ApiDiffGenerator apiDiffGenerator) throws NotFoundException {
        this.apiDiffGenerator = apiDiffGenerator;
        this.name = packageName;
        this.newPackage = apiDiffGenerator.getNewApiContainer().getApiPackage(packageName);
        this.oldPackage = apiDiffGenerator.getOldApiContainer().getApiPackage(packageName);
        if (this.newPackage == null || this.oldPackage == null) {
            throw new NotFoundException("for package " + packageName + ", one of the package objects is null");
        }
    }

    @Override
    public int compareTo(ApiPackageDiffGenerator other) {
        return this.getName().compareTo(other.getName());
    }

    void computeApiDiff() throws NotFoundException {
        Set<String> newClassNames = this.newPackage.getApiClassNames();
        this.missingClassNames = this.oldPackage.getApiClassNames();
        Set<String> intersection = ApiDiffGenerator.removeIntersection(newClassNames, this.missingClassNames);
        for (String className : intersection) {
            ApiClassDiffGenerator tempClassDiffGenerator = new ApiClassDiffGenerator(className, this);
            this.intersectingClasses.put(className, tempClassDiffGenerator);
            tempClassDiffGenerator.computeApiDiff();
        }
    }

    ApiClassDiffGenerator findApiClassDiffGenerator(String key) {
        return this.intersectingClasses.get(key);
    }

    Collection<ApiChange> getApiDiff() {
        ArrayList<ApiChange> collection = new ArrayList<ApiChange>();
        Set<ApiClass> missingClasses = this.oldPackage.getApiClassesBySet(this.missingClassNames);
        for (ApiClass missingClass : missingClasses) {
            collection.add(new ApiChange(missingClass, ApiChange.Status.MISSING));
        }
        ArrayList<ApiClassDiffGenerator> intersectingClassesList = new ArrayList<ApiClassDiffGenerator>(this.intersectingClasses.values());
        Collections.sort(intersectingClassesList);
        for (ApiClassDiffGenerator intersectingClass : this.intersectingClasses.values()) {
            collection.addAll(intersectingClass.getApiDiff());
        }
        return collection;
    }

    ApiDiffGenerator getApiDiffGenerator() {
        return this.apiDiffGenerator;
    }

    String getName() {
        return this.name;
    }

    ApiPackage getNewApiPackage() {
        return this.newPackage;
    }

    ApiPackage getOldApiPackage() {
        return this.oldPackage;
    }
}

