/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.http.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.Header;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestTimeoutException;
import com.google.gwt.http.client.Response;
import com.google.gwt.http.client.StringValidator;
import com.google.gwt.http.client.XMLHTTPRequest;
import com.google.gwt.user.client.Timer;

public class Request {
    private final int timeoutMillis;
    private final Timer timer;
    private JavaScriptObject xmlHttpRequest;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static Response createResponse(final JavaScriptObject xmlHttpRequest) {
        if (!$assertionsDisabled && !XMLHTTPRequest.isResponseReady(xmlHttpRequest)) {
            throw new AssertionError();
        }
        Response response = new Response(){

            public String getHeader(String header) {
                StringValidator.throwIfEmptyOrNull("header", header);
                return XMLHTTPRequest.getResponseHeader(xmlHttpRequest, header);
            }

            public Header[] getHeaders() {
                return XMLHTTPRequest.getHeaders(xmlHttpRequest);
            }

            public String getHeadersAsString() {
                return XMLHTTPRequest.getAllResponseHeaders(xmlHttpRequest);
            }

            public int getStatusCode() {
                return XMLHTTPRequest.getStatusCode(xmlHttpRequest);
            }

            public String getStatusText() {
                return XMLHTTPRequest.getStatusText(xmlHttpRequest);
            }

            public String getText() {
                return XMLHTTPRequest.getResponseText(xmlHttpRequest);
            }
        };
        return response;
    }

    Request(JavaScriptObject xmlHttpRequest, int timeoutMillis, final RequestCallback callback) {
        if (xmlHttpRequest == null) {
            throw new NullPointerException();
        }
        if (callback == null) {
            throw new NullPointerException();
        }
        if (timeoutMillis < 0) {
            throw new IllegalArgumentException();
        }
        this.timeoutMillis = timeoutMillis;
        this.xmlHttpRequest = xmlHttpRequest;
        if (timeoutMillis > 0) {
            this.timer = new Timer(){

                public void run() {
                    Request.this.fireOnTimeout(callback);
                }
            };
            this.timer.schedule(timeoutMillis);
        } else {
            this.timer = null;
        }
    }

    public void cancel() {
        if (this.xmlHttpRequest != null) {
            JavaScriptObject xmlHttp = this.xmlHttpRequest;
            this.xmlHttpRequest = null;
            XMLHTTPRequest.abort(xmlHttp);
            this.cancelTimer();
        }
    }

    public boolean isPending() {
        if (this.xmlHttpRequest == null) {
            return false;
        }
        int readyState = XMLHTTPRequest.getReadyState(this.xmlHttpRequest);
        switch (readyState) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private void cancelTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private void fireOnResponseReceived(RequestCallback callback) {
        GWT.UncaughtExceptionHandler handler = GWT.getUncaughtExceptionHandler();
        if (handler != null) {
            this.fireOnResponseReceivedAndCatch(handler, callback);
        } else {
            this.fireOnResponseReceivedImpl(callback);
        }
    }

    private void fireOnResponseReceivedAndCatch(GWT.UncaughtExceptionHandler handler, RequestCallback callback) {
        try {
            this.fireOnResponseReceivedImpl(callback);
        }
        catch (Throwable e) {
            handler.onUncaughtException(e);
        }
    }

    private void fireOnResponseReceivedImpl(RequestCallback callback) {
        if (this.xmlHttpRequest == null) {
            return;
        }
        this.cancelTimer();
        JavaScriptObject xmlHttp = this.xmlHttpRequest;
        this.xmlHttpRequest = null;
        if (XMLHTTPRequest.hasStatusCodeUndefinedBug(xmlHttp)) {
            RuntimeException exception = new RuntimeException("XmlHttpRequest.status == undefined, please see Safari bug http://bugs.webkit.org/show_bug.cgi?id=3810 for more details");
            callback.onError(this, exception);
        } else {
            Response response = Request.createResponse(xmlHttp);
            callback.onResponseReceived(this, response);
        }
    }

    private final void fireOnTimeout(RequestCallback callback) {
        if (this.xmlHttpRequest == null) {
            return;
        }
        this.cancel();
        callback.onError(this, new RequestTimeoutException(this, this.timeoutMillis));
    }

    static {
        $assertionsDisabled = !Request.class.desiredAssertionStatus();
    }
}

