/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.rpc.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.impl.AbstractSerializationStreamWriter;
import com.google.gwt.user.client.rpc.impl.Serializer;
import java.util.ArrayList;

public final class ClientSerializationStreamWriter
extends AbstractSerializationStreamWriter {
    JavaScriptObject objectMap;
    JavaScriptObject stringMap;
    private StringBuffer encodeBuffer;
    private int objectCount;
    private Serializer serializer;
    private ArrayList stringTable = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    private static void append(StringBuffer sb, String token) {
        if (!$assertionsDisabled && token == null) {
            throw new AssertionError();
        }
        sb.append(token);
        sb.append('\uffff');
    }

    private static native JavaScriptObject createJavaScriptObject();

    public ClientSerializationStreamWriter(Serializer serializer) {
        this.serializer = serializer;
    }

    public void prepareToWrite() {
        this.objectCount = 0;
        this.objectMap = ClientSerializationStreamWriter.createJavaScriptObject();
        this.stringMap = ClientSerializationStreamWriter.createJavaScriptObject();
        this.stringTable.clear();
        this.encodeBuffer = new StringBuffer();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.writeHeader(buffer);
        this.writeStringTable(buffer);
        this.writePayload(buffer);
        return buffer.toString();
    }

    protected int addString(String string) {
        if (string == null) {
            return 0;
        }
        int index = this.getIntForString(string);
        if (index > 0) {
            return index;
        }
        this.stringTable.add(string);
        index = this.stringTable.size();
        this.setIntForString(string, index);
        return index;
    }

    protected void append(String token) {
        ClientSerializationStreamWriter.append(this.encodeBuffer, token);
    }

    protected int getIndexForObject(Object instance) {
        return this.getIntForInt(System.identityHashCode(instance));
    }

    protected String getObjectTypeSignature(Object o) {
        String typeName = GWT.getTypeName(o);
        String serializationSignature = this.serializer.getSerializationSignature(typeName);
        if (serializationSignature != null) {
            typeName = typeName + "/" + serializationSignature;
        }
        return typeName;
    }

    protected void saveIndexForObject(Object instance) {
        this.setIntForInt(System.identityHashCode(instance), this.objectCount++);
    }

    protected void serialize(Object instance, String typeSignature) throws SerializationException {
        this.serializer.serialize(this, instance, typeSignature);
    }

    private native int getIntForInt(int var1);

    private native int getIntForString(String var1);

    private native void setIntForInt(int var1, int var2);

    private native void setIntForString(String var1, int var2);

    private void writeHeader(StringBuffer buffer) {
        ClientSerializationStreamWriter.append(buffer, String.valueOf(2));
        ClientSerializationStreamWriter.append(buffer, String.valueOf(this.getFlags()));
    }

    private void writePayload(StringBuffer buffer) {
        buffer.append(this.encodeBuffer.toString());
    }

    private StringBuffer writeStringTable(StringBuffer buffer) {
        int stringTableSize = this.stringTable.size();
        ClientSerializationStreamWriter.append(buffer, String.valueOf(stringTableSize));
        for (int i = 0; i < stringTableSize; ++i) {
            ClientSerializationStreamWriter.append(buffer, (String)this.stringTable.get(i));
        }
        return buffer;
    }

    static {
        $assertionsDisabled = !ClientSerializationStreamWriter.class.desiredAssertionStatus();
    }
}

