/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.UIObject;

public class MenuItem
extends UIObject
implements HasHTML {
    private Command command;
    private MenuBar parentMenu;
    private MenuBar subMenu;

    public MenuItem(String text, Command cmd) {
        this(text, false);
        this.setCommand(cmd);
    }

    public MenuItem(String text, boolean asHTML, Command cmd) {
        this(text, asHTML);
        this.setCommand(cmd);
    }

    public MenuItem(String text, MenuBar subMenu) {
        this(text, false);
        this.setSubMenu(subMenu);
    }

    public MenuItem(String text, boolean asHTML, MenuBar subMenu) {
        this(text, asHTML);
        this.setSubMenu(subMenu);
    }

    private MenuItem(String text, boolean asHTML) {
        this.setElement(DOM.createTD());
        this.sinkEvents(49);
        this.setSelectionStyle(false);
        if (asHTML) {
            this.setHTML(text);
        } else {
            this.setText(text);
        }
        this.setStyleName("gwt-MenuItem");
    }

    public Command getCommand() {
        return this.command;
    }

    public String getHTML() {
        return DOM.getInnerHTML(this.getElement());
    }

    public MenuBar getParentMenu() {
        return this.parentMenu;
    }

    public MenuBar getSubMenu() {
        return this.subMenu;
    }

    public String getText() {
        return DOM.getInnerText(this.getElement());
    }

    public void setCommand(Command cmd) {
        this.command = cmd;
    }

    public void setHTML(String html) {
        DOM.setInnerHTML(this.getElement(), html);
    }

    public void setSubMenu(MenuBar subMenu) {
        this.subMenu = subMenu;
    }

    public void setText(String text) {
        DOM.setInnerText(this.getElement(), text);
    }

    void setParentMenu(MenuBar parentMenu) {
        this.parentMenu = parentMenu;
    }

    void setSelectionStyle(boolean selected) {
        if (selected) {
            this.addStyleName("gwt-MenuItem-selected");
        } else {
            this.removeStyleName("gwt-MenuItem-selected");
        }
    }
}

