/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.CommandCanceledException;
import com.google.gwt.user.client.IncrementalCommand;
import com.google.gwt.user.client.IncrementalCommandCanceledException;
import com.google.gwt.user.client.Timer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class CommandExecutor {
    private static final long DEFAULT_CANCELLATION_TIMEOUT_MILLIS = 10000L;
    private static final long DEFAULT_TIME_SLICE_MILLIS = 100L;
    private final Timer cancellationTimer = new Timer(){

        public void run() {
            if (!CommandExecutor.this.isExecuting()) {
                return;
            }
            CommandExecutor.this.doCommandCanceled();
        }
    };
    private final List commands = new ArrayList();
    private boolean executing = false;
    private final Timer executionTimer = new Timer(){
        static final /* synthetic */ boolean $assertionsDisabled;

        public void run() {
            if (!$assertionsDisabled && CommandExecutor.this.isExecuting()) {
                throw new AssertionError();
            }
            CommandExecutor.this.setExecutionTimerPending(false);
            CommandExecutor.this.doExecuteCommands(System.currentTimeMillis());
        }

        static {
            $assertionsDisabled = !(class$com$google$gwt$user$client$CommandExecutor == null ? (class$com$google$gwt$user$client$CommandExecutor = CommandExecutor.class$("com.google.gwt.user.client.CommandExecutor")) : class$com$google$gwt$user$client$CommandExecutor).desiredAssertionStatus();
        }
    };
    private boolean executionTimerPending = false;
    private final CircularIterator iterator = new CircularIterator();
    static final /* synthetic */ boolean $assertionsDisabled;

    CommandExecutor() {
    }

    private static boolean hasTimeSliceExpired(long currentTimeMillis, long startTimeMillis) {
        return Math.abs(currentTimeMillis - startTimeMillis) >= 100L;
    }

    public void submit(Command command) {
        this.commands.add(command);
        this.maybeStartExecutionTimer();
    }

    public void submit(IncrementalCommand command) {
        this.commands.add(command);
        this.maybeStartExecutionTimer();
    }

    protected void doCommandCanceled() {
        GWT.UncaughtExceptionHandler ueh;
        Object cmd = this.iterator.getLast();
        this.iterator.remove();
        if (!$assertionsDisabled && cmd == null) {
            throw new AssertionError();
        }
        RuntimeException ex = null;
        if (cmd instanceof Command) {
            ex = new CommandCanceledException((Command)cmd);
        } else if (cmd instanceof IncrementalCommand) {
            ex = new IncrementalCommandCanceledException((IncrementalCommand)cmd);
        }
        if (ex != null && (ueh = GWT.getUncaughtExceptionHandler()) != null) {
            ueh.onUncaughtException(ex);
        }
        this.setExecuting(false);
        this.maybeStartExecutionTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecuteCommands(long startTimeMillis) {
        block20: {
            if (!$assertionsDisabled && this.isExecutionTimerPending()) {
                throw new AssertionError();
            }
            boolean wasCanceled = false;
            try {
                boolean removeCommand;
                block22: {
                    Object element;
                    block21: {
                        this.setExecuting(true);
                        this.iterator.setEnd(this.commands.size());
                        this.cancellationTimer.schedule(10000);
                        if (!this.iterator.hasNext()) break block20;
                        element = this.iterator.next();
                        removeCommand = true;
                        try {
                            if (element != null) break block21;
                        }
                        catch (Throwable throwable) {
                            wasCanceled = this.iterator.wasRemoved();
                            if (wasCanceled) {
                                return;
                            }
                            if (removeCommand) {
                                this.iterator.remove();
                            }
                            throw throwable;
                        }
                        wasCanceled = this.iterator.wasRemoved();
                        if (wasCanceled) {
                            return;
                        }
                        if (removeCommand) {
                            this.iterator.remove();
                        }
                        return;
                    }
                    if (element instanceof Command) {
                        Command command = (Command)element;
                        command.execute();
                        break block22;
                    }
                    if (!(element instanceof IncrementalCommand)) break block22;
                    IncrementalCommand incrementalCommand = (IncrementalCommand)element;
                    removeCommand = !incrementalCommand.execute();
                }
                wasCanceled = this.iterator.wasRemoved();
                if (wasCanceled) {
                    return;
                }
                if (removeCommand) {
                    this.iterator.remove();
                }
            }
            finally {
                if (!wasCanceled) {
                    this.cancellationTimer.cancel();
                    this.setExecuting(false);
                    this.maybeStartExecutionTimer();
                }
            }
        }
    }

    protected void maybeStartExecutionTimer() {
        if (!(this.commands.isEmpty() || this.isExecutionTimerPending() || this.isExecuting())) {
            this.setExecutionTimerPending(true);
            this.executionTimer.schedule(1);
        }
    }

    List getPendingCommands() {
        return this.commands;
    }

    void setExecuting(boolean executing) {
        this.executing = executing;
    }

    void setLast(int last) {
        this.iterator.setLast(last);
    }

    private boolean isExecuting() {
        return this.executing;
    }

    private boolean isExecutionTimerPending() {
        return this.executionTimerPending;
    }

    private void setExecutionTimerPending(boolean pending) {
        this.executionTimerPending = pending;
    }

    static {
        $assertionsDisabled = !CommandExecutor.class.desiredAssertionStatus();
    }

    private class CircularIterator
    implements Iterator {
        private int end;
        private int last = -1;
        private int next = 0;
        static final /* synthetic */ boolean $assertionsDisabled;

        private CircularIterator() {
        }

        public boolean hasNext() {
            return this.next < this.end;
        }

        public Object next() {
            this.last = this.next;
            Object command = CommandExecutor.this.commands.get(this.next++);
            if (this.next >= this.end) {
                this.next = 0;
            }
            return command;
        }

        public void remove() {
            if (!$assertionsDisabled && this.last < 0) {
                throw new AssertionError();
            }
            CommandExecutor.this.commands.remove(this.last);
            --this.end;
            if (this.last <= this.next && --this.next < 0) {
                this.next = 0;
            }
            this.last = -1;
        }

        private Object getLast() {
            if (!$assertionsDisabled && this.last < 0) {
                throw new AssertionError();
            }
            return CommandExecutor.this.commands.get(this.last);
        }

        private void setEnd(int end) {
            if (!$assertionsDisabled && end < this.next) {
                throw new AssertionError();
            }
            this.end = end;
        }

        private void setLast(int last) {
            this.last = last;
        }

        private boolean wasRemoved() {
            return this.last == -1;
        }

        static {
            $assertionsDisabled = !(class$com$google$gwt$user$client$CommandExecutor == null ? (class$com$google$gwt$user$client$CommandExecutor = CommandExecutor.class$("com.google.gwt.user.client.CommandExecutor")) : class$com$google$gwt$user$client$CommandExecutor).desiredAssertionStatus();
        }
    }
}

