/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;

public class DialogBox
extends PopupPanel
implements HasHTML,
MouseListener {
    private HTML caption = new HTML();
    private Widget child;
    private boolean dragging;
    private int dragStartX;
    private int dragStartY;
    private FlexTable panel = new FlexTable();

    public DialogBox() {
        this(false);
    }

    public DialogBox(boolean autoHide) {
        this(autoHide, true);
    }

    public DialogBox(boolean autoHide, boolean modal) {
        super(autoHide, modal);
        this.panel.setWidget(0, 0, this.caption);
        this.panel.setHeight("100%");
        this.panel.setBorderWidth(0);
        this.panel.setCellPadding(0);
        this.panel.setCellSpacing(0);
        this.panel.getCellFormatter().setHeight(1, 0, "100%");
        this.panel.getCellFormatter().setWidth(1, 0, "100%");
        this.panel.getCellFormatter().setAlignment(1, 0, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
        super.setWidget(this.panel);
        this.setStyleName("gwt-DialogBox");
        this.caption.setStyleName("Caption");
        this.caption.addMouseListener(this);
    }

    public String getHTML() {
        return this.caption.getHTML();
    }

    public String getText() {
        return this.caption.getText();
    }

    public boolean onEventPreview(Event event) {
        if (DOM.eventGetType(event) == 4 && DOM.isOrHasChild(this.caption.getElement(), DOM.eventGetTarget(event))) {
            DOM.eventPreventDefault(event);
        }
        return super.onEventPreview(event);
    }

    public void onMouseDown(Widget sender, int x, int y) {
        this.dragging = true;
        DOM.setCapture(this.caption.getElement());
        this.dragStartX = x;
        this.dragStartY = y;
    }

    public void onMouseEnter(Widget sender) {
    }

    public void onMouseLeave(Widget sender) {
    }

    public void onMouseMove(Widget sender, int x, int y) {
        if (this.dragging) {
            int absX = x + this.getAbsoluteLeft();
            int absY = y + this.getAbsoluteTop();
            this.setPopupPosition(absX - this.dragStartX, absY - this.dragStartY);
        }
    }

    public void onMouseUp(Widget sender, int x, int y) {
        this.dragging = false;
        DOM.releaseCapture(this.caption.getElement());
    }

    public boolean remove(Widget w) {
        if (this.child != w) {
            return false;
        }
        this.panel.remove(w);
        return true;
    }

    public void setHTML(String html) {
        this.caption.setHTML(html);
    }

    public void setText(String text) {
        this.caption.setText(text);
    }

    public void setWidget(Widget w) {
        if (this.child != null) {
            this.panel.remove(this.child);
        }
        if (w != null) {
            this.panel.setWidget(1, 0, w);
        }
        this.child = w;
    }

    public void setWidth(String width) {
        super.setWidth(width);
        this.panel.setWidth("100%");
    }
}

