/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SourcesTableEvents;
import com.google.gwt.user.client.ui.TableListener;
import com.google.gwt.user.client.ui.TableListenerCollection;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class HTMLTable
extends Panel
implements SourcesTableEvents {
    private final Element bodyElem;
    private CellFormatter cellFormatter;
    private ColumnFormatter columnFormatter;
    private RowFormatter rowFormatter;
    private final Element tableElem;
    private TableListenerCollection tableListeners;
    private WidgetMapper widgetMap = new WidgetMapper();
    static /* synthetic */ Class class$com$google$gwt$user$client$ui$HTMLTable;

    public HTMLTable() {
        this.tableElem = DOM.createTable();
        this.bodyElem = DOM.createTBody();
        DOM.appendChild(this.tableElem, this.bodyElem);
        this.setElement(this.tableElem);
        this.sinkEvents(1);
    }

    public void addTableListener(TableListener listener) {
        if (this.tableListeners == null) {
            this.tableListeners = new TableListenerCollection();
        }
        this.tableListeners.add(listener);
    }

    public void clear() {
        for (int row = 0; row < this.getRowCount(); ++row) {
            for (int col = 0; col < this.getCellCount(row); ++col) {
                Widget child = this.getWidgetImpl(row, col);
                if (child == null) continue;
                this.remove(child);
            }
        }
    }

    public boolean clearCell(int row, int column) {
        Element td = this.getCellFormatter().getElement(row, column);
        return this.internalClearCell(td, true);
    }

    public abstract int getCellCount(int var1);

    public CellFormatter getCellFormatter() {
        return this.cellFormatter;
    }

    public int getCellPadding() {
        return DOM.getElementPropertyInt(this.tableElem, "cellPadding");
    }

    public int getCellSpacing() {
        return DOM.getElementPropertyInt(this.tableElem, "cellSpacing");
    }

    public ColumnFormatter getColumnFormatter() {
        return this.columnFormatter;
    }

    public String getHTML(int row, int column) {
        return DOM.getInnerHTML(this.cellFormatter.getElement(row, column));
    }

    public abstract int getRowCount();

    public RowFormatter getRowFormatter() {
        return this.rowFormatter;
    }

    public String getText(int row, int column) {
        this.checkCellBounds(row, column);
        Element e = this.cellFormatter.getElement(row, column);
        return DOM.getInnerText(e);
    }

    public Widget getWidget(int row, int column) {
        this.checkCellBounds(row, column);
        return this.getWidgetImpl(row, column);
    }

    public boolean isCellPresent(int row, int column) {
        if (row >= this.getRowCount() || row < 0) {
            return false;
        }
        return column >= 0 && column < this.getCellCount(row);
    }

    public Iterator iterator() {
        return this.widgetMap.widgetIterator();
    }

    public void onBrowserEvent(Event event) {
        switch (DOM.eventGetType(event)) {
            case 1: {
                if (this.tableListeners == null) break;
                Element td = this.getEventTargetCell(event);
                if (td == null) {
                    return;
                }
                Element tr = DOM.getParent(td);
                Element body = DOM.getParent(tr);
                int row = DOM.getChildIndex(body, tr);
                int column = DOM.getChildIndex(tr, td);
                this.tableListeners.fireCellClicked(this, row, column);
                break;
            }
        }
    }

    public boolean remove(Widget widget) {
        if (widget.getParent() != this) {
            return false;
        }
        this.orphan(widget);
        Element elem = widget.getElement();
        DOM.removeChild(DOM.getParent(elem), elem);
        this.widgetMap.removeWidgetByElement(elem);
        return true;
    }

    public void removeTableListener(TableListener listener) {
        if (this.tableListeners != null) {
            this.tableListeners.remove(listener);
        }
    }

    public void setBorderWidth(int width) {
        DOM.setElementProperty(this.tableElem, "border", "" + width);
    }

    public void setCellPadding(int padding) {
        DOM.setElementPropertyInt(this.tableElem, "cellPadding", padding);
    }

    public void setCellSpacing(int spacing) {
        DOM.setElementPropertyInt(this.tableElem, "cellSpacing", spacing);
    }

    public void setHTML(int row, int column, String html) {
        this.prepareCell(row, column);
        Element td = this.cleanCell(row, column, html == null);
        if (html != null) {
            DOM.setInnerHTML(td, html);
        }
    }

    public void setText(int row, int column, String text) {
        this.prepareCell(row, column);
        Element td = this.cleanCell(row, column, text == null);
        if (text != null) {
            DOM.setInnerText(td, text);
        }
    }

    public void setWidget(int row, int column, Widget widget) {
        this.prepareCell(row, column);
        if (widget != null) {
            widget.removeFromParent();
            Element td = this.cleanCell(row, column, true);
            this.widgetMap.putWidget(widget);
            DOM.appendChild(td, widget.getElement());
            this.adopt(widget);
        }
    }

    protected void checkCellBounds(int row, int column) {
        this.checkRowBounds(row);
        if (column < 0) {
            throw new IndexOutOfBoundsException("Column " + column + " must be non-negative: " + column);
        }
        int cellSize = this.getCellCount(row);
        if (cellSize <= column) {
            throw new IndexOutOfBoundsException("Column index: " + column + ", Column size: " + this.getCellCount(row));
        }
    }

    protected void checkRowBounds(int row) {
        int rowSize = this.getRowCount();
        if (row >= rowSize || row < 0) {
            throw new IndexOutOfBoundsException("Row index: " + row + ", Row size: " + rowSize);
        }
    }

    protected Element createCell() {
        return DOM.createTD();
    }

    protected Element getBodyElement() {
        return this.bodyElem;
    }

    protected native int getDOMCellCount(Element var1, int var2);

    protected int getDOMCellCount(int row) {
        return this.getDOMCellCount(this.bodyElem, row);
    }

    protected int getDOMRowCount() {
        return this.getDOMRowCount(this.bodyElem);
    }

    protected native int getDOMRowCount(Element var1);

    protected Element getEventTargetCell(Event event) {
        Element td = DOM.eventGetTarget(event);
        while (td != null) {
            Element tr;
            Element body;
            if (DOM.getElementProperty(td, "tagName").equalsIgnoreCase("td") && DOM.compare(body = DOM.getParent(tr = DOM.getParent(td)), this.bodyElem)) {
                return td;
            }
            if (DOM.compare(td, this.bodyElem)) {
                return null;
            }
            td = DOM.getParent(td);
        }
        return null;
    }

    protected void insertCell(int row, int column) {
        Element tr = this.rowFormatter.getRow(this.bodyElem, row);
        Element td = this.createCell();
        DOM.insertChild(tr, td, column);
    }

    protected void insertCells(int row, int column, int count) {
        Element tr = this.rowFormatter.getRow(this.bodyElem, row);
        for (int i = column; i < column + count; ++i) {
            Element td = this.createCell();
            DOM.insertChild(tr, td, i);
        }
    }

    protected int insertRow(int beforeRow) {
        if (beforeRow != this.getRowCount()) {
            this.checkRowBounds(beforeRow);
        }
        Element tr = DOM.createTR();
        DOM.insertChild(this.bodyElem, tr, beforeRow);
        return beforeRow;
    }

    protected boolean internalClearCell(Element td, boolean clearInnerHTML) {
        Element maybeChild = DOM.getFirstChild(td);
        Widget widget = null;
        if (maybeChild != null) {
            widget = this.widgetMap.getWidget(maybeChild);
        }
        if (widget != null) {
            this.remove(widget);
            return true;
        }
        if (clearInnerHTML) {
            DOM.setInnerHTML(td, "");
        }
        return false;
    }

    protected abstract void prepareCell(int var1, int var2);

    protected void prepareColumn(int column) {
    }

    protected abstract void prepareRow(int var1);

    protected void removeCell(int row, int column) {
        this.checkCellBounds(row, column);
        Element td = this.cleanCell(row, column, false);
        Element tr = this.rowFormatter.getRow(this.bodyElem, row);
        DOM.removeChild(tr, td);
    }

    protected void removeRow(int row) {
        int columnCount = this.getCellCount(row);
        for (int column = 0; column < columnCount; ++column) {
            this.cleanCell(row, column, false);
        }
        DOM.removeChild(this.bodyElem, this.rowFormatter.getRow(this.bodyElem, row));
    }

    protected void setCellFormatter(CellFormatter cellFormatter) {
        this.cellFormatter = cellFormatter;
    }

    protected void setColumnFormatter(ColumnFormatter formatter) {
        this.columnFormatter = formatter;
        this.columnFormatter.prepareColumnGroup();
    }

    protected void setRowFormatter(RowFormatter rowFormatter) {
        this.rowFormatter = rowFormatter;
    }

    private Element cleanCell(int row, int column, boolean clearInnerHTML) {
        Element td = this.getCellFormatter().getRawElement(row, column);
        this.internalClearCell(td, clearInnerHTML);
        return td;
    }

    private Widget getWidgetImpl(int row, int column) {
        Element e = this.cellFormatter.getRawElement(row, column);
        Element child = DOM.getFirstChild(e);
        if (child == null) {
            return null;
        }
        return this.widgetMap.getWidget(child);
    }

    private static class WidgetMapper {
        private FreeNode freeList = null;
        private final ArrayList widgetList = new ArrayList();

        private WidgetMapper() {
        }

        private static native void clearWidgetIndex(Element var0);

        private static native int getWidgetIndex(Element var0);

        private static native void setWidgetIndex(Element var0, int var1);

        public Widget getWidget(Element elem) {
            int index = WidgetMapper.getWidgetIndex(elem);
            if (index < 0) {
                return null;
            }
            return (Widget)this.widgetList.get(index);
        }

        public void putWidget(Widget widget) {
            int index;
            if (this.freeList == null) {
                index = this.widgetList.size();
                this.widgetList.add(widget);
            } else {
                index = this.freeList.index;
                this.widgetList.set(index, widget);
                this.freeList = this.freeList.next;
            }
            WidgetMapper.setWidgetIndex(widget.getElement(), index);
        }

        public void removeWidgetByElement(Element elem) {
            int index = WidgetMapper.getWidgetIndex(elem);
            this.removeImpl(elem, index);
        }

        public Iterator widgetIterator() {
            return new Iterator(){
                int lastIndex = -1;
                int nextIndex = -1;
                static final /* synthetic */ boolean $assertionsDisabled;
                {
                    this.findNext();
                }

                public boolean hasNext() {
                    return this.nextIndex < WidgetMapper.this.widgetList.size();
                }

                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Object result = WidgetMapper.this.widgetList.get(this.nextIndex);
                    this.lastIndex = this.nextIndex;
                    this.findNext();
                    return result;
                }

                public void remove() {
                    if (this.lastIndex < 0) {
                        throw new IllegalStateException();
                    }
                    Widget w = (Widget)WidgetMapper.this.widgetList.get(this.lastIndex);
                    if (!$assertionsDisabled && !(w.getParent() instanceof HTMLTable)) {
                        throw new AssertionError();
                    }
                    w.removeFromParent();
                    this.lastIndex = -1;
                }

                private void findNext() {
                    while (++this.nextIndex < WidgetMapper.this.widgetList.size()) {
                        if (WidgetMapper.this.widgetList.get(this.nextIndex) == null) continue;
                        return;
                    }
                }

                static {
                    $assertionsDisabled = !(class$com$google$gwt$user$client$ui$HTMLTable == null ? (class$com$google$gwt$user$client$ui$HTMLTable = HTMLTable.class$("com.google.gwt.user.client.ui.HTMLTable")) : class$com$google$gwt$user$client$ui$HTMLTable).desiredAssertionStatus();
                }
            };
        }

        private void removeImpl(Element elem, int index) {
            WidgetMapper.clearWidgetIndex(elem);
            this.widgetList.set(index, null);
            this.freeList = new FreeNode(index, this.freeList);
        }

        private static class FreeNode {
            int index;
            FreeNode next;

            public FreeNode(int index, FreeNode next) {
                this.index = index;
                this.next = next;
            }
        }
    }

    public class RowFormatter {
        public void addStyleName(int row, String styleName) {
            UIObject.setStyleName(this.ensureElement(row), styleName, true);
        }

        public Element getElement(int row) {
            HTMLTable.this.checkRowBounds(row);
            return this.getRow(HTMLTable.this.bodyElem, row);
        }

        public String getStyleName(int row) {
            return UIObject.getStyleName(this.getElement(row));
        }

        public String getStylePrimaryName(int row) {
            return UIObject.getStylePrimaryName(this.getElement(row));
        }

        public boolean isVisible(int row) {
            Element e = this.getElement(row);
            return UIObject.isVisible(e);
        }

        public void removeStyleName(int row, String styleName) {
            UIObject.setStyleName(this.ensureElement(row), styleName, false);
        }

        public void setStyleName(int row, String styleName) {
            UIObject.setStyleName(this.ensureElement(row), styleName);
        }

        public void setStylePrimaryName(int row, String styleName) {
            UIObject.setStylePrimaryName(this.ensureElement(row), styleName);
        }

        public void setVerticalAlign(int row, HasVerticalAlignment.VerticalAlignmentConstant align) {
            DOM.setStyleAttribute(this.ensureElement(row), "verticalAlign", align.getVerticalAlignString());
        }

        public void setVisible(int row, boolean visible) {
            Element e = this.ensureElement(row);
            UIObject.setVisible(e, visible);
        }

        protected Element ensureElement(int row) {
            HTMLTable.this.prepareRow(row);
            return this.getRow(HTMLTable.this.bodyElem, row);
        }

        protected native Element getRow(Element var1, int var2);

        protected void setAttr(int row, String attrName, String value) {
            Element elem = this.ensureElement(row);
            DOM.setElementAttribute(elem, attrName, value);
        }
    }

    public class ColumnFormatter {
        protected Element columnGroup;

        public void addStyleName(int col, String styleName) {
            UIObject.setStyleName(this.ensureColumn(col), styleName, true);
        }

        public String getStyleName(int column) {
            return UIObject.getStyleName(this.ensureColumn(column));
        }

        public String getStylePrimaryName(int column) {
            return UIObject.getStylePrimaryName(this.ensureColumn(column));
        }

        public void removeStyleName(int column, String styleName) {
            UIObject.setStyleName(this.ensureColumn(column), styleName, false);
        }

        public void setStyleName(int column, String styleName) {
            UIObject.setStyleName(this.ensureColumn(column), styleName);
        }

        public void setStylePrimaryName(int column, String styleName) {
            UIObject.setStylePrimaryName(this.ensureColumn(column), styleName);
        }

        public void setWidth(int column, String width) {
            DOM.setElementProperty(this.ensureColumn(column), "width", width);
        }

        private Element ensureColumn(int col) {
            HTMLTable.this.prepareColumn(col);
            this.prepareColumnGroup();
            int num = DOM.getChildCount(this.columnGroup);
            if (num <= col) {
                Element colElement = null;
                for (int i = num; i <= col; ++i) {
                    colElement = DOM.createElement("col");
                    DOM.appendChild(this.columnGroup, colElement);
                }
                return colElement;
            }
            return DOM.getChild(this.columnGroup, col);
        }

        private void prepareColumnGroup() {
            if (this.columnGroup == null) {
                this.columnGroup = DOM.createElement("colgroup");
                DOM.insertChild(HTMLTable.this.tableElem, this.columnGroup, 0);
                DOM.appendChild(this.columnGroup, DOM.createElement("col"));
            }
        }
    }

    public class CellFormatter {
        public void addStyleName(int row, int column, String styleName) {
            HTMLTable.this.prepareCell(row, column);
            Element td = this.getCellElement(HTMLTable.this.bodyElem, row, column);
            UIObject.setStyleName(td, styleName, true);
        }

        public Element getElement(int row, int column) {
            HTMLTable.this.checkCellBounds(row, column);
            return this.getCellElement(HTMLTable.this.bodyElem, row, column);
        }

        public String getStyleName(int row, int column) {
            return UIObject.getStyleName(this.getElement(row, column));
        }

        public String getStylePrimaryName(int row, int column) {
            return UIObject.getStylePrimaryName(this.getElement(row, column));
        }

        public boolean isVisible(int row, int column) {
            Element e = this.getElement(row, column);
            return UIObject.isVisible(e);
        }

        public void removeStyleName(int row, int column, String styleName) {
            HTMLTable.this.checkCellBounds(row, column);
            Element td = this.getCellElement(HTMLTable.this.bodyElem, row, column);
            UIObject.setStyleName(td, styleName, false);
        }

        public void setAlignment(int row, int column, HasHorizontalAlignment.HorizontalAlignmentConstant hAlign, HasVerticalAlignment.VerticalAlignmentConstant vAlign) {
            this.setHorizontalAlignment(row, column, hAlign);
            this.setVerticalAlignment(row, column, vAlign);
        }

        public void setHeight(int row, int column, String height) {
            HTMLTable.this.prepareCell(row, column);
            Element elem = this.getCellElement(HTMLTable.this.bodyElem, row, column);
            DOM.setElementProperty(elem, "height", height);
        }

        public void setHorizontalAlignment(int row, int column, HasHorizontalAlignment.HorizontalAlignmentConstant align) {
            HTMLTable.this.prepareCell(row, column);
            Element elem = this.getCellElement(HTMLTable.this.bodyElem, row, column);
            DOM.setElementProperty(elem, "align", align.getTextAlignString());
        }

        public void setStyleName(int row, int column, String styleName) {
            HTMLTable.this.prepareCell(row, column);
            UIObject.setStyleName(this.getCellElement(HTMLTable.this.bodyElem, row, column), styleName);
        }

        public void setStylePrimaryName(int row, int column, String styleName) {
            UIObject.setStylePrimaryName(this.getCellElement(HTMLTable.this.bodyElem, row, column), styleName);
        }

        public void setVerticalAlignment(int row, int column, HasVerticalAlignment.VerticalAlignmentConstant align) {
            HTMLTable.this.prepareCell(row, column);
            DOM.setStyleAttribute(this.getCellElement(HTMLTable.this.bodyElem, row, column), "verticalAlign", align.getVerticalAlignString());
        }

        public void setVisible(int row, int column, boolean visible) {
            Element e = this.ensureElement(row, column);
            UIObject.setVisible(e, visible);
        }

        public void setWidth(int row, int column, String width) {
            HTMLTable.this.prepareCell(row, column);
            DOM.setElementProperty(this.getCellElement(HTMLTable.this.bodyElem, row, column), "width", width);
        }

        public void setWordWrap(int row, int column, boolean wrap) {
            HTMLTable.this.prepareCell(row, column);
            String wrapValue = wrap ? "" : "nowrap";
            DOM.setStyleAttribute(this.getElement(row, column), "whiteSpace", wrapValue);
        }

        protected Element ensureElement(int row, int column) {
            HTMLTable.this.prepareCell(row, column);
            return this.getCellElement(HTMLTable.this.bodyElem, row, column);
        }

        protected String getAttr(int row, int column, String attr) {
            Element elem = this.getElement(row, column);
            return DOM.getElementAttribute(elem, attr);
        }

        protected void setAttr(int row, int column, String attrName, String value) {
            Element elem = this.ensureElement(row, column);
            DOM.setElementAttribute(elem, attrName, value);
        }

        private native Element getCellElement(Element var1, int var2, int var3);

        private Element getRawElement(int row, int column) {
            return this.getCellElement(HTMLTable.this.bodyElem, row, column);
        }
    }
}

