/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.HorizontalSplitPanelImages;
import com.google.gwt.user.client.ui.SplitPanel;
import com.google.gwt.user.client.ui.Widget;

public final class HorizontalSplitPanel
extends SplitPanel {
    private static final int LEFT = 0;
    private static final int RIGHT = 1;
    private final Element container;
    private final Impl impl = (Impl)GWT.create(Impl.class);
    private String lastSplitPosition = "50%";
    private int initialThumbPos;
    private int initialLeftWidth;

    public HorizontalSplitPanel() {
        this((HorizontalSplitPanelImages)GWT.create(HorizontalSplitPanelImages.class));
    }

    public HorizontalSplitPanel(HorizontalSplitPanelImages images) {
        super(DOM.createDiv(), DOM.createDiv(), HorizontalSplitPanel.preventBoxStyles(DOM.createDiv()), HorizontalSplitPanel.preventBoxStyles(DOM.createDiv()));
        this.container = HorizontalSplitPanel.preventBoxStyles(DOM.createDiv());
        this.buildDOM(images.horizontalSplitPanelThumb());
        this.setStyleName("gwt-HorizontalSplitPanel");
        this.impl.init(this);
        this.setHeight("100%");
    }

    public final Widget getLeftWidget() {
        return this.getWidget(0);
    }

    public final Widget getRightWidget() {
        return this.getWidget(1);
    }

    public final void setLeftWidget(Widget w) {
        this.setWidget(0, w);
    }

    public final void setRightWidget(Widget w) {
        this.setWidget(1, w);
    }

    public final void setSplitPosition(String pos) {
        this.lastSplitPosition = pos;
        Element leftElem = this.getElement(0);
        HorizontalSplitPanel.setWidth(leftElem, pos);
        this.impl.setSplitPosition(HorizontalSplitPanel.getOffsetWidth(leftElem));
    }

    protected void onLoad() {
        this.impl.onAttach();
        this.setSplitPosition(this.lastSplitPosition);
        DeferredCommand.addCommand(new Command(){

            public void execute() {
                HorizontalSplitPanel.this.setSplitPosition(HorizontalSplitPanel.this.lastSplitPosition);
            }
        });
    }

    protected void onUnload() {
        this.impl.onDetach();
    }

    final void onSplitterResize(int x, int y) {
        this.impl.onSplitResize(this.initialLeftWidth + x - this.initialThumbPos);
    }

    final void onSplitterResizeStarted(int x, int y) {
        this.initialThumbPos = x;
        this.initialLeftWidth = HorizontalSplitPanel.getOffsetWidth(this.getElement(0));
    }

    private void buildDOM(AbstractImagePrototype thumbImage) {
        Element leftDiv = this.getElement(0);
        Element rightDiv = this.getElement(1);
        Element splitDiv = this.getSplitElement();
        DOM.appendChild(this.getElement(), this.container);
        DOM.appendChild(this.container, leftDiv);
        DOM.appendChild(this.container, splitDiv);
        DOM.appendChild(this.container, rightDiv);
        DOM.setInnerHTML(splitDiv, "<table class='hsplitter' height='100%' cellpadding='0' cellspacing='0'><tr><td align='center' valign='middle'>" + thumbImage.getHTML());
        HorizontalSplitPanel.addScrolling(leftDiv);
        HorizontalSplitPanel.addScrolling(rightDiv);
    }

    private static class ImplSafari
    extends Impl {
        private ImplSafari() {
        }

        public void init(HorizontalSplitPanel panel) {
            this.panel = panel;
            String fullSize = "100%";
            super.init(panel);
            SplitPanel.setHeight(panel.container, "100%");
            SplitPanel.setHeight(panel.getElement(0), "100%");
            SplitPanel.setHeight(panel.getElement(1), "100%");
            SplitPanel.setHeight(panel.getSplitElement(), "100%");
        }
    }

    private static class ImplIE6
    extends Impl {
        private boolean isResizeInProgress = false;
        private int splitPosition = 0;

        private ImplIE6() {
        }

        public void init(HorizontalSplitPanel panel) {
            this.panel = panel;
            Element elem = panel.getElement();
            DOM.setStyleAttribute(elem, "textAlign", "left");
            DOM.setStyleAttribute(elem, "position", "relative");
            SplitPanel.addAbsolutePositoning(panel.getElement(0));
            SplitPanel.addAbsolutePositoning(panel.getElement(1));
            SplitPanel.addAbsolutePositoning(panel.getSplitElement());
            SplitPanel.expandToFitParentUsingPercentages(panel.container);
        }

        public void onAttach() {
            this.addResizeListener(this.panel.container);
            this.onResize();
        }

        public void onDetach() {
            DOM.setElementAttribute(this.panel.container, "onresize", null);
        }

        public void onSplitResize(int px) {
            int resizeUpdatePeriod = 20;
            if (!this.isResizeInProgress) {
                this.isResizeInProgress = true;
                new Timer(){

                    public void run() {
                        ImplIE6.this.setSplitPosition(ImplIE6.this.splitPosition);
                        ImplIE6.this.isResizeInProgress = false;
                    }
                }.schedule(20);
            }
            this.splitPosition = px;
        }

        public void updateRightWidth(Element rightElem, int newRightWidth) {
            SplitPanel.setWidth(rightElem, newRightWidth + "px");
        }

        private native void addResizeListener(Element var1);

        private void onResize() {
            Element leftElem = this.panel.getElement(0);
            Element rightElem = this.panel.getElement(1);
            String height = SplitPanel.getOffsetHeight(this.panel.container) + "px";
            SplitPanel.setHeight(rightElem, height);
            SplitPanel.setHeight(this.panel.getSplitElement(), height);
            SplitPanel.setHeight(leftElem, height);
            this.setSplitPosition(SplitPanel.getOffsetWidth(leftElem));
        }
    }

    private static class Impl {
        protected HorizontalSplitPanel panel;

        private Impl() {
        }

        private static void expandToFitParentHorizontally(Element elem) {
            SplitPanel.addAbsolutePositoning(elem);
            String zeroSize = "0px";
            SplitPanel.setTop(elem, "0px");
            SplitPanel.setBottom(elem, "0px");
        }

        public void init(HorizontalSplitPanel panel) {
            this.panel = panel;
            DOM.setStyleAttribute(panel.getElement(), "position", "relative");
            Element rightElem = panel.getElement(1);
            Impl.expandToFitParentHorizontally(panel.getElement(0));
            Impl.expandToFitParentHorizontally(rightElem);
            Impl.expandToFitParentHorizontally(panel.getSplitElement());
            SplitPanel.expandToFitParentUsingCssOffsets(panel.container);
            SplitPanel.setRight(rightElem, "0px");
        }

        public void onAttach() {
        }

        public void onDetach() {
        }

        public void onSplitResize(int px) {
            this.setSplitPosition(px);
        }

        public void setSplitPosition(int px) {
            int splitElemWidth;
            Element splitElem = this.panel.getSplitElement();
            int rootElemWidth = SplitPanel.getOffsetWidth(this.panel.container);
            if (rootElemWidth < (splitElemWidth = SplitPanel.getOffsetWidth(splitElem))) {
                return;
            }
            int newRightWidth = rootElemWidth - px - splitElemWidth;
            if (px < 0) {
                px = 0;
                newRightWidth = rootElemWidth - splitElemWidth;
            } else if (newRightWidth < 0) {
                px = rootElemWidth - splitElemWidth;
                newRightWidth = 0;
            }
            Element rightElem = this.panel.getElement(1);
            SplitPanel.setWidth(this.panel.getElement(0), px + "px");
            SplitPanel.setLeft(splitElem, px + "px");
            SplitPanel.setLeft(rightElem, px + splitElemWidth + "px");
            this.updateRightWidth(rightElem, newRightWidth);
        }

        public void updateRightWidth(Element rightElem, int newRightWidth) {
        }
    }
}

