/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ChangeListenerCollection;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.SourcesChangeEvents;

public class ListBox
extends FocusWidget
implements SourcesChangeEvents,
HasName {
    private static final int INSERT_AT_END = -1;
    private static final Impl impl = (Impl)GWT.create(Impl.class);
    private ChangeListenerCollection changeListeners;

    public ListBox() {
        this(false);
    }

    public ListBox(boolean isMultipleSelect) {
        super(DOM.createSelect(isMultipleSelect));
        this.sinkEvents(1024);
        this.setStyleName("gwt-ListBox");
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ChangeListenerCollection();
        }
        this.changeListeners.add(listener);
    }

    public void addItem(String item) {
        this.insertItem(item, -1);
    }

    public void addItem(String item, String value) {
        this.insertItem(item, value, -1);
    }

    public void clear() {
        impl.clear(this.getElement());
    }

    public int getItemCount() {
        return impl.getItemCount(this.getElement());
    }

    public String getItemText(int index) {
        this.checkIndex(index);
        return impl.getItemText(this.getElement(), index);
    }

    public String getName() {
        return DOM.getElementProperty(this.getElement(), "name");
    }

    public int getSelectedIndex() {
        return DOM.getElementPropertyInt(this.getElement(), "selectedIndex");
    }

    public String getValue(int index) {
        this.checkIndex(index);
        return impl.getItemValue(this.getElement(), index);
    }

    public int getVisibleItemCount() {
        return DOM.getElementPropertyInt(this.getElement(), "size");
    }

    public void insertItem(String item, int index) {
        this.insertItem(item, item, index);
    }

    public void insertItem(String item, String value, int index) {
        DOM.insertListItem(this.getElement(), item, value, index);
    }

    public boolean isItemSelected(int index) {
        this.checkIndex(index);
        return impl.isItemSelected(this.getElement(), index);
    }

    public boolean isMultipleSelect() {
        return DOM.getElementPropertyBoolean(this.getElement(), "multiple");
    }

    public void onBrowserEvent(Event event) {
        if (DOM.eventGetType(event) == 1024) {
            if (this.changeListeners != null) {
                this.changeListeners.fireChange(this);
            }
        } else {
            super.onBrowserEvent(event);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(listener);
        }
    }

    public void removeItem(int index) {
        this.checkIndex(index);
        impl.removeItem(this.getElement(), index);
    }

    public void setItemSelected(int index, boolean selected) {
        this.checkIndex(index);
        impl.setItemSelected(this.getElement(), index, selected);
    }

    public void setItemText(int index, String text) {
        this.checkIndex(index);
        if (text == null) {
            throw new NullPointerException("Cannot set an option to have null text");
        }
        DOM.setOptionText(this.getElement(), text, index);
    }

    public void setMultipleSelect(boolean multiple) {
        DOM.setElementPropertyBoolean(this.getElement(), "multiple", multiple);
    }

    public void setName(String name) {
        DOM.setElementProperty(this.getElement(), "name", name);
    }

    public void setSelectedIndex(int index) {
        DOM.setElementPropertyInt(this.getElement(), "selectedIndex", index);
    }

    public void setValue(int index, String value) {
        this.checkIndex(index);
        impl.setValue(this.getElement(), index, value);
    }

    public void setVisibleItemCount(int visibleItems) {
        DOM.setElementPropertyInt(this.getElement(), "size", visibleItems);
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.getItemCount()) {
            throw new IndexOutOfBoundsException();
        }
    }

    private static class ImplSafari
    extends Impl {
        private ImplSafari() {
        }

        public native void clear(Element var1);

        public native int getItemCount(Element var1);

        public native String getItemText(Element var1, int var2);

        public native String getItemValue(Element var1, int var2);

        public native boolean isItemSelected(Element var1, int var2);

        public native void removeItem(Element var1, int var2);

        public native void setItemSelected(Element var1, int var2, boolean var3);

        public native void setValue(Element var1, int var2, String var3);
    }

    private static class Impl {
        private Impl() {
        }

        public native void clear(Element var1);

        public native int getItemCount(Element var1);

        public native String getItemText(Element var1, int var2);

        public native String getItemValue(Element var1, int var2);

        public native boolean isItemSelected(Element var1, int var2);

        public native void removeItem(Element var1, int var2);

        public native void setItemSelected(Element var1, int var2, boolean var3);

        public native void setValue(Element var1, int var2, String var3);
    }
}

