/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.PrefixTree;
import com.google.gwt.user.client.ui.SuggestOracle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class MultiWordSuggestOracle
extends SuggestOracle {
    private static final char WHITESPACE_CHAR = ' ';
    private static final String WHITESPACE_STRING = " ";
    private static final String NORMALIZE_TO_SINGLE_WHITE_SPACE = "\\s+";
    private static HTML convertMe = new HTML();
    private final PrefixTree tree = new PrefixTree();
    private HashMap toCandidates = new HashMap();
    private HashMap toRealSuggestions = new HashMap();
    private char[] whitespaceChars;

    public MultiWordSuggestOracle() {
        this(WHITESPACE_STRING);
    }

    public MultiWordSuggestOracle(String whitespaceChars) {
        this.whitespaceChars = new char[whitespaceChars.length()];
        for (int i = 0; i < whitespaceChars.length(); ++i) {
            this.whitespaceChars[i] = whitespaceChars.charAt(i);
        }
    }

    public void add(String suggestion) {
        String candidate = this.normalizeSuggestion(suggestion);
        this.toRealSuggestions.put(candidate, suggestion);
        String[] words = candidate.split(WHITESPACE_STRING);
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            this.tree.add(word);
            HashSet<String> l = (HashSet<String>)this.toCandidates.get(word);
            if (l == null) {
                l = new HashSet<String>();
                this.toCandidates.put(word, l);
            }
            l.add(candidate);
        }
    }

    public void addAll(Collection collection) {
        Iterator suggestions = collection.iterator();
        while (suggestions.hasNext()) {
            this.add((String)suggestions.next());
        }
    }

    public void clear() {
        this.tree.clear();
        this.toCandidates.clear();
        this.toRealSuggestions.clear();
    }

    public boolean isDisplayStringHTML() {
        return true;
    }

    public void requestSuggestions(SuggestOracle.Request request, SuggestOracle.Callback callback) {
        List suggestions = this.computeItemsFor(request.getQuery(), request.getLimit());
        SuggestOracle.Response response = new SuggestOracle.Response(suggestions);
        callback.onSuggestionsReady(request, response);
    }

    String escapeText(String escapeMe) {
        convertMe.setText(escapeMe);
        String escaped = convertMe.getHTML();
        return escaped;
    }

    private List computeItemsFor(String query, int limit) {
        query = this.normalizeSearch(query);
        List candidates = this.createCandidatesFromSearch(query, limit);
        return this.convertToFormattedSuggestions(query, candidates);
    }

    private List convertToFormattedSuggestions(String query, List candidates) {
        ArrayList<MultiWordSuggestion> suggestions = new ArrayList<MultiWordSuggestion>();
        for (int i = 0; i < candidates.size(); ++i) {
            String candidate = (String)candidates.get(i);
            int index = 0;
            int cursor = 0;
            String formattedSuggestion = (String)this.toRealSuggestions.get(candidate);
            StringBuffer accum = new StringBuffer();
            while ((index = candidate.indexOf(query, index)) != -1) {
                int endIndex = index + query.length();
                if (index == 0 || ' ' == candidate.charAt(index - 1)) {
                    String part1 = this.escapeText(formattedSuggestion.substring(cursor, index));
                    String part2 = this.escapeText(formattedSuggestion.substring(index, endIndex));
                    cursor = endIndex;
                    accum.append(part1).append("<strong>").append(part2).append("</strong>");
                }
                index = endIndex;
            }
            if (cursor == 0) continue;
            String end = this.escapeText(formattedSuggestion.substring(cursor));
            accum.append(end);
            MultiWordSuggestion suggestion = new MultiWordSuggestion(formattedSuggestion, accum.toString());
            suggestions.add(suggestion);
        }
        return suggestions;
    }

    private List createCandidatesFromSearch(String query, int limit) {
        int i;
        ArrayList candidates = new ArrayList();
        if (query.length() == 0) {
            return candidates;
        }
        String[] searchWords = query.split(WHITESPACE_STRING);
        HashSet candidateSet = null;
        for (i = 0; i < searchWords.length; ++i) {
            String word = searchWords[i];
            if (word.length() == 0 || word.matches(WHITESPACE_STRING)) continue;
            HashSet thisWordChoices = this.createCandidatesFromWord(word);
            if (candidateSet == null) {
                candidateSet = thisWordChoices;
                continue;
            }
            candidateSet.retainAll(thisWordChoices);
            if (candidateSet.size() < 2) break;
        }
        if (candidateSet != null) {
            candidates.addAll(candidateSet);
            Collections.sort(candidates);
            for (i = candidates.size() - 1; i > limit; --i) {
                candidates.remove(i);
            }
        }
        return candidates;
    }

    private HashSet createCandidatesFromWord(String query) {
        HashSet candidateSet = new HashSet();
        List words = this.tree.getSuggestions(query, Integer.MAX_VALUE);
        if (words != null) {
            for (int i = 0; i < words.size(); ++i) {
                Collection belongsTo = (Collection)this.toCandidates.get(words.get(i));
                if (belongsTo == null) continue;
                candidateSet.addAll(belongsTo);
            }
        }
        return candidateSet;
    }

    private String normalizeSearch(String search) {
        search = this.normalizeSuggestion(search);
        search = search.replaceAll(NORMALIZE_TO_SINGLE_WHITE_SPACE, WHITESPACE_STRING);
        return search.trim();
    }

    private String normalizeSuggestion(String formattedSuggestion) {
        formattedSuggestion = formattedSuggestion.toLowerCase();
        if (this.whitespaceChars != null) {
            for (int i = 0; i < this.whitespaceChars.length; ++i) {
                char ignore = this.whitespaceChars[i];
                formattedSuggestion = formattedSuggestion.replace(ignore, ' ');
            }
        }
        return formattedSuggestion;
    }

    public static class MultiWordSuggestion
    implements SuggestOracle.Suggestion,
    IsSerializable {
        private String displayString;
        private String replacementString;

        public MultiWordSuggestion() {
        }

        public MultiWordSuggestion(String replacementString, String displayString) {
            this.replacementString = replacementString;
            this.displayString = displayString;
        }

        public String getDisplayString() {
            return this.displayString;
        }

        public String getReplacementString() {
            return this.replacementString;
        }
    }
}

