/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventPreview;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.KeyboardListenerCollection;
import com.google.gwt.user.client.ui.PopupListener;
import com.google.gwt.user.client.ui.PopupListenerCollection;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.SourcesPopupEvents;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.impl.PopupImpl;

public class PopupPanel
extends SimplePanel
implements SourcesPopupEvents,
EventPreview {
    private static final PopupImpl impl = (PopupImpl)GWT.create(PopupImpl.class);
    private boolean autoHide;
    private boolean modal;
    private boolean showing;
    private String desiredHeight;
    private String desiredWidth;
    private int leftPosition = -1;
    private int topPosition = -1;
    private PopupListenerCollection popupListeners;

    public PopupPanel() {
        super(impl.createElement());
        this.setPopupPosition(0, 0);
    }

    public PopupPanel(boolean autoHide) {
        this();
        this.autoHide = autoHide;
    }

    public PopupPanel(boolean autoHide, boolean modal) {
        this(autoHide);
        this.modal = modal;
    }

    public void addPopupListener(PopupListener listener) {
        if (this.popupListeners == null) {
            this.popupListeners = new PopupListenerCollection();
        }
        this.popupListeners.add(listener);
    }

    public void center() {
        boolean initiallyShowing = this.showing;
        if (!initiallyShowing) {
            this.setVisible(false);
            this.show();
        }
        int left = (Window.getClientWidth() - this.getOffsetWidth()) / 2;
        int top = (Window.getClientHeight() - this.getOffsetHeight()) / 2;
        this.setPopupPosition(Window.getScrollLeft() + left, Window.getScrollTop() + top);
        if (!initiallyShowing) {
            this.setVisible(true);
        }
    }

    public int getOffsetHeight() {
        return super.getOffsetHeight();
    }

    public int getOffsetWidth() {
        return super.getOffsetWidth();
    }

    public int getPopupLeft() {
        return DOM.getElementPropertyInt(this.getElement(), "offsetLeft");
    }

    public int getPopupTop() {
        return DOM.getElementPropertyInt(this.getElement(), "offsetTop");
    }

    public String getTitle() {
        return DOM.getElementProperty(this.getContainerElement(), "title");
    }

    public void hide() {
        this.hide(false);
    }

    public boolean onEventPreview(Event event) {
        Element target = DOM.eventGetTarget(event);
        boolean eventTargetsPopup = DOM.isOrHasChild(this.getElement(), target);
        int type = DOM.eventGetType(event);
        switch (type) {
            case 128: {
                boolean allow = this.onKeyDownPreview((char)DOM.eventGetKeyCode(event), KeyboardListenerCollection.getKeyboardModifiers(event));
                return allow && (eventTargetsPopup || !this.modal);
            }
            case 512: {
                boolean allow = this.onKeyUpPreview((char)DOM.eventGetKeyCode(event), KeyboardListenerCollection.getKeyboardModifiers(event));
                return allow && (eventTargetsPopup || !this.modal);
            }
            case 256: {
                boolean allow = this.onKeyPressPreview((char)DOM.eventGetKeyCode(event), KeyboardListenerCollection.getKeyboardModifiers(event));
                return allow && (eventTargetsPopup || !this.modal);
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 64: {
                if (DOM.getCaptureElement() != null) {
                    return true;
                }
                if (eventTargetsPopup || !this.autoHide || type != 4) break;
                this.hide(true);
                return true;
            }
            case 2048: {
                if (!this.modal || eventTargetsPopup || target == null) break;
                this.blur(target);
                return false;
            }
        }
        return !this.modal || eventTargetsPopup;
    }

    public boolean onKeyDownPreview(char key, int modifiers) {
        return true;
    }

    public boolean onKeyPressPreview(char key, int modifiers) {
        return true;
    }

    public boolean onKeyUpPreview(char key, int modifiers) {
        return true;
    }

    public void removePopupListener(PopupListener listener) {
        if (this.popupListeners != null) {
            this.popupListeners.remove(listener);
        }
    }

    public void setHeight(String height) {
        this.desiredHeight = height;
        this.maybeUpdateSize();
        if (height.length() == 0) {
            this.desiredHeight = null;
        }
    }

    public void setPopupPosition(int left, int top) {
        if (left < 0) {
            left = 0;
        }
        if (top < 0) {
            top = 0;
        }
        this.leftPosition = left;
        this.topPosition = top;
        Element elem = this.getElement();
        DOM.setStyleAttribute(elem, "left", left + "px");
        DOM.setStyleAttribute(elem, "top", top + "px");
    }

    public void setPopupPositionAndShow(PositionCallback callback) {
        this.setVisible(false);
        this.show();
        callback.setPosition(this.getOffsetWidth(), this.getOffsetHeight());
        this.setVisible(true);
    }

    public void setTitle(String title) {
        Element containerElement = this.getContainerElement();
        if (title == null || title.length() == 0) {
            DOM.removeElementAttribute(containerElement, "title");
        } else {
            DOM.setElementAttribute(containerElement, "title", title);
        }
    }

    public void setVisible(boolean visible) {
        DOM.setStyleAttribute(this.getElement(), "visibility", visible ? "visible" : "hidden");
        impl.setVisible(this.getElement(), visible);
    }

    public void setWidget(Widget w) {
        super.setWidget(w);
        this.maybeUpdateSize();
    }

    public void setWidth(String width) {
        this.desiredWidth = width;
        this.maybeUpdateSize();
        if (width.length() == 0) {
            this.desiredWidth = null;
        }
    }

    public void show() {
        if (this.showing) {
            return;
        }
        this.showing = true;
        DOM.addEventPreview(this);
        DOM.setStyleAttribute(this.getElement(), "position", "absolute");
        if (this.topPosition != -1) {
            this.setPopupPosition(this.leftPosition, this.topPosition);
        }
        RootPanel.get().add(this);
        impl.onShow(this.getElement());
    }

    protected Element getContainerElement() {
        return impl.getContainerElement(this.getElement());
    }

    protected Element getStyleElement() {
        return impl.getContainerElement(this.getElement());
    }

    protected void onDetach() {
        DOM.removeEventPreview(this);
        super.onDetach();
    }

    private native void blur(Element var1);

    private void hide(boolean autoClosed) {
        if (!this.showing) {
            return;
        }
        this.showing = false;
        RootPanel.get().remove(this);
        impl.onHide(this.getElement());
        if (this.popupListeners != null) {
            this.popupListeners.firePopupClosed(this, autoClosed);
        }
    }

    private void maybeUpdateSize() {
        Widget w = this.getWidget();
        if (w != null) {
            if (this.desiredHeight != null) {
                w.setHeight(this.desiredHeight);
            }
            if (this.desiredWidth != null) {
                w.setWidth(this.desiredWidth);
            }
        }
    }

    public static interface PositionCallback {
        public void setPosition(int var1, int var2);
    }
}

