/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc;

import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyLoader;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RemoteServiceServlet
extends HttpServlet
implements SerializationPolicyProvider {
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String CHARSET_UTF8 = "UTF-8";
    private static final String CONTENT_ENCODING = "Content-Encoding";
    private static final String CONTENT_ENCODING_GZIP = "gzip";
    private static final String CONTENT_TYPE_TEXT_PLAIN_UTF8 = "text/plain; charset=utf-8";
    private static final String GENERIC_FAILURE_MSG = "The call failed on the server; see server log for details";
    private static final int UNCOMPRESSED_BYTE_SIZE_LIMIT = 256;
    private final ThreadLocal perThreadRequest = new ThreadLocal();
    private final ThreadLocal perThreadResponse = new ThreadLocal();
    private final Map serializationPolicyCache = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    private static boolean acceptsGzipEncoding(HttpServletRequest request) {
        if (!$assertionsDisabled && request == null) {
            throw new AssertionError();
        }
        String acceptEncoding = request.getHeader(ACCEPT_ENCODING);
        if (null == acceptEncoding) {
            return false;
        }
        return acceptEncoding.indexOf(CONTENT_ENCODING_GZIP) != -1;
    }

    private static int estimateByteSize(String buffer) {
        return buffer.length() * 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readPayloadAsUtf8(HttpServletRequest request) throws IOException, ServletException {
        int contentLength = request.getContentLength();
        if (contentLength == -1) {
            throw new ServletException("Content-Length must be specified");
        }
        String contentType = request.getContentType();
        boolean contentTypeIsOkay = false;
        if (contentType != null && contentType.startsWith("text/plain")) {
            if (contentType.indexOf("charset=") == -1) {
                contentTypeIsOkay = true;
            } else if (contentType.indexOf("charset=utf-8") != -1) {
                contentTypeIsOkay = true;
            }
        }
        if (!contentTypeIsOkay) {
            throw new ServletException("Content-Type must be 'text/plain' with 'charset=utf-8' (or unspecified charset)");
        }
        ServletInputStream in = request.getInputStream();
        try {
            byte[] payload = new byte[contentLength];
            int offset = 0;
            int len = contentLength;
            while (offset < contentLength) {
                int byteCount = in.read(payload, offset, len);
                if (byteCount == -1) {
                    throw new ServletException("Client did not send " + contentLength + " bytes as expected");
                }
                offset += byteCount;
                len -= byteCount;
            }
            String string = new String(payload, CHARSET_UTF8);
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.perThreadRequest.set(request);
            this.perThreadResponse.set(response);
            String requestPayload = RemoteServiceServlet.readPayloadAsUtf8(request);
            this.onBeforeRequestDeserialized(requestPayload);
            String responsePayload = this.processCall(requestPayload);
            this.onAfterResponseSerialized(responsePayload);
            this.writeResponse(request, response, responsePayload);
            return;
        }
        catch (Throwable e) {
            this.doUnexpectedFailure(e);
        }
        finally {
            this.perThreadRequest.set(null);
            this.perThreadResponse.set(null);
        }
    }

    public final SerializationPolicy getSerializationPolicy(String moduleBaseURL, String strongName) {
        SerializationPolicy serializationPolicy = this.getCachedSerializationPolicy(moduleBaseURL, strongName);
        if (serializationPolicy != null) {
            return serializationPolicy;
        }
        serializationPolicy = this.doGetSerializationPolicy(this.getThreadLocalRequest(), moduleBaseURL, strongName);
        if (serializationPolicy == null) {
            this.getServletContext().log("WARNING: Failed to get the SerializationPolicy '" + strongName + "' for module '" + moduleBaseURL + "'; a legacy, 1.3.3 compatible, serialization policy will be used.  You may experience SerializationExceptions as a result.");
            serializationPolicy = RPC.getDefaultSerializationPolicy();
        }
        this.putCachedSerializationPolicy(moduleBaseURL, strongName, serializationPolicy);
        return serializationPolicy;
    }

    public String processCall(String payload) throws SerializationException {
        try {
            RPCRequest rpcRequest = RPC.decodeRequest(payload, this.getClass(), this);
            return RPC.invokeAndEncodeResponse(this, rpcRequest.getMethod(), rpcRequest.getParameters(), rpcRequest.getSerializationPolicy());
        }
        catch (IncompatibleRemoteServiceException ex) {
            this.getServletContext().log("An IncompatibleRemoteServiceException was thrown while processing this call.", (Throwable)ex);
            return RPC.encodeResponseForFailure(null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SerializationPolicy doGetSerializationPolicy(HttpServletRequest request, String moduleBaseURL, String strongName) {
        String contextPath = request.getContextPath();
        String modulePath = null;
        if (moduleBaseURL != null) {
            try {
                modulePath = new URL(moduleBaseURL).getPath();
            }
            catch (MalformedURLException ex) {
                this.getServletContext().log("Malformed moduleBaseURL: " + moduleBaseURL, (Throwable)ex);
            }
        }
        SerializationPolicy serializationPolicy = null;
        if (modulePath == null || !modulePath.startsWith(contextPath)) {
            String message = "ERROR: The module path requested, " + modulePath + ", is not in the same web application as this servlet, " + contextPath + ".  Your module may not be properly configured or your client and server code maybe out of date.";
            this.getServletContext().log(message);
        } else {
            String contextRelativePath = modulePath.substring(contextPath.length());
            String serializationPolicyFilePath = SerializationPolicyLoader.getSerializationPolicyFileName(contextRelativePath + strongName);
            InputStream is = this.getServletContext().getResourceAsStream(serializationPolicyFilePath);
            try {
                if (is != null) {
                    try {
                        serializationPolicy = SerializationPolicyLoader.loadFromStream(is);
                    }
                    catch (ParseException e) {
                        this.getServletContext().log("ERROR: Failed to parse the policy file '" + serializationPolicyFilePath + "'", (Throwable)e);
                    }
                    catch (ClassNotFoundException e) {
                        this.getServletContext().log("ERROR: Could not find class '" + e.getMessage() + "' listed in the serialization policy file '" + serializationPolicyFilePath + "'" + "; your server's classpath may be misconfigured", (Throwable)e);
                    }
                    catch (IOException e) {
                        this.getServletContext().log("ERROR: Could not read the policy file '" + serializationPolicyFilePath + "'", (Throwable)e);
                    }
                } else {
                    String message = "ERROR: The serialization policy file '" + serializationPolicyFilePath + "' was not found; did you forget to include it in this deployment?";
                    this.getServletContext().log(message);
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return serializationPolicy;
    }

    protected void doUnexpectedFailure(Throwable e) {
        ServletContext servletContext = this.getServletContext();
        servletContext.log("Exception while dispatching incoming RPC call", e);
        this.respondWithFailure(this.getThreadLocalResponse());
    }

    protected final HttpServletRequest getThreadLocalRequest() {
        return (HttpServletRequest)this.perThreadRequest.get();
    }

    protected final HttpServletResponse getThreadLocalResponse() {
        return (HttpServletResponse)this.perThreadResponse.get();
    }

    protected void onAfterResponseSerialized(String serializedResponse) {
    }

    protected void onBeforeRequestDeserialized(String serializedRequest) {
    }

    protected boolean shouldCompressResponse(HttpServletRequest request, HttpServletResponse response, String responsePayload) {
        return RemoteServiceServlet.estimateByteSize(responsePayload) > 256;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SerializationPolicy getCachedSerializationPolicy(String moduleBaseURL, String strongName) {
        Map map = this.serializationPolicyCache;
        synchronized (map) {
            return (SerializationPolicy)this.serializationPolicyCache.get(moduleBaseURL + strongName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putCachedSerializationPolicy(String moduleBaseURL, String strongName, SerializationPolicy serializationPolicy) {
        Map map = this.serializationPolicyCache;
        synchronized (map) {
            this.serializationPolicyCache.put(moduleBaseURL + strongName, serializationPolicy);
        }
    }

    private void respondWithFailure(HttpServletResponse response) {
        try {
            response.setContentType("text/plain");
            response.setStatus(500);
            response.getWriter().write(GENERIC_FAILURE_MSG);
        }
        catch (IOException e) {
            this.getServletContext().log("respondWithFailure failed while sending the previous failure to the client", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponse(HttpServletRequest request, HttpServletResponse response, String responsePayload) throws IOException {
        byte[] reply = responsePayload.getBytes(CHARSET_UTF8);
        String contentType = CONTENT_TYPE_TEXT_PLAIN_UTF8;
        if (RemoteServiceServlet.acceptsGzipEncoding(request) && this.shouldCompressResponse(request, response, responsePayload)) {
            ByteArrayOutputStream output = null;
            DeflaterOutputStream gzipOutputStream = null;
            IOException caught = null;
            try {
                output = new ByteArrayOutputStream(reply.length);
                gzipOutputStream = new GZIPOutputStream(output);
                gzipOutputStream.write(reply);
                ((GZIPOutputStream)gzipOutputStream).finish();
                gzipOutputStream.flush();
                response.setHeader(CONTENT_ENCODING, CONTENT_ENCODING_GZIP);
                reply = output.toByteArray();
            }
            catch (IOException e) {
                caught = e;
            }
            finally {
                if (null != gzipOutputStream) {
                    gzipOutputStream.close();
                }
                if (null != output) {
                    output.close();
                }
            }
            if (caught != null) {
                this.getServletContext().log("Unable to compress response", (Throwable)caught);
                response.sendError(500);
                return;
            }
        }
        response.setContentLength(reply.length);
        response.setContentType(contentType);
        response.setStatus(200);
        response.getOutputStream().write(reply);
    }

    static {
        $assertionsDisabled = !RemoteServiceServlet.class.desiredAssertionStatus();
    }
}

