/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.animation.client;

import com.google.gwt.core.client.Duration;
import com.google.gwt.user.client.Timer;
import java.util.ArrayList;
import java.util.List;

public abstract class Animation {
    private static final int DEFAULT_FRAME_DELAY = 25;
    private static List<Animation> animations = null;
    private static Timer animationTimer = null;
    private int duration = -1;
    private boolean started = false;
    private double startTime = -1.0;

    private static void updateAnimations() {
        double curTime = Duration.currentTimeMillis();
        for (int i = 0; i < animations.size(); ++i) {
            Animation animation = animations.get(i);
            if (!animation.update(curTime)) continue;
            animations.remove(i);
            --i;
        }
        if (animations.size() > 0) {
            animationTimer.schedule(25);
        }
    }

    public void cancel() {
        if (animations == null) {
            return;
        }
        if (animations.remove(this)) {
            this.onCancel();
        }
        this.started = false;
    }

    public void run(int duration) {
        this.run(duration, Duration.currentTimeMillis());
    }

    public void run(int duration, double startTime) {
        this.cancel();
        this.duration = duration;
        this.startTime = startTime;
        if (this.update(Duration.currentTimeMillis())) {
            return;
        }
        if (animations == null) {
            animations = new ArrayList<Animation>();
            animationTimer = new Timer(){

                public void run() {
                    Animation.updateAnimations();
                }
            };
        }
        animations.add(this);
        if (animations.size() == 1) {
            animationTimer.schedule(25);
        }
    }

    protected double interpolate(double progress) {
        return (1.0 + Math.cos(Math.PI + progress * Math.PI)) / 2.0;
    }

    protected void onCancel() {
        if (this.started) {
            this.started = false;
            this.onComplete();
        }
    }

    protected void onComplete() {
        this.onUpdate(this.interpolate(1.0));
    }

    protected void onStart() {
        this.onUpdate(this.interpolate(0.0));
    }

    protected abstract void onUpdate(double var1);

    private boolean update(double curTime) {
        boolean finished;
        boolean bl = finished = curTime >= this.startTime + (double)this.duration;
        if (this.started && !finished) {
            double progress = (curTime - this.startTime) / (double)this.duration;
            this.onUpdate(this.interpolate(progress));
            return false;
        }
        if (!this.started && curTime >= this.startTime) {
            this.started = true;
            this.onStart();
        }
        if (finished) {
            this.started = false;
            this.onComplete();
            return true;
        }
        return false;
    }
}

