/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.benchmarks;

import com.google.gwt.benchmarks.BenchmarkReport;
import com.google.gwt.benchmarks.client.impl.BenchmarkResults;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.junit.JUnitShell;
import com.google.gwt.junit.client.impl.JUnitResult;
import java.io.File;
import java.util.Date;
import junit.framework.TestCase;
import junit.framework.TestResult;

public class BenchmarkShell {
    private static BenchmarkReport report = new BenchmarkReport();
    private static boolean shutdownHookSet = false;

    public static BenchmarkReport getReport() {
        return report;
    }

    public static void runTest(String moduleName, TestCase testCase, TestResult testResult) throws UnableToCompleteException {
        if (!shutdownHookSet) {
            shutdownHookSet = true;
            Runtime.getRuntime().addShutdownHook(new Thread(new Shutdown()));
        }
        JUnitShell.runTest((String)moduleName, (TestCase)testCase, (TestResult)testResult, (JUnitShell.Strategy)new BenchmarkStrategy());
    }

    private BenchmarkShell() {
    }

    private static class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        public void run() {
            try {
                String reportPath = System.getProperty("com.google.gwt.junit.reportPath");
                if (reportPath == null || reportPath.trim().equals("")) {
                    reportPath = System.getProperty("user.dir");
                }
                report.generate(reportPath + File.separator + "report-" + new Date().getTime() + ".xml");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class BenchmarkStrategy
    implements JUnitShell.Strategy {
        private BenchmarkStrategy() {
        }

        public String getModuleInherit() {
            return "com.google.gwt.benchmarks.Benchmarks";
        }

        public String getSyntheticModuleExtension() {
            return "Benchmarks";
        }

        public void processResult(TestCase testCase, JUnitResult result) {
            report.addBenchmarkResults(testCase, (BenchmarkResults)result);
        }
    }
}

