/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.rpc.impl;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.impl.AbstractSerializationStreamWriter;
import com.google.gwt.user.client.rpc.impl.Serializer;
import java.util.List;

public final class ClientSerializationStreamWriter
extends AbstractSerializationStreamWriter {
    private StringBuffer encodeBuffer;
    private final String moduleBaseURL;
    private final String serializationPolicyStrongName;
    private final Serializer serializer;

    private static void append(StringBuffer sb, String token) {
        assert (token != null);
        sb.append(token);
        sb.append('\uffff');
    }

    public ClientSerializationStreamWriter(Serializer serializer) {
        this.serializer = serializer;
        this.moduleBaseURL = null;
        this.serializationPolicyStrongName = null;
        this.setVersion(2);
    }

    public ClientSerializationStreamWriter(Serializer serializer, String moduleBaseURL, String serializationPolicyStrongName) {
        this.serializer = serializer;
        this.moduleBaseURL = moduleBaseURL;
        this.serializationPolicyStrongName = serializationPolicyStrongName;
    }

    public void prepareToWrite() {
        super.prepareToWrite();
        this.encodeBuffer = new StringBuffer();
        if (this.hasSerializationPolicyInfo()) {
            this.writeString(this.moduleBaseURL);
            this.writeString(this.serializationPolicyStrongName);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.writeHeader(buffer);
        this.writeStringTable(buffer);
        this.writePayload(buffer);
        return buffer.toString();
    }

    public void writeLong(long fieldValue) {
        this.append(Long.toString(fieldValue, 16));
    }

    protected void append(String token) {
        ClientSerializationStreamWriter.append(this.encodeBuffer, token);
    }

    protected String getObjectTypeSignature(Object o) {
        String typeName;
        String serializationSignature;
        Class<Object> clazz = o.getClass();
        if (o instanceof Enum) {
            Enum e = (Enum)o;
            clazz = e.getDeclaringClass();
        }
        if ((serializationSignature = this.serializer.getSerializationSignature(typeName = clazz.getName())) != null) {
            typeName = typeName + "/" + serializationSignature;
        }
        return typeName;
    }

    protected void serialize(Object instance, String typeSignature) throws SerializationException {
        this.serializer.serialize(this, instance, typeSignature);
    }

    private void writeHeader(StringBuffer buffer) {
        ClientSerializationStreamWriter.append(buffer, String.valueOf(this.getVersion()));
        ClientSerializationStreamWriter.append(buffer, String.valueOf(this.getFlags()));
    }

    private void writePayload(StringBuffer buffer) {
        buffer.append(this.encodeBuffer.toString());
    }

    private StringBuffer writeStringTable(StringBuffer buffer) {
        List<String> stringTable = this.getStringTable();
        ClientSerializationStreamWriter.append(buffer, String.valueOf(stringTable.size()));
        for (String s : stringTable) {
            ClientSerializationStreamWriter.append(buffer, s);
        }
        return buffer;
    }
}

