/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.FiresFormEvents;
import com.google.gwt.user.client.ui.FormHandler;
import com.google.gwt.user.client.ui.FormHandlerCollection;
import com.google.gwt.user.client.ui.NamedFrame;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.impl.FormPanelImpl;
import com.google.gwt.user.client.ui.impl.FormPanelImplHost;

public class FormPanel
extends SimplePanel
implements FiresFormEvents,
FormPanelImplHost {
    public static final String ENCODING_MULTIPART = "multipart/form-data";
    public static final String ENCODING_URLENCODED = "application/x-www-form-urlencoded";
    public static final String METHOD_GET = "get";
    public static final String METHOD_POST = "post";
    private static int formId = 0;
    private static FormPanelImpl impl = (FormPanelImpl)GWT.create(FormPanelImpl.class);
    private FormHandlerCollection formHandlers;
    private String frameName;
    private Element iframe;

    public FormPanel() {
        super(DOM.createForm());
        this.frameName = "FormPanel_" + ++formId;
        this.setTarget(this.frameName);
        this.sinkEvents(32768);
    }

    public FormPanel(NamedFrame frameTarget) {
        this(frameTarget.getName());
    }

    public FormPanel(String target) {
        super(DOM.createForm());
        this.setTarget(target);
    }

    public void addFormHandler(FormHandler handler) {
        if (this.formHandlers == null) {
            this.formHandlers = new FormHandlerCollection();
        }
        this.formHandlers.add(handler);
    }

    public String getAction() {
        return DOM.getElementProperty(this.getElement(), "action");
    }

    public String getEncoding() {
        return impl.getEncoding(this.getElement());
    }

    public String getMethod() {
        return DOM.getElementProperty(this.getElement(), "method");
    }

    public String getTarget() {
        return DOM.getElementProperty(this.getElement(), "target");
    }

    public boolean onFormSubmit() {
        GWT.UncaughtExceptionHandler handler = GWT.getUncaughtExceptionHandler();
        if (handler != null) {
            return this.onFormSubmitAndCatch(handler);
        }
        return this.onFormSubmitImpl();
    }

    public void onFrameLoad() {
        GWT.UncaughtExceptionHandler handler = GWT.getUncaughtExceptionHandler();
        if (handler != null) {
            this.onFrameLoadAndCatch(handler);
        } else {
            this.onFrameLoadImpl();
        }
    }

    public void removeFormHandler(FormHandler handler) {
        if (this.formHandlers != null) {
            this.formHandlers.remove(handler);
        }
    }

    public void setAction(String url) {
        DOM.setElementProperty(this.getElement(), "action", url);
    }

    public void setEncoding(String encodingType) {
        impl.setEncoding(this.getElement(), encodingType);
    }

    public void setMethod(String method) {
        DOM.setElementProperty(this.getElement(), "method", method);
    }

    public void submit() {
        if (this.formHandlers != null && this.formHandlers.fireOnSubmit(this)) {
            return;
        }
        impl.submit(this.getElement(), this.iframe);
    }

    protected void onAttach() {
        super.onAttach();
        this.createFrame();
        DOM.appendChild(RootPanel.getBodyElement(), this.iframe);
        impl.hookEvents(this.iframe, this.getElement(), this);
    }

    protected void onDetach() {
        super.onDetach();
        impl.unhookEvents(this.iframe, this.getElement());
        DOM.removeChild(RootPanel.getBodyElement(), this.iframe);
        this.iframe = null;
    }

    private void createFrame() {
        Element dummy = DOM.createDiv();
        DOM.setInnerHTML(dummy, "<iframe src=\"javascript:''\" name='" + this.frameName + "' style='position:absolute;width:0;height:0;border:0'>");
        this.iframe = DOM.getFirstChild(dummy);
    }

    private boolean onFormSubmitAndCatch(GWT.UncaughtExceptionHandler handler) {
        try {
            return this.onFormSubmitImpl();
        }
        catch (Throwable e) {
            handler.onUncaughtException(e);
            return false;
        }
    }

    private boolean onFormSubmitImpl() {
        if (this.formHandlers != null) {
            return !this.formHandlers.fireOnSubmit(this);
        }
        return true;
    }

    private void onFrameLoadAndCatch(GWT.UncaughtExceptionHandler handler) {
        try {
            this.onFrameLoadImpl();
        }
        catch (Throwable e) {
            handler.onUncaughtException(e);
        }
    }

    private void onFrameLoadImpl() {
        if (this.formHandlers != null) {
            DeferredCommand.addCommand(new Command(){

                public void execute() {
                    FormPanel.this.formHandlers.fireOnComplete(this, impl.getContents(FormPanel.this.iframe));
                }
            });
        }
    }

    private void setTarget(String target) {
        DOM.setElementProperty(this.getElement(), "target", target);
    }
}

