/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.ClickListenerCollection;
import com.google.gwt.user.client.ui.LoadListener;
import com.google.gwt.user.client.ui.LoadListenerCollection;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.MouseListenerCollection;
import com.google.gwt.user.client.ui.MouseWheelListener;
import com.google.gwt.user.client.ui.MouseWheelListenerCollection;
import com.google.gwt.user.client.ui.SourcesClickEvents;
import com.google.gwt.user.client.ui.SourcesLoadEvents;
import com.google.gwt.user.client.ui.SourcesMouseEvents;
import com.google.gwt.user.client.ui.SourcesMouseWheelEvents;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.impl.ClippedImageImpl;
import java.util.HashMap;

public class Image
extends Widget
implements SourcesClickEvents,
SourcesLoadEvents,
SourcesMouseEvents,
SourcesMouseWheelEvents {
    private static HashMap<String, Element> prefetchImages = new HashMap();
    private ClickListenerCollection clickListeners;
    private LoadListenerCollection loadListeners;
    private MouseListenerCollection mouseListeners;
    private MouseWheelListenerCollection mouseWheelListeners;
    private State state;

    public static void prefetch(String url) {
        Element img = DOM.createImg();
        DOM.setImgSrc(img, url);
        prefetchImages.put(url, img);
    }

    public Image() {
        this.changeState(new UnclippedState(this));
        this.setStyleName("gwt-Image");
    }

    public Image(String url) {
        this.changeState(new UnclippedState(this, url));
        this.setStyleName("gwt-Image");
    }

    public Image(String url, int left, int top, int width, int height) {
        this.changeState(new ClippedState(this, url, left, top, width, height));
        this.setStyleName("gwt-Image");
    }

    public void addClickListener(ClickListener listener) {
        if (this.clickListeners == null) {
            this.clickListeners = new ClickListenerCollection();
        }
        this.clickListeners.add(listener);
    }

    public void addLoadListener(LoadListener listener) {
        if (this.loadListeners == null) {
            this.loadListeners = new LoadListenerCollection();
        }
        this.loadListeners.add(listener);
    }

    public void addMouseListener(MouseListener listener) {
        if (this.mouseListeners == null) {
            this.mouseListeners = new MouseListenerCollection();
        }
        this.mouseListeners.add(listener);
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        if (this.mouseWheelListeners == null) {
            this.mouseWheelListeners = new MouseWheelListenerCollection();
        }
        this.mouseWheelListeners.add(listener);
    }

    public int getHeight() {
        return this.state.getHeight(this);
    }

    public int getOriginLeft() {
        return this.state.getOriginLeft();
    }

    public int getOriginTop() {
        return this.state.getOriginTop();
    }

    public String getUrl() {
        return this.state.getUrl(this);
    }

    public int getWidth() {
        return this.state.getWidth(this);
    }

    public void onBrowserEvent(Event event) {
        switch (DOM.eventGetType(event)) {
            case 1: {
                if (this.clickListeners == null) break;
                this.clickListeners.fireClick(this);
                break;
            }
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: {
                if (this.mouseListeners == null) break;
                this.mouseListeners.fireMouseEvent(this, event);
                break;
            }
            case 131072: {
                if (this.mouseWheelListeners == null) break;
                this.mouseWheelListeners.fireMouseWheelEvent(this, event);
                break;
            }
            case 32768: {
                if (this.loadListeners == null) break;
                this.loadListeners.fireLoad(this);
                break;
            }
            case 65536: {
                if (this.loadListeners == null) break;
                this.loadListeners.fireError(this);
            }
        }
    }

    public void removeClickListener(ClickListener listener) {
        if (this.clickListeners != null) {
            this.clickListeners.remove(listener);
        }
    }

    public void removeLoadListener(LoadListener listener) {
        if (this.loadListeners != null) {
            this.loadListeners.remove(listener);
        }
    }

    public void removeMouseListener(MouseListener listener) {
        if (this.mouseListeners != null) {
            this.mouseListeners.remove(listener);
        }
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
        if (this.mouseWheelListeners != null) {
            this.mouseWheelListeners.remove(listener);
        }
    }

    public void setUrl(String url) {
        this.state.setUrl(this, url);
    }

    public void setUrlAndVisibleRect(String url, int left, int top, int width, int height) {
        this.state.setUrlAndVisibleRect(this, url, left, top, width, height);
    }

    public void setVisibleRect(int left, int top, int width, int height) {
        this.state.setVisibleRect(this, left, top, width, height);
    }

    private void changeState(State newState) {
        this.state = newState;
    }

    private static class UnclippedState
    extends State {
        UnclippedState(Image image) {
            image.replaceElement(DOM.createImg());
            image.sinkEvents(229501);
        }

        UnclippedState(Image image, String url) {
            this(image);
            this.setUrl(image, url);
        }

        public int getHeight(Image image) {
            return DOM.getElementPropertyInt(image.getElement(), "height");
        }

        public int getOriginLeft() {
            return 0;
        }

        public int getOriginTop() {
            return 0;
        }

        public String getUrl(Image image) {
            return DOM.getImgSrc(image.getElement());
        }

        public int getWidth(Image image) {
            return DOM.getElementPropertyInt(image.getElement(), "width");
        }

        public void setUrl(Image image, String url) {
            DOM.setImgSrc(image.getElement(), url);
        }

        public void setUrlAndVisibleRect(Image image, String url, int left, int top, int width, int height) {
            image.changeState(new ClippedState(image, url, left, top, width, height));
        }

        public void setVisibleRect(Image image, int left, int top, int width, int height) {
            image.changeState(new ClippedState(image, this.getUrl(image), left, top, width, height));
        }

        protected String getStateName() {
            return "unclipped";
        }
    }

    private static abstract class State {
        private State() {
        }

        public abstract int getHeight(Image var1);

        public abstract int getOriginLeft();

        public abstract int getOriginTop();

        public abstract String getUrl(Image var1);

        public abstract int getWidth(Image var1);

        public abstract void setUrl(Image var1, String var2);

        public abstract void setUrlAndVisibleRect(Image var1, String var2, int var3, int var4, int var5, int var6);

        public abstract void setVisibleRect(Image var1, int var2, int var3, int var4, int var5);

        protected abstract String getStateName();
    }

    private static class ClippedState
    extends State {
        private static final ClippedImageImpl impl = (ClippedImageImpl)GWT.create(ClippedImageImpl.class);
        private int height = 0;
        private int left = 0;
        private int top = 0;
        private String url = null;
        private int width = 0;

        ClippedState(Image image, String url, int left, int top, int width, int height) {
            this.left = left;
            this.top = top;
            this.width = width;
            this.height = height;
            this.url = url;
            image.replaceElement(impl.createStructure(url, left, top, width, height));
            image.sinkEvents(131197);
            this.fireSyntheticLoadEvent(image);
        }

        public int getHeight(Image image) {
            return this.height;
        }

        public int getOriginLeft() {
            return this.left;
        }

        public int getOriginTop() {
            return this.top;
        }

        public String getUrl(Image image) {
            return this.url;
        }

        public int getWidth(Image image) {
            return this.width;
        }

        public void setUrl(Image image, String url) {
            image.changeState(new UnclippedState(image, url));
        }

        public void setUrlAndVisibleRect(Image image, String url, int left, int top, int width, int height) {
            if (!this.url.equals(url) || this.left != left || this.top != top || this.width != width || this.height != height) {
                this.url = url;
                this.left = left;
                this.top = top;
                this.width = width;
                this.height = height;
                impl.adjust(image.getElement(), url, left, top, width, height);
                this.fireSyntheticLoadEvent(image);
            }
        }

        public void setVisibleRect(Image image, int left, int top, int width, int height) {
            if (this.left != left || this.top != top || this.width != width || this.height != height) {
                this.left = left;
                this.top = top;
                this.width = width;
                this.height = height;
                impl.adjust(image.getElement(), this.url, left, top, width, height);
                this.fireSyntheticLoadEvent(image);
            }
        }

        protected String getStateName() {
            return "clipped";
        }

        private void fireSyntheticLoadEvent(final Image image) {
            DeferredCommand.addCommand(new Command(){

                public void execute() {
                    if (image.loadListeners != null) {
                        image.loadListeners.fireLoad(image);
                    }
                }
            });
        }
    }
}

