/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Accessibility;
import com.google.gwt.user.client.ui.FocusListener;
import com.google.gwt.user.client.ui.FocusListenerCollection;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HasAnimation;
import com.google.gwt.user.client.ui.HasFocus;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.KeyboardListenerCollection;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.MouseListenerCollection;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SourcesTreeEvents;
import com.google.gwt.user.client.ui.TreeImages;
import com.google.gwt.user.client.ui.TreeImagesRTL;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.TreeListener;
import com.google.gwt.user.client.ui.TreeListenerCollection;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.WidgetIterators;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tree
extends Widget
implements HasWidgets,
SourcesTreeEvents,
HasFocus,
HasAnimation {
    private static final int OTHER_KEY_UP = 63232;
    private static final int OTHER_KEY_DOWN = 63233;
    private static final int OTHER_KEY_LEFT = 63234;
    private static final int OTHER_KEY_RIGHT = 63235;
    private final Map<Widget, TreeItem> childWidgets = new HashMap<Widget, TreeItem>();
    private TreeItem curSelection;
    private Element focusable;
    private FocusListenerCollection focusListeners;
    private TreeImages images;
    private boolean isAnimationEnabled = false;
    private KeyboardListenerCollection keyboardListeners;
    private TreeListenerCollection listeners;
    private MouseListenerCollection mouseListeners = null;
    private TreeItem root;
    private boolean lastWasKeyDown;
    private Image leafImage;
    private Image openImage;
    private Image closedImage;
    private String indentValue;

    static native boolean shouldTreeDelegateFocusToElement(Element var0);

    private static boolean isArrowKey(int code) {
        switch (code) {
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 63232: 
            case 63233: 
            case 63234: 
            case 63235: {
                return true;
            }
        }
        return false;
    }

    private static int standardizeKeycode(int code) {
        switch (code) {
            case 63233: {
                code = 40;
                break;
            }
            case 63235: {
                code = 39;
                break;
            }
            case 63232: {
                code = 38;
                break;
            }
            case 63234: {
                code = 37;
            }
        }
        if (LocaleInfo.getCurrentLocale().isRTL()) {
            if (code == 39) {
                code = 37;
            } else if (code == 37) {
                code = 39;
            }
        }
        return code;
    }

    public Tree() {
        if (LocaleInfo.getCurrentLocale().isRTL()) {
            this.init((TreeImages)GWT.create(TreeImagesRTL.class), false);
        } else {
            this.init((TreeImages)GWT.create(TreeImages.class), false);
        }
    }

    public Tree(TreeImages images) {
        this.init(images, true);
    }

    public Tree(TreeImages images, boolean useLeafImages) {
        this.init(images, useLeafImages);
    }

    @Override
    public void add(Widget widget) {
        this.addItem(widget);
    }

    @Override
    public void addFocusListener(FocusListener listener) {
        if (this.focusListeners == null) {
            this.focusListeners = new FocusListenerCollection();
        }
        this.focusListeners.add(listener);
    }

    public TreeItem addItem(String itemText) {
        TreeItem ret = new TreeItem(itemText);
        this.addItem(ret);
        return ret;
    }

    public void addItem(TreeItem item) {
        this.root.addItem(item);
    }

    public TreeItem addItem(Widget widget) {
        return this.root.addItem(widget);
    }

    @Override
    public void addKeyboardListener(KeyboardListener listener) {
        if (this.keyboardListeners == null) {
            this.keyboardListeners = new KeyboardListenerCollection();
        }
        this.keyboardListeners.add(listener);
    }

    public void addMouseListener(MouseListener listener) {
        if (this.mouseListeners == null) {
            this.mouseListeners = new MouseListenerCollection();
        }
        this.mouseListeners.add(listener);
    }

    @Override
    public void addTreeListener(TreeListener listener) {
        if (this.listeners == null) {
            this.listeners = new TreeListenerCollection();
        }
        this.listeners.add(listener);
    }

    @Override
    public void clear() {
        int size = this.root.getChildCount();
        for (int i = size - 1; i >= 0; --i) {
            this.root.getChild(i).remove();
        }
    }

    public void ensureSelectedItemVisible() {
        if (this.curSelection == null) {
            return;
        }
        for (TreeItem parent = this.curSelection.getParentItem(); parent != null; parent = parent.getParentItem()) {
            parent.setState(true);
        }
    }

    @Deprecated
    public String getImageBase() {
        return this.images instanceof ImagesFromImageBase ? ((ImagesFromImageBase)this.images).getBaseUrl() : GWT.getModuleBaseURL();
    }

    public TreeItem getItem(int index) {
        return this.root.getChild(index);
    }

    public int getItemCount() {
        return this.root.getChildCount();
    }

    public TreeItem getSelectedItem() {
        return this.curSelection;
    }

    @Override
    public int getTabIndex() {
        return FocusPanel.impl.getTabIndex(this.focusable);
    }

    @Override
    public boolean isAnimationEnabled() {
        return this.isAnimationEnabled;
    }

    @Override
    public Iterator<Widget> iterator() {
        Widget[] widgets = new Widget[this.childWidgets.size()];
        this.childWidgets.keySet().toArray(widgets);
        return WidgetIterators.createWidgetIterator(this, widgets);
    }

    @Override
    public void onBrowserEvent(Event event) {
        int eventType = DOM.eventGetType(event);
        switch (eventType) {
            case 128: {
                if (this.curSelection == null) {
                    if (this.root.getChildCount() > 0) {
                        this.onSelection(this.root.getChild(0), true, true);
                    }
                    super.onBrowserEvent(event);
                    return;
                }
            }
            case 256: 
            case 512: {
                if (!DOM.eventGetAltKey(event) && !DOM.eventGetMetaKey(event)) break;
                super.onBrowserEvent(event);
                return;
            }
        }
        switch (eventType) {
            case 1: {
                Element e = DOM.eventGetTarget(event);
                if (Tree.shouldTreeDelegateFocusToElement(e)) break;
                this.setFocus(true);
                break;
            }
            case 4: {
                if (this.mouseListeners != null) {
                    this.mouseListeners.fireMouseEvent(this, event);
                }
                if (DOM.eventGetCurrentTarget(event) != this.getElement()) break;
                this.elementClicked(DOM.eventGetTarget(event));
                break;
            }
            case 8: {
                if (this.mouseListeners == null) break;
                this.mouseListeners.fireMouseEvent(this, event);
                break;
            }
            case 64: {
                if (this.mouseListeners == null) break;
                this.mouseListeners.fireMouseEvent(this, event);
                break;
            }
            case 16: {
                if (this.mouseListeners == null) break;
                this.mouseListeners.fireMouseEvent(this, event);
                break;
            }
            case 32: {
                if (this.mouseListeners == null) break;
                this.mouseListeners.fireMouseEvent(this, event);
                break;
            }
            case 2048: {
                if (this.focusListeners == null) break;
                this.focusListeners.fireFocusEvent(this, event);
                break;
            }
            case 4096: {
                if (this.focusListeners == null) break;
                this.focusListeners.fireFocusEvent(this, event);
                break;
            }
            case 128: {
                this.keyboardNavigation(event);
                this.lastWasKeyDown = true;
                break;
            }
            case 256: {
                if (!this.lastWasKeyDown) {
                    this.keyboardNavigation(event);
                }
                this.lastWasKeyDown = false;
                break;
            }
            case 512: {
                if (DOM.eventGetKeyCode(event) == 9) {
                    ArrayList<Element> chain = new ArrayList<Element>();
                    this.collectElementChain(chain, this.getElement(), DOM.eventGetTarget(event));
                    TreeItem item = this.findItemByChain(chain, 0, this.root);
                    if (item != this.getSelectedItem()) {
                        this.setSelectedItem(item, true);
                    }
                }
                this.lastWasKeyDown = false;
            }
        }
        switch (eventType) {
            case 128: 
            case 256: 
            case 512: {
                if (this.keyboardListeners != null) {
                    this.keyboardListeners.fireKeyboardEvent(this, event);
                }
                if (!Tree.isArrowKey(DOM.eventGetKeyCode(event))) break;
                DOM.eventCancelBubble(event, true);
                DOM.eventPreventDefault(event);
            }
        }
        super.onBrowserEvent(event);
    }

    @Override
    public boolean remove(Widget w) {
        TreeItem item = this.childWidgets.get(w);
        if (item == null) {
            return false;
        }
        item.setWidget(null);
        return true;
    }

    @Override
    public void removeFocusListener(FocusListener listener) {
        if (this.focusListeners != null) {
            this.focusListeners.remove(listener);
        }
    }

    public void removeItem(TreeItem item) {
        this.root.removeItem(item);
    }

    public void removeItems() {
        while (this.getItemCount() > 0) {
            this.removeItem(this.getItem(0));
        }
    }

    @Override
    public void removeKeyboardListener(KeyboardListener listener) {
        if (this.keyboardListeners != null) {
            this.keyboardListeners.remove(listener);
        }
    }

    @Override
    public void removeTreeListener(TreeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void setAccessKey(char key) {
        FocusPanel.impl.setAccessKey(this.focusable, key);
    }

    @Override
    public void setAnimationEnabled(boolean enable) {
        this.isAnimationEnabled = enable;
    }

    @Override
    public void setFocus(boolean focus) {
        if (focus) {
            FocusPanel.impl.focus(this.focusable);
        } else {
            FocusPanel.impl.blur(this.focusable);
        }
    }

    @Deprecated
    public void setImageBase(String baseUrl) {
        this.images = new ImagesFromImageBase(baseUrl);
        this.root.updateStateRecursive();
    }

    public void setSelectedItem(TreeItem item) {
        this.setSelectedItem(item, true);
    }

    public void setSelectedItem(TreeItem item, boolean fireEvents) {
        if (item == null) {
            if (this.curSelection == null) {
                return;
            }
            this.curSelection.setSelected(false);
            this.curSelection = null;
            return;
        }
        this.onSelection(item, fireEvents, true);
    }

    @Override
    public void setTabIndex(int index) {
        FocusPanel.impl.setTabIndex(this.focusable, index);
    }

    public Iterator<TreeItem> treeItemIterator() {
        ArrayList<TreeItem> accum = new ArrayList<TreeItem>();
        this.root.addTreeItems(accum);
        return accum.iterator();
    }

    @Override
    protected void doAttachChildren() {
        for (Widget child : this) {
            child.onAttach();
        }
        DOM.setEventListener(this.focusable, this);
    }

    @Override
    protected void doDetachChildren() {
        for (Widget child : this) {
            child.onDetach();
        }
        DOM.setEventListener(this.focusable, null);
    }

    protected boolean isKeyboardNavigationEnabled(TreeItem currentItem) {
        return true;
    }

    @Override
    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        this.root.ensureDebugId(baseID + "-root");
    }

    @Override
    protected void onLoad() {
        this.root.updateStateRecursive();
    }

    void adopt(Widget widget, TreeItem treeItem) {
        assert (!this.childWidgets.containsKey(widget));
        this.childWidgets.put(widget, treeItem);
        widget.setParent(this);
    }

    void fireStateChanged(TreeItem item) {
        if (this.listeners != null) {
            this.listeners.fireItemStateChanged(item);
        }
    }

    Map<Widget, TreeItem> getChildWidgets() {
        return this.childWidgets;
    }

    TreeImages getImages() {
        return this.images;
    }

    void maybeUpdateSelection(TreeItem itemThatChangedState, boolean isItemOpening) {
        if (!isItemOpening) {
            for (TreeItem tempItem = this.curSelection; tempItem != null; tempItem = tempItem.getParentItem()) {
                if (tempItem != itemThatChangedState) continue;
                this.setSelectedItem(itemThatChangedState);
                return;
            }
        }
    }

    void orphan(Widget widget) {
        assert (widget.getParent() == this);
        widget.setParent(null);
        this.childWidgets.remove(widget);
    }

    void showClosedImage(TreeItem treeItem) {
        this.showImage(treeItem, this.closedImage);
    }

    void showLeafImage(TreeItem treeItem) {
        if (this.leafImage != null) {
            this.showImage(treeItem, this.leafImage);
        } else {
            DOM.setStyleAttribute(treeItem.getElement(), "paddingLeft", this.indentValue);
        }
    }

    void showOpenImage(TreeItem treeItem) {
        this.showImage(treeItem, this.openImage);
    }

    private void collectElementChain(ArrayList<Element> chain, Element hRoot, Element hElem) {
        if (hElem == null || hElem == hRoot) {
            return;
        }
        this.collectElementChain(chain, hRoot, DOM.getParent(hElem));
        chain.add(hElem);
    }

    private boolean elementClicked(Element hElem) {
        ArrayList<Element> chain = new ArrayList<Element>();
        this.collectElementChain(chain, this.getElement(), hElem);
        TreeItem item = this.findItemByChain(chain, 0, this.root);
        if (item != null) {
            if (item.getChildCount() > 0 && DOM.isOrHasChild(item.getImageElement(), hElem)) {
                item.setState(!item.getState(), true);
                return true;
            }
            if (DOM.isOrHasChild(item.getElement(), hElem)) {
                this.onSelection(item, true, !Tree.shouldTreeDelegateFocusToElement(hElem));
                return true;
            }
        }
        return false;
    }

    private TreeItem findDeepestOpenChild(TreeItem item) {
        if (!item.getState()) {
            return item;
        }
        return this.findDeepestOpenChild(item.getChild(item.getChildCount() - 1));
    }

    private TreeItem findItemByChain(ArrayList<Element> chain, int idx, TreeItem root) {
        if (idx == chain.size()) {
            return root;
        }
        Element hCurElem = chain.get(idx);
        int n = root.getChildCount();
        for (int i = 0; i < n; ++i) {
            TreeItem child = root.getChild(i);
            if (child.getElement() != hCurElem) continue;
            TreeItem retItem = this.findItemByChain(chain, idx + 1, root.getChild(i));
            if (retItem == null) {
                return child;
            }
            return retItem;
        }
        return this.findItemByChain(chain, idx + 1, root);
    }

    private TreeItem getTopClosedParent(TreeItem item) {
        TreeItem topClosedParent = null;
        for (TreeItem parent = item.getParentItem(); parent != null && parent != this.root; parent = parent.getParentItem()) {
            if (parent.getState()) continue;
            topClosedParent = parent;
        }
        return topClosedParent;
    }

    private void init(TreeImages images, boolean useLeafImages) {
        this.setImages(images, useLeafImages);
        this.setElement(DOM.createDiv());
        DOM.setStyleAttribute(this.getElement(), "position", "relative");
        DOM.setStyleAttribute(this.getElement(), "zoom", "1");
        this.focusable = FocusPanel.impl.createFocusable();
        DOM.setStyleAttribute(this.focusable, "fontSize", "0");
        DOM.setStyleAttribute(this.focusable, "position", "absolute");
        DOM.setStyleAttribute(this.focusable, "outline", "0px");
        DOM.setElementAttribute(this.focusable, "hideFocus", "true");
        DOM.setIntStyleAttribute(this.focusable, "zIndex", -1);
        DOM.appendChild(this.getElement(), this.focusable);
        this.sinkEvents(1021);
        DOM.sinkEvents(this.focusable, 6144);
        this.root = new TreeItem(){

            public void addItem(TreeItem item) {
                if (item.getParentItem() != null || item.getTree() != null) {
                    item.remove();
                }
                DOM.appendChild(Tree.this.getElement(), item.getElement());
                item.setTree(this.getTree());
                item.setParentItem(null);
                this.getChildren().add(item);
                if (LocaleInfo.getCurrentLocale().isRTL()) {
                    DOM.setIntStyleAttribute(item.getElement(), "marginRight", 0);
                } else {
                    DOM.setIntStyleAttribute(item.getElement(), "marginLeft", 0);
                }
            }

            public void removeItem(TreeItem item) {
                if (!this.getChildren().contains(item)) {
                    return;
                }
                item.setTree(null);
                item.setParentItem(null);
                this.getChildren().remove(item);
                DOM.removeChild(Tree.this.getElement(), item.getElement());
            }
        };
        this.root.initChildren();
        this.root.setTree(this);
        this.setStyleName("gwt-Tree");
        Accessibility.setRole(this.getElement(), "tree");
        Accessibility.setRole(this.focusable, "treeitem");
    }

    private void keyboardNavigation(Event event) {
        if (this.isKeyboardNavigationEnabled(this.curSelection)) {
            int code = DOM.eventGetKeyCode(event);
            switch (Tree.standardizeKeycode(code)) {
                case 38: {
                    this.moveSelectionUp(this.curSelection);
                    break;
                }
                case 40: {
                    this.moveSelectionDown(this.curSelection, true);
                    break;
                }
                case 37: {
                    this.maybeCollapseTreeItem();
                    break;
                }
                case 39: {
                    this.maybeExpandTreeItem();
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private void maybeCollapseTreeItem() {
        TreeItem topClosedParent = this.getTopClosedParent(this.curSelection);
        if (topClosedParent != null) {
            this.setSelectedItem(topClosedParent);
        } else if (this.curSelection.getState()) {
            this.curSelection.setState(false);
        } else {
            TreeItem parent = this.curSelection.getParentItem();
            if (parent != null) {
                this.setSelectedItem(parent);
            }
        }
    }

    private void maybeExpandTreeItem() {
        TreeItem topClosedParent = this.getTopClosedParent(this.curSelection);
        if (topClosedParent != null) {
            this.setSelectedItem(topClosedParent);
        } else if (!this.curSelection.getState()) {
            this.curSelection.setState(true);
        } else if (this.curSelection.getChildCount() > 0) {
            this.setSelectedItem(this.curSelection.getChild(0));
        }
    }

    private void moveFocus() {
        HasFocus focusableWidget = this.curSelection.getFocusableWidget();
        if (focusableWidget != null) {
            focusableWidget.setFocus(true);
            DOM.scrollIntoView(((Widget)((Object)focusableWidget)).getElement());
        } else {
            Element selectedElem = this.curSelection.getContentElem();
            int containerLeft = this.getAbsoluteLeft();
            int containerTop = this.getAbsoluteTop();
            int left = DOM.getAbsoluteLeft(selectedElem) - containerLeft;
            int top = DOM.getAbsoluteTop(selectedElem) - containerTop;
            int width = DOM.getElementPropertyInt(selectedElem, "offsetWidth");
            int height = DOM.getElementPropertyInt(selectedElem, "offsetHeight");
            if (width == 0 || height == 0) {
                DOM.setIntStyleAttribute(this.focusable, "left", 0);
                DOM.setIntStyleAttribute(this.focusable, "top", 0);
                return;
            }
            DOM.setStyleAttribute(this.focusable, "left", left + "px");
            DOM.setStyleAttribute(this.focusable, "top", top + "px");
            DOM.setStyleAttribute(this.focusable, "width", width + "px");
            DOM.setStyleAttribute(this.focusable, "height", height + "px");
            DOM.scrollIntoView(this.focusable);
            this.updateAriaAttributes();
            this.setFocus(true);
        }
    }

    private void moveSelectionDown(TreeItem sel, boolean dig) {
        if (sel == this.root) {
            return;
        }
        TreeItem topClosedParent = this.getTopClosedParent(sel);
        if (topClosedParent != null) {
            this.moveSelectionDown(topClosedParent, false);
            return;
        }
        TreeItem parent = sel.getParentItem();
        if (parent == null) {
            parent = this.root;
        }
        int idx = parent.getChildIndex(sel);
        if (!dig || !sel.getState()) {
            if (idx < parent.getChildCount() - 1) {
                this.onSelection(parent.getChild(idx + 1), true, true);
            } else {
                this.moveSelectionDown(parent, false);
            }
        } else if (sel.getChildCount() > 0) {
            this.onSelection(sel.getChild(0), true, true);
        }
    }

    private void moveSelectionUp(TreeItem sel) {
        int idx;
        TreeItem topClosedParent = this.getTopClosedParent(sel);
        if (topClosedParent != null) {
            this.onSelection(topClosedParent, true, true);
            return;
        }
        TreeItem parent = sel.getParentItem();
        if (parent == null) {
            parent = this.root;
        }
        if ((idx = parent.getChildIndex(sel)) > 0) {
            TreeItem sibling = parent.getChild(idx - 1);
            this.onSelection(this.findDeepestOpenChild(sibling), true, true);
        } else {
            this.onSelection(parent, true, true);
        }
    }

    private void onSelection(TreeItem item, boolean fireEvents, boolean moveFocus) {
        if (item == this.root) {
            return;
        }
        if (this.curSelection != null) {
            this.curSelection.setSelected(false);
        }
        this.curSelection = item;
        if (moveFocus && this.curSelection != null) {
            this.moveFocus();
            this.curSelection.setSelected(true);
            if (fireEvents && this.listeners != null) {
                this.listeners.fireItemSelected(this.curSelection);
            }
        }
    }

    private void setImages(TreeImages images, boolean useLeafImages) {
        if (useLeafImages) {
            this.leafImage = images.treeLeaf().createImage();
        } else {
            Image image = images.treeLeaf().createImage();
            DOM.setStyleAttribute(image.getElement(), "visibility", "hidden");
            RootPanel.get().add(image);
            int size = image.getWidth() + 7;
            image.removeFromParent();
            this.indentValue = size + "px";
        }
        this.openImage = images.treeOpen().createImage();
        this.closedImage = images.treeClosed().createImage();
    }

    private void showImage(TreeItem treeItem, Image image) {
        Element element = treeItem.getImageHolderElement();
        Element child = DOM.getFirstChild(element);
        if (child != null) {
            DOM.removeChild(element, child);
        }
        DOM.appendChild(element, DOM.clone(image.getElement(), true));
    }

    private void updateAriaAttributes() {
        Element curSelectionContentElem = this.curSelection.getContentElem();
        int curSelectionLevel = -1;
        TreeItem tempItem = this.curSelection;
        while (tempItem != null) {
            tempItem = tempItem.getParentItem();
            ++curSelectionLevel;
        }
        Accessibility.setState(curSelectionContentElem, "aria-level", String.valueOf(curSelectionLevel + 1));
        TreeItem curSelectionParent = this.curSelection.getParentItem();
        if (curSelectionParent == null) {
            curSelectionParent = this.root;
        }
        Accessibility.setState(curSelectionContentElem, "aria-setsize", String.valueOf(curSelectionParent.getChildCount()));
        int curSelectionIndex = curSelectionParent.getChildIndex(this.curSelection);
        Accessibility.setState(curSelectionContentElem, "aria-posinset", String.valueOf(curSelectionIndex + 1));
        if (this.curSelection.getChildCount() == 0) {
            Accessibility.removeState(curSelectionContentElem, "aria-expanded");
        } else if (this.curSelection.getState()) {
            Accessibility.setState(curSelectionContentElem, "aria-expanded", "true");
        } else {
            Accessibility.setState(curSelectionContentElem, "aria-expanded", "false");
        }
        Accessibility.setState(curSelectionContentElem, "aria-selected", "true");
        Accessibility.setState(this.focusable, "aria-activedescendant", DOM.getElementAttribute(curSelectionContentElem, "id"));
    }

    private static class ImagesFromImageBase
    implements TreeImages {
        private final String baseUrl;

        ImagesFromImageBase(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public AbstractImagePrototype treeClosed() {
            return new Prototype("tree_closed.gif");
        }

        public AbstractImagePrototype treeLeaf() {
            return new Prototype("tree_white.gif");
        }

        public AbstractImagePrototype treeOpen() {
            return new Prototype("tree_open.gif");
        }

        String getBaseUrl() {
            return this.baseUrl;
        }

        private class Prototype
        extends AbstractImagePrototype {
            private final String imageUrl;

            Prototype(String url) {
                this.imageUrl = url;
            }

            public void applyTo(Image image) {
                image.setUrl(ImagesFromImageBase.this.baseUrl + this.imageUrl);
            }

            public Image createImage() {
                throw new UnsupportedOperationException("createImage is unsupported.");
            }

            public String getHTML() {
                throw new UnsupportedOperationException("getHTML is unsupported.");
            }
        }
    }
}

