/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc;

import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.RPCServletUtils;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyLoader;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RemoteServiceServlet
extends HttpServlet
implements SerializationPolicyProvider {
    private final ThreadLocal<HttpServletRequest> perThreadRequest = new ThreadLocal();
    private final ThreadLocal<HttpServletResponse> perThreadResponse = new ThreadLocal();
    private final Map<String, SerializationPolicy> serializationPolicyCache = new HashMap<String, SerializationPolicy>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.perThreadRequest.set(request);
            this.perThreadResponse.set(response);
            String requestPayload = RPCServletUtils.readContentAsUtf8(request);
            this.onBeforeRequestDeserialized(requestPayload);
            String responsePayload = this.processCall(requestPayload);
            this.onAfterResponseSerialized(responsePayload);
            this.writeResponse(request, response, responsePayload);
            return;
        }
        catch (Throwable e) {
            this.doUnexpectedFailure(e);
        }
        finally {
            this.perThreadRequest.set(null);
            this.perThreadResponse.set(null);
        }
    }

    public final SerializationPolicy getSerializationPolicy(String moduleBaseURL, String strongName) {
        SerializationPolicy serializationPolicy = this.getCachedSerializationPolicy(moduleBaseURL, strongName);
        if (serializationPolicy != null) {
            return serializationPolicy;
        }
        serializationPolicy = this.doGetSerializationPolicy(this.getThreadLocalRequest(), moduleBaseURL, strongName);
        if (serializationPolicy == null) {
            this.getServletContext().log("WARNING: Failed to get the SerializationPolicy '" + strongName + "' for module '" + moduleBaseURL + "'; a legacy, 1.3.3 compatible, serialization policy will be used.  You may experience SerializationExceptions as a result.");
            serializationPolicy = RPC.getDefaultSerializationPolicy();
        }
        this.putCachedSerializationPolicy(moduleBaseURL, strongName, serializationPolicy);
        return serializationPolicy;
    }

    public String processCall(String payload) throws SerializationException {
        try {
            RPCRequest rpcRequest = RPC.decodeRequest(payload, this.getClass(), this);
            return RPC.invokeAndEncodeResponse(this, rpcRequest.getMethod(), rpcRequest.getParameters(), rpcRequest.getSerializationPolicy());
        }
        catch (IncompatibleRemoteServiceException ex) {
            this.getServletContext().log("An IncompatibleRemoteServiceException was thrown while processing this call.", (Throwable)ex);
            return RPC.encodeResponseForFailure(null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SerializationPolicy doGetSerializationPolicy(HttpServletRequest request, String moduleBaseURL, String strongName) {
        String contextPath = request.getContextPath();
        String modulePath = null;
        if (moduleBaseURL != null) {
            try {
                modulePath = new URL(moduleBaseURL).getPath();
            }
            catch (MalformedURLException ex) {
                this.getServletContext().log("Malformed moduleBaseURL: " + moduleBaseURL, (Throwable)ex);
            }
        }
        SerializationPolicy serializationPolicy = null;
        if (modulePath == null || !modulePath.startsWith(contextPath)) {
            String message = "ERROR: The module path requested, " + modulePath + ", is not in the same web application as this servlet, " + contextPath + ".  Your module may not be properly configured or your client and server code maybe out of date.";
            this.getServletContext().log(message);
        } else {
            String contextRelativePath = modulePath.substring(contextPath.length());
            String serializationPolicyFilePath = SerializationPolicyLoader.getSerializationPolicyFileName(contextRelativePath + strongName);
            InputStream is = this.getServletContext().getResourceAsStream(serializationPolicyFilePath);
            try {
                if (is != null) {
                    try {
                        serializationPolicy = SerializationPolicyLoader.loadFromStream(is, null);
                    }
                    catch (ParseException e) {
                        this.getServletContext().log("ERROR: Failed to parse the policy file '" + serializationPolicyFilePath + "'", (Throwable)e);
                    }
                    catch (IOException e) {
                        this.getServletContext().log("ERROR: Could not read the policy file '" + serializationPolicyFilePath + "'", (Throwable)e);
                    }
                } else {
                    String message = "ERROR: The serialization policy file '" + serializationPolicyFilePath + "' was not found; did you forget to include it in this deployment?";
                    this.getServletContext().log(message);
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return serializationPolicy;
    }

    protected void doUnexpectedFailure(Throwable e) {
        ServletContext servletContext = this.getServletContext();
        RPCServletUtils.writeResponseForUnexpectedFailure(servletContext, this.getThreadLocalResponse(), e);
    }

    protected final HttpServletRequest getThreadLocalRequest() {
        return this.perThreadRequest.get();
    }

    protected final HttpServletResponse getThreadLocalResponse() {
        return this.perThreadResponse.get();
    }

    protected void onAfterResponseSerialized(String serializedResponse) {
    }

    protected void onBeforeRequestDeserialized(String serializedRequest) {
    }

    protected boolean shouldCompressResponse(HttpServletRequest request, HttpServletResponse response, String responsePayload) {
        return RPCServletUtils.exceedsUncompressedContentLengthLimit(responsePayload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SerializationPolicy getCachedSerializationPolicy(String moduleBaseURL, String strongName) {
        Map<String, SerializationPolicy> map = this.serializationPolicyCache;
        synchronized (map) {
            return this.serializationPolicyCache.get(moduleBaseURL + strongName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putCachedSerializationPolicy(String moduleBaseURL, String strongName, SerializationPolicy serializationPolicy) {
        Map<String, SerializationPolicy> map = this.serializationPolicyCache;
        synchronized (map) {
            this.serializationPolicyCache.put(moduleBaseURL + strongName, serializationPolicy);
        }
    }

    private void writeResponse(HttpServletRequest request, HttpServletResponse response, String responsePayload) throws IOException {
        boolean gzipEncode = RPCServletUtils.acceptsGzipEncoding(request) && this.shouldCompressResponse(request, response, responsePayload);
        RPCServletUtils.writeResponse(this.getServletContext(), response, responsePayload, gzipEncode);
    }
}

