/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.OptionElement;
import com.google.gwt.dom.client.SelectElement;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.EventPreview;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.impl.DOMImpl;
import java.util.ArrayList;

public class DOM {
    private static Event currentEvent = null;
    private static final DOMImpl impl = (DOMImpl)GWT.create(DOMImpl.class);
    private static Element sCaptureElem;
    private static ArrayList<EventPreview> sEventPreviewStack;

    public static void addEventPreview(EventPreview preview) {
        impl.maybeInitializeEventSystem();
        if (sEventPreviewStack == null) {
            sEventPreviewStack = new ArrayList();
        }
        sEventPreviewStack.add(preview);
    }

    public static void appendChild(Element parent, Element child) {
        parent.appendChild(child);
    }

    public static Element clone(Element elem, boolean deep) {
        return (Element)elem.cloneNode(deep).cast();
    }

    public static boolean compare(Element elem1, Element elem2) {
        return elem1 == elem2;
    }

    public static Element createAnchor() {
        return (Element)Document.get().createAnchorElement().cast();
    }

    public static Element createButton() {
        return (Element)Document.get().createButtonElement().cast();
    }

    public static Element createCaption() {
        return (Element)Document.get().createCaptionElement().cast();
    }

    public static Element createCol() {
        return (Element)Document.get().createColElement().cast();
    }

    public static Element createColGroup() {
        return (Element)Document.get().createColGroupElement().cast();
    }

    public static Element createDiv() {
        return (Element)Document.get().createDivElement().cast();
    }

    public static Element createElement(String tagName) {
        return (Element)Document.get().createElement(tagName).cast();
    }

    public static Element createFieldSet() {
        return (Element)Document.get().createFieldSetElement().cast();
    }

    public static Element createForm() {
        return (Element)Document.get().createFormElement().cast();
    }

    public static Element createIFrame() {
        return (Element)Document.get().createIFrameElement().cast();
    }

    public static Element createImg() {
        return (Element)Document.get().createImageElement().cast();
    }

    public static Element createInputCheck() {
        return (Element)Document.get().createCheckInputElement().cast();
    }

    public static Element createInputPassword() {
        return (Element)Document.get().createPasswordInputElement().cast();
    }

    public static Element createInputRadio(String name) {
        return (Element)Document.get().createRadioInputElement(name).cast();
    }

    public static Element createInputText() {
        return (Element)Document.get().createTextInputElement().cast();
    }

    public static Element createLabel() {
        return (Element)Document.get().createLabelElement().cast();
    }

    public static Element createLegend() {
        return (Element)Document.get().createLegendElement().cast();
    }

    public static Element createOption() {
        return (Element)Document.get().createOptionElement().cast();
    }

    @Deprecated
    public static Element createOptions() {
        return (Element)Document.get().createElement("options").cast();
    }

    public static Element createSelect() {
        return (Element)Document.get().createSelectElement().cast();
    }

    public static Element createSelect(boolean multiple) {
        return (Element)Document.get().createSelectElement(multiple).cast();
    }

    public static Element createSpan() {
        return (Element)Document.get().createSpanElement().cast();
    }

    public static Element createTable() {
        return (Element)Document.get().createTableElement().cast();
    }

    public static Element createTBody() {
        return (Element)Document.get().createTBodyElement().cast();
    }

    public static Element createTD() {
        return (Element)Document.get().createTDElement().cast();
    }

    public static Element createTextArea() {
        return (Element)Document.get().createTextAreaElement().cast();
    }

    public static Element createTFoot() {
        return (Element)Document.get().createTFootElement().cast();
    }

    public static Element createTH() {
        return (Element)Document.get().createTHElement().cast();
    }

    public static Element createTHead() {
        return (Element)Document.get().createTHeadElement().cast();
    }

    public static Element createTR() {
        return (Element)Document.get().createTRElement().cast();
    }

    public static String createUniqueId() {
        return Document.get().createUniqueId();
    }

    public static void eventCancelBubble(Event evt, boolean cancel) {
        impl.eventCancelBubble(evt, cancel);
    }

    public static boolean eventGetAltKey(Event evt) throws AssertionError {
        DOM.assertEventType(evt, 263167, "altKey");
        return impl.eventGetAltKey(evt);
    }

    public static int eventGetButton(Event evt) throws AssertionError {
        DOM.assertEventType(evt, 12, "button");
        return impl.eventGetButton(evt);
    }

    public static int eventGetClientX(Event evt) throws AssertionError {
        DOM.assertEventType(evt, 393343, "clientX");
        return impl.eventGetClientX(evt);
    }

    public static int eventGetClientY(Event evt) throws AssertionError {
        DOM.assertEventType(evt, 393343, "clientY");
        return impl.eventGetClientY(evt);
    }

    public static boolean eventGetCtrlKey(Event evt) throws AssertionError {
        DOM.assertEventType(evt, 263167, "ctrlKey");
        return impl.eventGetCtrlKey(evt);
    }

    public static Event eventGetCurrentEvent() {
        return currentEvent;
    }

    public static Element eventGetCurrentTarget(Event evt) {
        return impl.eventGetCurrentTarget(evt);
    }

    public static Element eventGetFromElement(Event evt) throws AssertionError {
        DOM.assertEventType(evt, 48, "fromElement");
        return impl.eventGetFromElement(evt);
    }

    public static int eventGetKeyCode(Event evt) throws AssertionError {
        DOM.assertEventType(evt, 896, "keyCode");
        return impl.eventGetKeyCode(evt);
    }

    public static boolean eventGetMetaKey(Event evt) throws AssertionError {
        DOM.assertEventType(evt, 263167, "metaKey");
        return impl.eventGetMetaKey(evt);
    }

    public static int eventGetMouseWheelVelocityY(Event evt) throws AssertionError {
        DOM.assertEventType(evt, 131072, "mouseWheelVelocityY");
        return impl.eventGetMouseWheelVelocityY(evt);
    }

    public static boolean eventGetRepeat(Event evt) throws AssertionError {
        DOM.assertEventType(evt, 128, "repeat");
        return impl.eventGetRepeat(evt);
    }

    public static int eventGetScreenX(Event evt) throws AssertionError {
        DOM.assertEventType(evt, 393343, "screenX");
        return impl.eventGetScreenX(evt);
    }

    public static int eventGetScreenY(Event evt) throws AssertionError {
        DOM.assertEventType(evt, 393343, "screenY");
        return impl.eventGetScreenY(evt);
    }

    public static boolean eventGetShiftKey(Event evt) throws AssertionError {
        DOM.assertEventType(evt, 263167, "shiftKey");
        return impl.eventGetShiftKey(evt);
    }

    public static Element eventGetTarget(Event evt) {
        return impl.eventGetTarget(evt);
    }

    public static Element eventGetToElement(Event evt) throws AssertionError {
        DOM.assertEventType(evt, 48, "toElement");
        return impl.eventGetToElement(evt);
    }

    public static int eventGetType(Event evt) {
        return impl.eventGetTypeInt(evt);
    }

    public static String eventGetTypeString(Event evt) {
        return impl.eventGetType(evt);
    }

    public static void eventPreventDefault(Event evt) {
        impl.eventPreventDefault(evt);
    }

    public static void eventSetKeyCode(Event evt, char key) throws AssertionError {
        DOM.assertEventType(evt, 896, "keyCode");
        impl.eventSetKeyCode(evt, key);
    }

    public static String eventToString(Event evt) {
        return impl.eventToString(evt);
    }

    public static int getAbsoluteLeft(Element elem) {
        return elem.getAbsoluteLeft();
    }

    public static int getAbsoluteTop(Element elem) {
        return elem.getAbsoluteTop();
    }

    @Deprecated
    public static String getAttribute(Element elem, String attr) {
        return elem.getPropertyString(attr);
    }

    @Deprecated
    public static boolean getBooleanAttribute(Element elem, String attr) {
        return elem.getPropertyBoolean(attr);
    }

    public static Element getCaptureElement() {
        return sCaptureElem;
    }

    public static Element getChild(Element parent, int index) {
        return impl.getChild(parent, index);
    }

    public static int getChildCount(Element parent) {
        return impl.getChildCount(parent);
    }

    public static int getChildIndex(Element parent, Element child) {
        return impl.getChildIndex(parent, child);
    }

    public static String getElementAttribute(Element elem, String attr) {
        return elem.getAttribute(attr);
    }

    public static Element getElementById(String id) {
        return (Element)Document.get().getElementById(id).cast();
    }

    public static String getElementProperty(Element elem, String prop) {
        return elem.getPropertyString(prop);
    }

    public static boolean getElementPropertyBoolean(Element elem, String prop) {
        return elem.getPropertyBoolean(prop);
    }

    public static int getElementPropertyInt(Element elem, String prop) {
        return elem.getPropertyInt(prop);
    }

    public static int getEventsSunk(Element elem) {
        return impl.getEventsSunk(elem);
    }

    public static Element getFirstChild(Element elem) {
        return (Element)elem.getFirstChildElement().cast();
    }

    public static String getImgSrc(Element img) {
        return ((ImageElement)img.cast()).getSrc();
    }

    public static String getInnerHTML(Element elem) {
        return elem.getInnerHTML();
    }

    public static String getInnerText(Element elem) {
        return elem.getInnerText();
    }

    @Deprecated
    public static int getIntAttribute(Element elem, String attr) {
        return elem.getPropertyInt(attr);
    }

    public static native int getIntStyleAttribute(Element var0, String var1);

    public static Element getNextSibling(Element elem) {
        return (Element)elem.getNextSibling().cast();
    }

    public static Element getParent(Element elem) {
        return (Element)elem.getParentElement().cast();
    }

    public static String getStyleAttribute(Element elem, String attr) {
        return elem.getStyle().getProperty(attr);
    }

    public static void insertBefore(Element parent, Element child, Element before) {
        parent.insertBefore(child, before);
    }

    public static void insertChild(Element parent, Element child, int index) {
        impl.insertChild(parent, child, index);
    }

    public static void insertListItem(Element selectElem, String item, String value, int index) {
        SelectElement select = (SelectElement)selectElem.cast();
        OptionElement option = Document.get().createOptionElement();
        option.setText(item);
        option.setValue(value);
        if (index == -1 || index == select.getLength()) {
            select.add(option, null);
        } else {
            OptionElement before = select.getOptions().getItem(index);
            select.add(option, before);
        }
    }

    public static boolean isOrHasChild(Element parent, Element child) {
        return parent.isOrHasChild(child);
    }

    public static void releaseCapture(Element elem) {
        if (sCaptureElem != null && elem == sCaptureElem) {
            sCaptureElem = null;
        }
        impl.releaseCapture(elem);
    }

    public static void removeChild(Element parent, Element child) {
        parent.removeChild(child);
    }

    public static void removeElementAttribute(Element elem, String attr) {
        elem.removeAttribute(attr);
    }

    public static void removeEventPreview(EventPreview preview) {
        if (sEventPreviewStack != null) {
            sEventPreviewStack.remove(preview);
        }
    }

    public static void scrollIntoView(Element elem) {
        elem.scrollIntoView();
    }

    @Deprecated
    public static void setAttribute(Element elem, String attr, String value) {
        DOM.setElementProperty(elem, attr, value);
    }

    @Deprecated
    public static void setBooleanAttribute(Element elem, String attr, boolean value) {
        DOM.setElementPropertyBoolean(elem, attr, value);
    }

    public static void setCapture(Element elem) {
        sCaptureElem = elem;
        impl.setCapture(elem);
    }

    public static void setElementAttribute(Element elem, String attr, String value) {
        elem.setAttribute(attr, value);
    }

    public static void setElementProperty(Element elem, String prop, String value) {
        elem.setPropertyString(prop, value);
    }

    public static void setElementPropertyBoolean(Element elem, String prop, boolean value) {
        elem.setPropertyBoolean(prop, value);
    }

    public static void setElementPropertyInt(Element elem, String prop, int value) {
        elem.setPropertyInt(prop, value);
    }

    public static void setEventListener(Element elem, EventListener listener) {
        impl.setEventListener(elem, listener);
    }

    public static void setImgSrc(Element img, String src) {
        ((ImageElement)img.cast()).setSrc(src);
    }

    public static void setInnerHTML(Element elem, String html) {
        elem.setInnerHTML(html);
    }

    public static void setInnerText(Element elem, String text) {
        elem.setInnerText(text);
    }

    @Deprecated
    public static void setIntAttribute(Element elem, String attr, int value) {
        DOM.setElementPropertyInt(elem, attr, value);
    }

    public static void setIntStyleAttribute(Element elem, String attr, int value) {
        elem.getStyle().setProperty(attr, Integer.toString(value));
    }

    public static void setOptionText(Element select, String text, int index) {
        ((SelectElement)select.cast()).getOptions().getItem(index).setText(text);
    }

    public static void setStyleAttribute(Element elem, String attr, String value) {
        elem.getStyle().setProperty(attr, value);
    }

    public static void sinkEvents(Element elem, int eventBits) {
        impl.sinkEvents(elem, eventBits);
    }

    public static String toString(Element elem) {
        return elem.getString();
    }

    @Deprecated
    public static int windowGetClientHeight() {
        return Window.getClientHeight();
    }

    @Deprecated
    public static int windowGetClientWidth() {
        return Window.getClientWidth();
    }

    static void dispatchEvent(Event evt, Element elem, EventListener listener) {
        GWT.UncaughtExceptionHandler handler = GWT.getUncaughtExceptionHandler();
        if (handler != null) {
            DOM.dispatchEventAndCatch(evt, elem, listener, handler);
        } else {
            DOM.dispatchEventImpl(evt, elem, listener);
        }
    }

    static boolean previewEvent(Event evt) {
        EventPreview preview;
        boolean ret = true;
        if (sEventPreviewStack != null && sEventPreviewStack.size() > 0 && !(ret = (preview = sEventPreviewStack.get(sEventPreviewStack.size() - 1)).onEventPreview(evt))) {
            DOM.eventCancelBubble(evt, true);
            DOM.eventPreventDefault(evt);
        }
        return ret;
    }

    private static void assertEventType(Event evt, int evtType, String attr) {
        assert ((DOM.eventGetType(evt) & evtType) != 0) : "attribute '" + attr + "' not defined for event type '" + DOM.eventGetTypeString(evt) + "'";
    }

    private static void dispatchEventAndCatch(Event evt, Element elem, EventListener listener, GWT.UncaughtExceptionHandler handler) {
        try {
            DOM.dispatchEventImpl(evt, elem, listener);
        }
        catch (Throwable e) {
            handler.onUncaughtException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dispatchEventImpl(Event evt, Element elem, EventListener listener) {
        if (elem == sCaptureElem && DOM.eventGetType(evt) == 8192) {
            sCaptureElem = null;
        }
        Event prevCurrentEvent = currentEvent;
        currentEvent = evt;
        try {
            listener.onBrowserEvent(evt);
        }
        finally {
            currentEvent = prevCurrentEvent;
        }
    }
}

