/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import java.util.ArrayList;

public abstract class Timer {
    private static ArrayList<Timer> timers = new ArrayList();
    private boolean isRepeating;
    private int timerId;

    private static native void clearInterval(int var0);

    private static native void clearTimeout(int var0);

    private static native int createInterval(Timer var0, int var1);

    private static native int createTimeout(Timer var0, int var1);

    private static void hookWindowClosing() {
        Window.addWindowClosingHandler(new Window.ClosingHandler(){

            public void onWindowClosing(Window.ClosingEvent event) {
                while (timers.size() > 0) {
                    ((Timer)timers.get(0)).cancel();
                }
            }
        });
    }

    public void cancel() {
        if (this.isRepeating) {
            Timer.clearInterval(this.timerId);
        } else {
            Timer.clearTimeout(this.timerId);
        }
        timers.remove(this);
    }

    public abstract void run();

    public void schedule(int delayMillis) {
        if (delayMillis <= 0) {
            throw new IllegalArgumentException("must be positive");
        }
        this.cancel();
        this.isRepeating = false;
        this.timerId = Timer.createTimeout(this, delayMillis);
        timers.add(this);
    }

    public void scheduleRepeating(int periodMillis) {
        if (periodMillis <= 0) {
            throw new IllegalArgumentException("must be positive");
        }
        this.cancel();
        this.isRepeating = true;
        this.timerId = Timer.createInterval(this, periodMillis);
        timers.add(this);
    }

    final void fire() {
        GWT.UncaughtExceptionHandler handler = GWT.getUncaughtExceptionHandler();
        if (handler != null) {
            this.fireAndCatch(handler);
        } else {
            this.fireImpl();
        }
    }

    private void fireAndCatch(GWT.UncaughtExceptionHandler handler) {
        try {
            this.fireImpl();
        }
        catch (Throwable e) {
            handler.onUncaughtException(e);
        }
    }

    private void fireImpl() {
        if (!this.isRepeating) {
            timers.remove(this);
        }
        this.run();
    }

    static {
        Timer.hookWindowClosing();
    }
}

