/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.ErrorEvent;
import com.google.gwt.event.dom.client.ErrorHandler;
import com.google.gwt.event.dom.client.HasAllMouseHandlers;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.dom.client.HasErrorHandlers;
import com.google.gwt.event.dom.client.HasLoadHandlers;
import com.google.gwt.event.dom.client.LoadEvent;
import com.google.gwt.event.dom.client.LoadHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.ListenerWrapper;
import com.google.gwt.user.client.ui.LoadListener;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.MouseWheelListener;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SourcesClickEvents;
import com.google.gwt.user.client.ui.SourcesLoadEvents;
import com.google.gwt.user.client.ui.SourcesMouseEvents;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.impl.ClippedImageImpl;
import java.util.HashMap;

public class Image
extends Widget
implements SourcesLoadEvents,
HasLoadHandlers,
HasErrorHandlers,
SourcesClickEvents,
HasClickHandlers,
HasAllMouseHandlers,
SourcesMouseEvents {
    private static HashMap<String, Element> prefetchImages = new HashMap();
    private State state;

    public static void prefetch(String url) {
        ImageElement img = Document.get().createImageElement();
        img.setSrc(url);
        prefetchImages.put(url, img);
    }

    public static Image wrap(Element element) {
        assert (Document.get().getBody().isOrHasChild(element));
        Image image = new Image(element);
        image.changeState(new UnclippedState(element));
        image.onAttach();
        RootPanel.detachOnWindowClose(image);
        return image;
    }

    public Image() {
        this.changeState(new UnclippedState(this));
        this.setStyleName("gwt-Image");
    }

    public Image(String url) {
        this.changeState(new UnclippedState(this, url));
        this.setStyleName("gwt-Image");
    }

    public Image(String url, int left, int top, int width, int height) {
        this.changeState(new ClippedState(this, url, left, top, width, height));
        this.setStyleName("gwt-Image");
    }

    protected Image(Element element) {
        ImageElement.as(element);
        this.setElement(element);
    }

    public HandlerRegistration addClickHandler(ClickHandler handler) {
        return this.addHandler(handler, ClickEvent.getType());
    }

    @Deprecated
    public void addClickListener(ClickListener listener) {
        ListenerWrapper.WrappedClickListener.add(this, listener);
    }

    public HandlerRegistration addErrorHandler(ErrorHandler handler) {
        return super.addHandler(handler, ErrorEvent.getType());
    }

    public HandlerRegistration addLoadHandler(LoadHandler handler) {
        return super.addHandler(handler, LoadEvent.getType());
    }

    @Deprecated
    public void addLoadListener(LoadListener listener) {
        ListenerWrapper.WrappedLoadListener.add(this, listener);
    }

    public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
        return this.addDomHandler(handler, MouseDownEvent.getType());
    }

    @Deprecated
    public void addMouseListener(MouseListener listener) {
        ListenerWrapper.WrappedMouseListener.add(this, listener);
    }

    public HandlerRegistration addMouseMoveHandler(MouseMoveHandler handler) {
        return this.addDomHandler(handler, MouseMoveEvent.getType());
    }

    public HandlerRegistration addMouseOutHandler(MouseOutHandler handler) {
        return this.addDomHandler(handler, MouseOutEvent.getType());
    }

    public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {
        return this.addDomHandler(handler, MouseOverEvent.getType());
    }

    public HandlerRegistration addMouseUpHandler(MouseUpHandler handler) {
        return this.addDomHandler(handler, MouseUpEvent.getType());
    }

    public HandlerRegistration addMouseWheelHandler(MouseWheelHandler handler) {
        return this.addDomHandler(handler, MouseWheelEvent.getType());
    }

    @Deprecated
    public void addMouseWheelListener(MouseWheelListener listener) {
        ListenerWrapper.WrappedMouseWheelListener.add(this, listener);
    }

    public int getHeight() {
        return this.state.getHeight(this);
    }

    public int getOriginLeft() {
        return this.state.getOriginLeft();
    }

    public int getOriginTop() {
        return this.state.getOriginTop();
    }

    public String getUrl() {
        return this.state.getUrl(this);
    }

    public int getWidth() {
        return this.state.getWidth(this);
    }

    @Deprecated
    public void removeClickListener(ClickListener listener) {
        ListenerWrapper.WrappedClickListener.remove(this, listener);
    }

    @Deprecated
    public void removeLoadListener(LoadListener listener) {
        ListenerWrapper.WrappedLoadListener.remove(this, listener);
    }

    @Deprecated
    public void removeMouseListener(MouseListener listener) {
        ListenerWrapper.WrappedMouseListener.remove(this, listener);
    }

    @Deprecated
    public void removeMouseWheelListener(MouseWheelListener listener) {
        ListenerWrapper.WrappedMouseWheelListener.remove(this, listener);
    }

    public void setUrl(String url) {
        this.state.setUrl(this, url);
    }

    public void setUrlAndVisibleRect(String url, int left, int top, int width, int height) {
        this.state.setUrlAndVisibleRect(this, url, left, top, width, height);
    }

    public void setVisibleRect(int left, int top, int width, int height) {
        this.state.setVisibleRect(this, left, top, width, height);
    }

    private void changeState(State newState) {
        this.state = newState;
    }

    private ImageElement getImageElement() {
        return (ImageElement)this.getElement().cast();
    }

    private static class UnclippedState
    extends State {
        UnclippedState(Element element) {
            Event.sinkEvents(element, 229501);
        }

        UnclippedState(Image image) {
            image.replaceElement(Document.get().createImageElement());
            image.sinkEvents(229501);
        }

        UnclippedState(Image image, String url) {
            this(image);
            this.setUrl(image, url);
        }

        public int getHeight(Image image) {
            return image.getImageElement().getHeight();
        }

        public int getOriginLeft() {
            return 0;
        }

        public int getOriginTop() {
            return 0;
        }

        public String getUrl(Image image) {
            return image.getImageElement().getSrc();
        }

        public int getWidth(Image image) {
            return image.getImageElement().getWidth();
        }

        public void setUrl(Image image, String url) {
            image.getImageElement().setSrc(url);
        }

        public void setUrlAndVisibleRect(Image image, String url, int left, int top, int width, int height) {
            image.changeState(new ClippedState(image, url, left, top, width, height));
        }

        public void setVisibleRect(Image image, int left, int top, int width, int height) {
            image.changeState(new ClippedState(image, this.getUrl(image), left, top, width, height));
        }

        protected String getStateName() {
            return "unclipped";
        }
    }

    private static abstract class State {
        private State() {
        }

        public abstract int getHeight(Image var1);

        public abstract int getOriginLeft();

        public abstract int getOriginTop();

        public abstract String getUrl(Image var1);

        public abstract int getWidth(Image var1);

        public abstract void setUrl(Image var1, String var2);

        public abstract void setUrlAndVisibleRect(Image var1, String var2, int var3, int var4, int var5, int var6);

        public abstract void setVisibleRect(Image var1, int var2, int var3, int var4, int var5);

        protected abstract String getStateName();
    }

    private static class ClippedState
    extends State {
        private static final ClippedImageImpl impl = (ClippedImageImpl)GWT.create(ClippedImageImpl.class);
        private int height = 0;
        private int left = 0;
        private int top = 0;
        private String url = null;
        private int width = 0;

        ClippedState(Image image, String url, int left, int top, int width, int height) {
            this.left = left;
            this.top = top;
            this.width = width;
            this.height = height;
            this.url = url;
            image.replaceElement(impl.createStructure(url, left, top, width, height));
            image.sinkEvents(163965);
        }

        public int getHeight(Image image) {
            return this.height;
        }

        public int getOriginLeft() {
            return this.left;
        }

        public int getOriginTop() {
            return this.top;
        }

        public String getUrl(Image image) {
            return this.url;
        }

        public int getWidth(Image image) {
            return this.width;
        }

        public void setUrl(Image image, String url) {
            image.changeState(new UnclippedState(image, url));
        }

        public void setUrlAndVisibleRect(Image image, String url, int left, int top, int width, int height) {
            if (!this.url.equals(url) || this.left != left || this.top != top || this.width != width || this.height != height) {
                this.url = url;
                this.left = left;
                this.top = top;
                this.width = width;
                this.height = height;
                impl.adjust(image.getElement(), url, left, top, width, height);
                impl.fireSyntheticLoadEvent(image);
            }
        }

        public void setVisibleRect(Image image, int left, int top, int width, int height) {
            if (this.left != left || this.top != top || this.width != width || this.height != height) {
                this.left = left;
                this.top = top;
                this.width = width;
                this.height = height;
                impl.adjust(image.getElement(), this.url, left, top, width, height);
                impl.fireSyntheticLoadEvent(image);
            }
        }

        protected String getStateName() {
            return "clipped";
        }
    }
}

