/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.i18n.client.BidiUtils;
import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RootPanel
extends AbsolutePanel {
    private static Map<String, RootPanel> rootPanels = new HashMap<String, RootPanel>();
    private static Set<Widget> widgetsToDetach = new HashSet<Widget>();

    public static void detachNow(Widget widget) {
        assert (!RootPanel.getBodyElement().isOrHasChild(widget.getElement())) : "detachNow() called on a widget whose element is still attached to the document";
        assert (widgetsToDetach.contains(widget)) : "detachNow() called on a widget not currently in the detach list";
        widget.onDetach();
        widgetsToDetach.remove(widget);
    }

    public static void detachOnWindowClose(Widget widget) {
        assert (!widgetsToDetach.contains(widget)) : "detachOnUnload() called twice for the same widget";
        widgetsToDetach.add(widget);
    }

    public static RootPanel get() {
        return RootPanel.get(null);
    }

    public static RootPanel get(String id) {
        RootPanel rp = rootPanels.get(id);
        if (rp != null) {
            return rp;
        }
        Element elem = null;
        if (id != null && null == (elem = DOM.getElementById(id))) {
            return null;
        }
        if (rootPanels.size() == 0) {
            RootPanel.hookWindowClosing();
            if (LocaleInfo.getCurrentLocale().isRTL()) {
                BidiUtils.setDirectionOnElement(RootPanel.getRootElement(), HasDirection.Direction.RTL);
            }
        }
        rp = elem == null ? new DefaultRootPanel() : new RootPanel(elem);
        rootPanels.put(id, rp);
        RootPanel.detachOnWindowClose(rp);
        return rp;
    }

    public static native Element getBodyElement();

    static void detachWidgets() {
        for (Widget widget : widgetsToDetach) {
            if (widget.isAttached()) {
                widget.onDetach();
            }
            assert (RootPanel.getBodyElement().isOrHasChild(widget.getElement())) : "A widget in the detach list was found not attached to the document. The is likely caused by wrapping an existing element and removing it from the document without calling RootPanel.detachNow().";
        }
    }

    private static native Element getRootElement();

    private static void hookWindowClosing() {
        Window.addCloseHandler(new CloseHandler<Window>(){

            @Override
            public void onClose(CloseEvent<Window> closeEvent) {
                RootPanel.detachWidgets();
            }
        });
    }

    private RootPanel(Element elem) {
        super(elem);
        this.onAttach();
    }

    private static class DefaultRootPanel
    extends RootPanel {
        public DefaultRootPanel() {
            super(DefaultRootPanel.getBodyElement());
        }

        protected void setWidgetPositionImpl(Widget w, int left, int top) {
            super.setWidgetPositionImpl(w, left -= Document.get().getBodyOffsetLeft(), top -= Document.get().getBodyOffsetTop());
        }
    }
}

