/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.logical.shared.HasResizeHandlers;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.BaseListenerWrapper;
import com.google.gwt.user.client.WindowCloseListener;
import com.google.gwt.user.client.WindowResizeListener;
import com.google.gwt.user.client.WindowScrollListener;
import com.google.gwt.user.client.impl.WindowImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Window {
    static WindowHandlers handlers;
    private static boolean closeHandlersInitialized;
    private static boolean scrollHandlersInitialized;
    private static boolean resizeHandlersInitialized;
    private static int lastResizeWidth;
    private static int lastResizeHeight;
    private static final WindowImpl impl;

    public static HandlerRegistration addCloseHandler(CloseHandler<Window> handler) {
        Window.maybeInitializeCloseHandlers();
        return Window.addHandler(CloseEvent.getType(), handler);
    }

    public static HandlerRegistration addResizeHandler(ResizeHandler handler) {
        Window.maybeInitializeCloseHandlers();
        Window.maybeInitializeResizeHandlers();
        return Window.addHandler(ResizeEvent.getType(), handler);
    }

    @Deprecated
    public static void addWindowCloseListener(WindowCloseListener listener) {
        BaseListenerWrapper.WrapWindowClose.add(listener);
    }

    public static HandlerRegistration addWindowClosingHandler(ClosingHandler handler) {
        Window.maybeInitializeCloseHandlers();
        return Window.addHandler(ClosingEvent.getType(), handler);
    }

    @Deprecated
    public static void addWindowResizeListener(WindowResizeListener listener) {
        BaseListenerWrapper.WrapWindowResize.add(listener);
    }

    public static HandlerRegistration addWindowScrollHandler(ScrollHandler handler) {
        Window.maybeInitializeCloseHandlers();
        Window.maybeInitializeScrollHandlers();
        return Window.addHandler(ScrollEvent.getType(), handler);
    }

    @Deprecated
    public static void addWindowScrollListener(WindowScrollListener listener) {
        BaseListenerWrapper.WrapWindowScroll.add(listener);
    }

    public static native void alert(String var0);

    public static native boolean confirm(String var0);

    public static void enableScrolling(boolean enable) {
        impl.enableScrolling(enable);
    }

    public static int getClientHeight() {
        return impl.getClientHeight();
    }

    public static int getClientWidth() {
        return impl.getClientWidth();
    }

    public static int getScrollLeft() {
        return impl.getScrollLeft();
    }

    public static int getScrollTop() {
        return impl.getScrollTop();
    }

    public static native String getTitle();

    public static native void open(String var0, String var1, String var2);

    public static native void print();

    public static native String prompt(String var0, String var1);

    @Deprecated
    public static void removeWindowCloseListener(WindowCloseListener listener) {
        BaseListenerWrapper.WrapWindowClose.remove(handlers, listener);
    }

    @Deprecated
    public static void removeWindowResizeListener(WindowResizeListener listener) {
        BaseListenerWrapper.WrapWindowResize.remove(handlers, listener);
    }

    @Deprecated
    public static void removeWindowScrollListener(WindowScrollListener listener) {
        BaseListenerWrapper.WrapWindowScroll.remove(handlers, listener);
    }

    public static native void scrollTo(int var0, int var1);

    public static native void setMargin(String var0);

    public static native void setStatus(String var0);

    public static native void setTitle(String var0);

    static void onClosed() {
        GWT.UncaughtExceptionHandler handler = GWT.getUncaughtExceptionHandler();
        if (handler != null) {
            Window.fireClosedAndCatch(handler);
        } else {
            Window.fireClosedImpl();
        }
    }

    static String onClosing() {
        GWT.UncaughtExceptionHandler handler = GWT.getUncaughtExceptionHandler();
        if (handler != null) {
            return Window.fireClosingAndCatch(handler);
        }
        return Window.fireClosingImpl();
    }

    static void onResize() {
        GWT.UncaughtExceptionHandler handler = GWT.getUncaughtExceptionHandler();
        if (handler != null) {
            Window.fireResizedAndCatch(handler);
        } else {
            Window.fireResizedImpl();
        }
    }

    static void onScroll() {
        GWT.UncaughtExceptionHandler handler = GWT.getUncaughtExceptionHandler();
        if (handler != null) {
            Window.fireScrollAndCatch(handler);
        } else {
            Window.fireScrollImpl();
        }
    }

    private static <H extends EventHandler> HandlerRegistration addHandler(GwtEvent.Type<H> type, H handler) {
        return Window.getHandlers().addHandler(type, handler);
    }

    private static void fireClosedAndCatch(GWT.UncaughtExceptionHandler handler) {
        try {
            Window.fireClosedImpl();
        }
        catch (Throwable e) {
            handler.onUncaughtException(e);
        }
    }

    private static void fireClosedImpl() {
        if (closeHandlersInitialized) {
            CloseEvent.fire(Window.getHandlers(), null);
        }
    }

    private static String fireClosingAndCatch(GWT.UncaughtExceptionHandler handler) {
        try {
            return Window.fireClosingImpl();
        }
        catch (Throwable e) {
            handler.onUncaughtException(e);
            return null;
        }
    }

    private static String fireClosingImpl() {
        if (closeHandlersInitialized) {
            ClosingEvent event = new ClosingEvent();
            Window.fireEvent(event);
            return event.getMessage();
        }
        return null;
    }

    private static void fireEvent(GwtEvent<?> event) {
        if (handlers != null) {
            handlers.fireEvent(event);
        }
    }

    private static void fireResizedAndCatch(GWT.UncaughtExceptionHandler handler) {
        try {
            Window.fireResizedImpl();
        }
        catch (Throwable e) {
            handler.onUncaughtException(e);
        }
    }

    private static void fireResizedImpl() {
        if (resizeHandlersInitialized) {
            int width = Window.getClientWidth();
            int height = Window.getClientHeight();
            if (lastResizeWidth != width || lastResizeHeight != height) {
                lastResizeWidth = width;
                lastResizeHeight = height;
                ResizeEvent.fire(Window.getHandlers(), width, height);
            }
        }
    }

    private static void fireScrollAndCatch(GWT.UncaughtExceptionHandler handler) {
        try {
            Window.fireScrollImpl();
        }
        catch (Throwable e) {
            handler.onUncaughtException(e);
        }
    }

    private static void fireScrollImpl() {
        if (scrollHandlersInitialized) {
            Window.fireEvent(new ScrollEvent(Window.getScrollLeft(), Window.getScrollTop()));
        }
    }

    private static WindowHandlers getHandlers() {
        if (handlers == null) {
            handlers = new WindowHandlers();
        }
        return handlers;
    }

    private static void maybeInitializeCloseHandlers() {
        if (GWT.isClient() && !closeHandlersInitialized) {
            impl.initWindowCloseHandler();
            closeHandlersInitialized = true;
        }
    }

    private static void maybeInitializeResizeHandlers() {
        if (GWT.isClient() && !resizeHandlersInitialized) {
            impl.initWindowResizeHandler();
            resizeHandlersInitialized = true;
        }
    }

    private static void maybeInitializeScrollHandlers() {
        if (GWT.isClient() && !scrollHandlersInitialized) {
            impl.initWindowScrollHandler();
            scrollHandlersInitialized = true;
        }
    }

    private Window() {
    }

    static {
        impl = (WindowImpl)GWT.create(WindowImpl.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WindowHandlers
    extends HandlerManager
    implements HasCloseHandlers<Window>,
    HasResizeHandlers,
    HasHandlers {
        public WindowHandlers() {
            super(null);
        }

        @Override
        public HandlerRegistration addCloseHandler(CloseHandler<Window> handler) {
            return this.addHandler(CloseEvent.getType(), handler);
        }

        @Override
        public HandlerRegistration addResizeHandler(ResizeHandler handler) {
            return this.addHandler(ResizeEvent.getType(), handler);
        }

        public HandlerManager getHandlers() {
            return this;
        }
    }

    public static interface ScrollHandler
    extends EventHandler {
        public void onWindowScroll(ScrollEvent var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ScrollEvent
    extends GwtEvent<ScrollHandler> {
        static final GwtEvent.Type<ScrollHandler> TYPE = new GwtEvent.Type();
        private int scrollLeft;
        private int scrollTop;

        static GwtEvent.Type<ScrollHandler> getType() {
            return TYPE;
        }

        private ScrollEvent(int scrollLeft, int scrollTop) {
            this.scrollLeft = scrollLeft;
            this.scrollTop = scrollTop;
        }

        @Override
        public final GwtEvent.Type<ScrollHandler> getAssociatedType() {
            return TYPE;
        }

        public int getScrollLeft() {
            return this.scrollLeft;
        }

        public int getScrollTop() {
            return this.scrollTop;
        }

        @Override
        protected void dispatch(ScrollHandler handler) {
            handler.onWindowScroll(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Location {
        private static Map<String, String> paramMap;
        private static Map<String, List<String>> listParamMap;

        public static native void assign(String var0);

        public static String getHash() {
            return impl.getHash();
        }

        public static native String getHost();

        public static native String getHostName();

        public static native String getHref();

        public static String getParameter(String name) {
            Location.ensureParameterMap();
            return paramMap.get(name);
        }

        public static Map<String, List<String>> getParameterMap() {
            if (listParamMap == null) {
                listParamMap = Location.buildListParamMap(Location.getQueryString());
            }
            return listParamMap;
        }

        public static native String getPath();

        public static native String getPort();

        public static native String getProtocol();

        public static String getQueryString() {
            return impl.getQueryString();
        }

        public static native void reload();

        public static native void replace(String var0);

        static Map<String, List<String>> buildListParamMap(String queryString) {
            HashMap<String, List<String>> out = new HashMap();
            if (queryString != null && queryString.length() > 1) {
                String qs = queryString.substring(1);
                for (String kvPair : qs.split("&")) {
                    String[] kv = kvPair.split("=", 2);
                    if (kv[0].length() == 0) continue;
                    ArrayList<String> values = (ArrayList<String>)out.get(kv[0]);
                    if (values == null) {
                        values = new ArrayList<String>();
                        out.put(kv[0], values);
                    }
                    values.add(kv.length > 1 ? URL.decode(kv[1]) : "");
                }
            }
            for (Map.Entry entry : out.entrySet()) {
                entry.setValue(Collections.unmodifiableList((List)entry.getValue()));
            }
            out = Collections.unmodifiableMap(out);
            return out;
        }

        private static void ensureParameterMap() {
            if (paramMap == null) {
                paramMap = new HashMap<String, String>();
                String queryString = Location.getQueryString();
                if (queryString != null && queryString.length() > 1) {
                    String qs = queryString.substring(1);
                    for (String kvPair : qs.split("&")) {
                        String[] kv = kvPair.split("=", 2);
                        if (kv.length > 1) {
                            paramMap.put(kv[0], URL.decode(kv[1]));
                            continue;
                        }
                        paramMap.put(kv[0], "");
                    }
                }
            }
        }

        private Location() {
        }
    }

    public static interface ClosingHandler
    extends EventHandler {
        public void onWindowClosing(ClosingEvent var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClosingEvent
    extends GwtEvent<ClosingHandler> {
        private static final GwtEvent.Type<ClosingHandler> TYPE = new GwtEvent.Type();
        private String message = null;

        static GwtEvent.Type<ClosingHandler> getType() {
            return TYPE;
        }

        @Override
        public final GwtEvent.Type<ClosingHandler> getAssociatedType() {
            return TYPE;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        protected void dispatch(ClosingHandler handler) {
            handler.onWindowClosing(this);
        }
    }
}

