/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.OptionElement;
import com.google.gwt.dom.client.SelectElement;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.HasChangeHandlers;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.ListenerWrapper;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SourcesChangeEvents;

public class ListBox
extends FocusWidget
implements SourcesChangeEvents,
HasChangeHandlers,
HasName {
    private static final int INSERT_AT_END = -1;

    public static ListBox wrap(Element element) {
        assert (Document.get().getBody().isOrHasChild(element));
        ListBox listBox = new ListBox(element);
        listBox.onAttach();
        RootPanel.detachOnWindowClose(listBox);
        return listBox;
    }

    public ListBox() {
        this(false);
    }

    public ListBox(boolean isMultipleSelect) {
        super(Document.get().createSelectElement(isMultipleSelect));
        this.setStyleName("gwt-ListBox");
    }

    protected ListBox(Element element) {
        super(element);
        SelectElement.as(element);
    }

    public HandlerRegistration addChangeHandler(ChangeHandler handler) {
        return this.addDomHandler(handler, ChangeEvent.getType());
    }

    @Deprecated
    public void addChangeListener(ChangeListener listener) {
        ListenerWrapper.WrappedChangeListener.add(this, listener);
    }

    public void addItem(String item) {
        this.insertItem(item, -1);
    }

    public void addItem(String item, String value) {
        this.insertItem(item, value, -1);
    }

    public void clear() {
        this.getSelectElement().clear();
    }

    public int getItemCount() {
        return this.getSelectElement().getOptions().getLength();
    }

    public String getItemText(int index) {
        this.checkIndex(index);
        return this.getSelectElement().getOptions().getItem(index).getText();
    }

    public String getName() {
        return this.getSelectElement().getName();
    }

    public int getSelectedIndex() {
        return this.getSelectElement().getSelectedIndex();
    }

    public String getValue(int index) {
        this.checkIndex(index);
        return this.getSelectElement().getOptions().getItem(index).getValue();
    }

    public int getVisibleItemCount() {
        return this.getSelectElement().getSize();
    }

    public void insertItem(String item, int index) {
        this.insertItem(item, item, index);
    }

    public void insertItem(String item, String value, int index) {
        SelectElement select = this.getSelectElement();
        OptionElement option = Document.get().createOptionElement();
        option.setText(item);
        option.setValue(value);
        if (index == -1 || index == select.getLength()) {
            select.add(option, null);
        } else {
            OptionElement before = select.getOptions().getItem(index);
            select.add(option, before);
        }
    }

    public boolean isItemSelected(int index) {
        this.checkIndex(index);
        return this.getSelectElement().getOptions().getItem(index).isSelected();
    }

    public boolean isMultipleSelect() {
        return this.getSelectElement().isMultiple();
    }

    @Deprecated
    public void removeChangeListener(ChangeListener listener) {
        ListenerWrapper.WrappedChangeListener.remove(this, listener);
    }

    public void removeItem(int index) {
        this.checkIndex(index);
        this.getSelectElement().remove(index);
    }

    public void setItemSelected(int index, boolean selected) {
        this.checkIndex(index);
        this.getSelectElement().getOptions().getItem(index).setSelected(selected);
    }

    public void setItemText(int index, String text) {
        this.checkIndex(index);
        if (text == null) {
            throw new NullPointerException("Cannot set an option to have null text");
        }
        this.getSelectElement().getOptions().getItem(index).setText(text);
    }

    public void setMultipleSelect(boolean multiple) {
        this.getSelectElement().setMultiple(multiple);
    }

    public void setName(String name) {
        this.getSelectElement().setName(name);
    }

    public void setSelectedIndex(int index) {
        this.getSelectElement().setSelectedIndex(index);
    }

    public void setValue(int index, String value) {
        this.checkIndex(index);
        this.getSelectElement().getOptions().getItem(index).setValue(value);
    }

    public void setVisibleItemCount(int visibleItems) {
        this.getSelectElement().setSize(visibleItems);
    }

    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        int numItems = this.getItemCount();
        for (int i = 0; i < numItems; ++i) {
            ListBox.ensureDebugId(this.getSelectElement().getOptions().getItem(i), baseID, "item" + i);
        }
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.getItemCount()) {
            throw new IndexOutOfBoundsException();
        }
    }

    private SelectElement getSelectElement() {
        return (SelectElement)this.getElement().cast();
    }
}

