/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc.impl;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardSerializationPolicy
extends SerializationPolicy {
    private final Map<Class<?>, Boolean> whitelist;

    public StandardSerializationPolicy(Map<Class<?>, Boolean> whitelist) {
        if (whitelist == null) {
            throw new NullPointerException("whitelist");
        }
        this.whitelist = whitelist;
    }

    @Override
    public boolean shouldDeserializeFields(Class<?> clazz) {
        return this.isFieldSerializable(clazz);
    }

    @Override
    public boolean shouldSerializeFields(Class<?> clazz) {
        return this.isFieldSerializable(clazz);
    }

    @Override
    public void validateDeserialize(Class<?> clazz) throws SerializationException {
        if (!this.isInstantiable(clazz)) {
            throw new SerializationException("Type '" + clazz.getName() + "' was not included in the set of types which can be deserialized by this SerializationPolicy or its Class object could not be loaded. For security purposes, this type will not be deserialized.");
        }
    }

    @Override
    public void validateSerialize(Class<?> clazz) throws SerializationException {
        if (!this.isInstantiable(clazz)) {
            throw new SerializationException("Type '" + clazz.getName() + "' was not included in the set of types which can be serialized by this SerializationPolicy or its Class object could not be loaded. For security purposes, this type will not be serialized.");
        }
    }

    private boolean isFieldSerializable(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        return this.whitelist.containsKey(clazz);
    }

    private boolean isInstantiable(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        Boolean instantiable = this.whitelist.get(clazz);
        return instantiable != null && instantiable != false;
    }
}

