/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dom.client;

import com.google.gwt.core.client.JavaScriptObject;

public class Style
extends JavaScriptObject {
    private static final String BORDER_STYLE_SOLID = "solid";
    private static final String BORDER_STYLE_DASHED = "dashed";
    private static final String BORDER_STYLE_DOTTED = "dotted";
    private static final String BORDER_STYLE_HIDDEN = "hidden";
    private static final String BORDER_STYLE_NONE = "none";
    private static final String CURSOR_ROW_RESIZE = "row-resize";
    private static final String CURSOR_COL_RESIZE = "col-resize";
    private static final String CURSOR_HELP = "help";
    private static final String CURSOR_WAIT = "wait";
    private static final String CURSOR_TEXT = "text";
    private static final String CURSOR_W_RESIZE = "w-resize";
    private static final String CURSOR_S_RESIZE = "s-resize";
    private static final String CURSOR_SW_RESIZE = "sw-resize";
    private static final String CURSOR_SE_RESIZE = "se-resize";
    private static final String CURSOR_N_RESIZE = "n-resize";
    private static final String CURSOR_NW_RESIZE = "nw-resize";
    private static final String CURSOR_NE_RESIZE = "ne-resize";
    private static final String CURSOR_E_RESIZE = "e-resize";
    private static final String CURSOR_MOVE = "move";
    private static final String CURSOR_POINTER = "pointer";
    private static final String CURSOR_CROSSHAIR = "crosshair";
    private static final String CURSOR_AUTO = "auto";
    private static final String CURSOR_DEFAULT = "default";
    private static final String DISPLAY_INLINE_BLOCK = "inline-block";
    private static final String DISPLAY_INLINE = "inline";
    private static final String DISPLAY_BLOCK = "block";
    private static final String DISPLAY_NONE = "none";
    private static final String FONT_STYLE_OBLIQUE = "oblique";
    private static final String FONT_STYLE_ITALIC = "italic";
    private static final String FONT_STYLE_NORMAL = "normal";
    private static final String FONT_WEIGHT_LIGHTER = "lighter";
    private static final String FONT_WEIGHT_BOLDER = "bolder";
    private static final String FONT_WEIGHT_BOLD = "bold";
    private static final String FONT_WEIGHT_NORMAL = "normal";
    private static final String LIST_STYLE_TYPE_UPPER_ROMAN = "upper-roman";
    private static final String LIST_STYLE_TYPE_LOWER_ROMAN = "lower-roman";
    private static final String LIST_STYLE_TYPE_UPPER_ALPHA = "upper-alpha";
    private static final String LIST_STYLE_TYPE_LOWER_ALPHA = "lower-alpha";
    private static final String LIST_STYLE_TYPE_DECIMAL = "decimal";
    private static final String LIST_STYLE_TYPE_SQUARE = "square";
    private static final String LIST_STYLE_TYPE_CIRCLE = "circle";
    private static final String LIST_STYLE_TYPE_DISC = "disc";
    private static final String LIST_STYLE_TYPE_NONE = "none";
    private static final String OVERFLOW_AUTO = "auto";
    private static final String OVERFLOW_SCROLL = "scroll";
    private static final String OVERFLOW_HIDDEN = "hidden";
    private static final String OVERFLOW_VISIBLE = "visible";
    private static final String POSITION_FIXED = "fixed";
    private static final String POSITION_ABSOLUTE = "absolute";
    private static final String POSITION_RELATIVE = "relative";
    private static final String POSITION_STATIC = "static";
    private static final String STYLE_Z_INDEX = "zIndex";
    private static final String STYLE_WIDTH = "width";
    private static final String STYLE_VISIBILITY = "visibility";
    private static final String STYLE_TOP = "top";
    private static final String STYLE_TEXT_DECORATION = "textDecoration";
    private static final String STYLE_RIGHT = "right";
    private static final String STYLE_POSITION = "position";
    private static final String STYLE_PADDING_TOP = "paddingTop";
    private static final String STYLE_PADDING_RIGHT = "paddingRight";
    private static final String STYLE_PADDING_LEFT = "paddingLeft";
    private static final String STYLE_PADDING_BOTTOM = "paddingBottom";
    private static final String STYLE_PADDING = "padding";
    private static final String STYLE_OVERFLOW = "overflow";
    private static final String STYLE_OPACITY = "opacity";
    private static final String STYLE_MARGIN_TOP = "marginTop";
    private static final String STYLE_MARGIN_RIGHT = "marginRight";
    private static final String STYLE_MARGIN_LEFT = "marginLeft";
    private static final String STYLE_MARGIN_BOTTOM = "marginBottom";
    private static final String STYLE_MARGIN = "margin";
    private static final String STYLE_LIST_STYLE_TYPE = "listStyleType";
    private static final String STYLE_LEFT = "left";
    private static final String STYLE_HEIGHT = "height";
    private static final String STYLE_FONT_WEIGHT = "fontWeight";
    private static final String STYLE_FONT_STYLE = "fontStyle";
    private static final String STYLE_FONT_SIZE = "fontSize";
    private static final String STYLE_DISPLAY = "display";
    private static final String STYLE_CURSOR = "cursor";
    private static final String STYLE_COLOR = "color";
    private static final String STYLE_BOTTOM = "bottom";
    private static final String STYLE_BORDER_WIDTH = "borderWidth";
    private static final String STYLE_BORDER_STYLE = "borderStyle";
    private static final String STYLE_BORDER_COLOR = "borderColor";
    private static final String STYLE_BACKGROUND_IMAGE = "backgroundImage";
    private static final String STYLE_BACKGROUND_COLOR = "backgroundColor";
    private static final String STYLE_VERTICAL_ALIGN = "verticalAlign";
    private static final String TEXT_DECORATION_LINE_THROUGH = "line-through";
    private static final String TEXT_DECORATION_OVERLINE = "overline";
    private static final String TEXT_DECORATION_UNDERLINE = "underline";
    private static final String TEXT_DECORATION_NONE = "none";
    private static final String UNIT_MM = "mm";
    private static final String UNIT_CM = "cm";
    private static final String UNIT_IN = "in";
    private static final String UNIT_PC = "pc";
    private static final String UNIT_PT = "pt";
    private static final String UNIT_EX = "ex";
    private static final String UNIT_EM = "em";
    private static final String UNIT_PCT = "%";
    private static final String UNIT_PX = "px";
    private static final String VERTICAL_ALIGN_BASELINE = "baseline";
    private static final String VERTICAL_ALIGN_SUB = "sub";
    private static final String VERTICAL_ALIGN_SUPER = "super";
    private static final String VERTICAL_ALIGN_TOP = "top";
    private static final String VERTICAL_ALIGN_TEXT_TOP = "text-top";
    private static final String VERTICAL_ALIGN_MIDDLE = "middle";
    private static final String VERTICAL_ALIGN_BOTTOM = "bottom";
    private static final String VERTICAL_ALIGN_TEXT_BOTTOM = "text-bottom";
    private static final String VISIBILITY_HIDDEN = "hidden";
    private static final String VISIBILITY_VISIBLE = "visible";

    protected Style() {
    }

    public final void clearBackgroundColor() {
        this.clearProperty(STYLE_BACKGROUND_COLOR);
    }

    public final void clearBackgroundImage() {
        this.clearProperty(STYLE_BACKGROUND_IMAGE);
    }

    public final void clearBorderColor() {
        this.clearProperty(STYLE_BORDER_COLOR);
    }

    public final void clearBorderStyle() {
        this.clearProperty(STYLE_BORDER_STYLE);
    }

    public final void clearBorderWidth() {
        this.clearProperty(STYLE_BORDER_WIDTH);
    }

    public final void clearBottom() {
        this.clearProperty("bottom");
    }

    public final void clearColor() {
        this.clearProperty(STYLE_COLOR);
    }

    public final void clearCursor() {
        this.clearProperty(STYLE_CURSOR);
    }

    public final void clearDisplay() {
        this.clearProperty(STYLE_DISPLAY);
    }

    public final void clearFontSize() {
        this.clearProperty(STYLE_FONT_SIZE);
    }

    public final void clearFontStyle() {
        this.clearProperty(STYLE_FONT_STYLE);
    }

    public final void clearFontWeight() {
        this.clearProperty(STYLE_FONT_WEIGHT);
    }

    public final void clearHeight() {
        this.clearProperty(STYLE_HEIGHT);
    }

    public final void clearLeft() {
        this.clearProperty(STYLE_LEFT);
    }

    public final void clearListStyleType() {
        this.clearProperty(STYLE_LIST_STYLE_TYPE);
    }

    public final void clearMargin() {
        this.clearProperty(STYLE_MARGIN);
    }

    public final void clearMarginBottom() {
        this.clearProperty(STYLE_MARGIN_BOTTOM);
    }

    public final void clearMarginLeft() {
        this.clearProperty(STYLE_MARGIN_LEFT);
    }

    public final void clearMarginRight() {
        this.clearProperty(STYLE_MARGIN_RIGHT);
    }

    public final void clearMarginTop() {
        this.clearProperty(STYLE_MARGIN_TOP);
    }

    public final void clearOpacity() {
        this.clearProperty(STYLE_OPACITY);
    }

    public final void clearOverflow() {
        this.clearProperty(STYLE_OVERFLOW);
    }

    public final void clearPadding() {
        this.clearProperty(STYLE_PADDING);
    }

    public final void clearPaddingBottom() {
        this.clearProperty(STYLE_PADDING_BOTTOM);
    }

    public final void clearPaddingLeft() {
        this.clearProperty(STYLE_PADDING_LEFT);
    }

    public final void clearPaddingRight() {
        this.clearProperty(STYLE_PADDING_RIGHT);
    }

    public final void clearPaddingTop() {
        this.clearProperty(STYLE_PADDING_TOP);
    }

    public final void clearPosition() {
        this.clearProperty(STYLE_POSITION);
    }

    public final void clearProperty(String name) {
        this.setProperty(name, "");
    }

    public final void clearRight() {
        this.clearProperty(STYLE_RIGHT);
    }

    public final void clearTextDecoration() {
        this.clearProperty(STYLE_TEXT_DECORATION);
    }

    public final void clearTop() {
        this.clearProperty("top");
    }

    public final void clearVisibility() {
        this.clearProperty(STYLE_VISIBILITY);
    }

    public final void clearWidth() {
        this.clearProperty(STYLE_WIDTH);
    }

    public final void clearZIndex() {
        this.clearProperty(STYLE_Z_INDEX);
    }

    public final String getBackgroundColor() {
        return this.getProperty(STYLE_BACKGROUND_COLOR);
    }

    public final String getBackgroundImage() {
        return this.getProperty(STYLE_BACKGROUND_IMAGE);
    }

    public final String getBorderColor() {
        return this.getProperty(STYLE_BORDER_COLOR);
    }

    public final String getBorderStyle() {
        return this.getProperty(STYLE_BORDER_STYLE);
    }

    public final String getBorderWidth() {
        return this.getProperty(STYLE_BORDER_WIDTH);
    }

    public final String getBottom() {
        return this.getProperty("bottom");
    }

    public final String getColor() {
        return this.getProperty(STYLE_COLOR);
    }

    public final String getCursor() {
        return this.getProperty(STYLE_CURSOR);
    }

    public final String getDisplay() {
        return this.getProperty(STYLE_DISPLAY);
    }

    public final String getFontSize() {
        return this.getProperty(STYLE_FONT_SIZE);
    }

    public final String getFontStyle() {
        return this.getProperty(STYLE_FONT_STYLE);
    }

    public final String getFontWeight() {
        return this.getProperty(STYLE_FONT_WEIGHT);
    }

    public final String getHeight() {
        return this.getProperty(STYLE_HEIGHT);
    }

    public final String getLeft() {
        return this.getProperty(STYLE_LEFT);
    }

    public final String getListStyleType() {
        return this.getProperty(STYLE_LIST_STYLE_TYPE);
    }

    public final String getMargin() {
        return this.getProperty(STYLE_MARGIN);
    }

    public final String getMarginBottom() {
        return this.getProperty(STYLE_MARGIN_BOTTOM);
    }

    public final String getMarginLeft() {
        return this.getProperty(STYLE_MARGIN_LEFT);
    }

    public final String getMarginRight() {
        return this.getProperty(STYLE_MARGIN_RIGHT);
    }

    public final String getMarginTop() {
        return this.getProperty(STYLE_MARGIN_TOP);
    }

    public final String getOpacity() {
        return this.getProperty(STYLE_OPACITY);
    }

    public final String getOverflow() {
        return this.getProperty(STYLE_OVERFLOW);
    }

    public final String getPadding() {
        return this.getProperty(STYLE_PADDING);
    }

    public final String getPaddingBottom() {
        return this.getProperty(STYLE_PADDING_BOTTOM);
    }

    public final String getPaddingLeft() {
        return this.getProperty(STYLE_PADDING_LEFT);
    }

    public final String getPaddingRight() {
        return this.getProperty(STYLE_PADDING_RIGHT);
    }

    public final String getPaddingTop() {
        return this.getProperty(STYLE_PADDING_TOP);
    }

    public final String getPosition() {
        return this.getProperty(STYLE_POSITION);
    }

    public final String getProperty(String name) {
        this.assertCamelCase(name);
        return this.getPropertyImpl(name);
    }

    public final String getRight() {
        return this.getProperty(STYLE_RIGHT);
    }

    public final String getTextDecoration() {
        return this.getProperty(STYLE_TEXT_DECORATION);
    }

    public final String getTop() {
        return this.getProperty("top");
    }

    public final String getVerticalAlign() {
        return this.getProperty(STYLE_VERTICAL_ALIGN);
    }

    public final String getVisibility() {
        return this.getProperty(STYLE_VISIBILITY);
    }

    public final String getWidth() {
        return this.getProperty(STYLE_WIDTH);
    }

    public final String getZIndex() {
        return this.getProperty(STYLE_Z_INDEX);
    }

    public final void setBackgroundColor(String value) {
        this.setProperty(STYLE_BACKGROUND_COLOR, value);
    }

    public final void setBackgroundImage(String value) {
        this.setProperty(STYLE_BACKGROUND_IMAGE, value);
    }

    public final void setBorderColor(String value) {
        this.setProperty(STYLE_BORDER_COLOR, value);
    }

    public final void setBorderStyle(BorderStyle value) {
        this.setProperty(STYLE_BORDER_STYLE, value.getCssName());
    }

    public final void setBorderWidth(double value, Unit unit) {
        this.setProperty(STYLE_BORDER_WIDTH, value, unit);
    }

    public final void setBottom(double value, Unit unit) {
        this.setProperty("bottom", value, unit);
    }

    public final void setColor(String value) {
        this.setProperty(STYLE_COLOR, value);
    }

    public final void setCursor(Cursor value) {
        this.setProperty(STYLE_CURSOR, value.getCssName());
    }

    public final void setDisplay(Display value) {
        this.setProperty(STYLE_DISPLAY, value.getCssName());
    }

    public final void setFontSize(double value, Unit unit) {
        this.setProperty(STYLE_FONT_SIZE, value, unit);
    }

    public final void setFontStyle(FontStyle value) {
        this.setProperty(STYLE_FONT_STYLE, value.getCssName());
    }

    public final void setFontWeight(FontWeight value) {
        this.setProperty(STYLE_FONT_WEIGHT, value.getCssName());
    }

    public final void setHeight(double value, Unit unit) {
        this.setProperty(STYLE_HEIGHT, value, unit);
    }

    public final void setLeft(double value, Unit unit) {
        this.setProperty(STYLE_LEFT, value, unit);
    }

    public final void setListStyleType(ListStyleType value) {
        this.setProperty(STYLE_LIST_STYLE_TYPE, value.getCssName());
    }

    public final void setMargin(double value, Unit unit) {
        this.setProperty(STYLE_MARGIN, value, unit);
    }

    public final void setMarginBottom(double value, Unit unit) {
        this.setProperty(STYLE_MARGIN_BOTTOM, value, unit);
    }

    public final void setMarginLeft(double value, Unit unit) {
        this.setProperty(STYLE_MARGIN_LEFT, value, unit);
    }

    public final void setMarginRight(double value, Unit unit) {
        this.setProperty(STYLE_MARGIN_RIGHT, value, unit);
    }

    public final void setMarginTop(double value, Unit unit) {
        this.setProperty(STYLE_MARGIN_TOP, value, unit);
    }

    public final void setOpacity(double value) {
        this.setProperty(STYLE_OPACITY, value + "");
    }

    public final void setOverflow(Overflow value) {
        this.setProperty(STYLE_OVERFLOW, value.getCssName());
    }

    public final void setPadding(double value, Unit unit) {
        this.setProperty(STYLE_PADDING, value, unit);
    }

    public final void setPaddingBottom(double value, Unit unit) {
        this.setProperty(STYLE_PADDING_BOTTOM, value, unit);
    }

    public final void setPaddingLeft(double value, Unit unit) {
        this.setProperty(STYLE_PADDING_LEFT, value, unit);
    }

    public final void setPaddingRight(double value, Unit unit) {
        this.setProperty(STYLE_PADDING_RIGHT, value, unit);
    }

    public final void setPaddingTop(double value, Unit unit) {
        this.setProperty(STYLE_PADDING_TOP, value, unit);
    }

    public final void setPosition(Position value) {
        this.setProperty(STYLE_POSITION, value.getCssName());
    }

    public final void setProperty(String name, String value) {
        this.assertCamelCase(name);
        this.setPropertyImpl(name, value);
    }

    public final void setProperty(String name, double value, Unit unit) {
        this.assertCamelCase(name);
        this.setPropertyImpl(name, value + unit.getType());
    }

    public final void setPropertyPx(String name, int value) {
        this.setProperty(name, value, Unit.PX);
    }

    public final void setRight(double value, Unit unit) {
        this.setProperty(STYLE_RIGHT, value, unit);
    }

    public final void setTextDecoration(TextDecoration value) {
        this.setProperty(STYLE_TEXT_DECORATION, value.getCssName());
    }

    public final void setTop(double value, Unit unit) {
        this.setProperty("top", value, unit);
    }

    public final void setVerticalAlign(VerticalAlign value) {
        this.setProperty(STYLE_VERTICAL_ALIGN, value.getCssName());
    }

    public final void setVerticalAlign(double value, Unit unit) {
        this.setProperty(STYLE_VERTICAL_ALIGN, value, unit);
    }

    public final void setVisibility(Visibility value) {
        this.setProperty(STYLE_VISIBILITY, value.getCssName());
    }

    public final void setWidth(double value, Unit unit) {
        this.setProperty(STYLE_WIDTH, value, unit);
    }

    public final void setZIndex(int value) {
        this.setProperty(STYLE_Z_INDEX, value + "");
    }

    private void assertCamelCase(String name) {
        assert (!name.contains("-")) : "The style name '" + name + "' should be in camelCase format";
    }

    private native String getPropertyImpl(String var1);

    private native void setPropertyImpl(String var1, String var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Visibility implements HasCssName
    {
        VISIBLE{

            public String getCssName() {
                return "visible";
            }
        }
        ,
        HIDDEN{

            public String getCssName() {
                return "hidden";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VerticalAlign implements HasCssName
    {
        BASELINE{

            public String getCssName() {
                return Style.VERTICAL_ALIGN_BASELINE;
            }
        }
        ,
        SUB{

            public String getCssName() {
                return Style.VERTICAL_ALIGN_SUB;
            }
        }
        ,
        SUPER{

            public String getCssName() {
                return Style.VERTICAL_ALIGN_SUPER;
            }
        }
        ,
        TOP{

            public String getCssName() {
                return "top";
            }
        }
        ,
        TEXT_TOP{

            public String getCssName() {
                return Style.VERTICAL_ALIGN_TEXT_TOP;
            }
        }
        ,
        MIDDLE{

            public String getCssName() {
                return Style.VERTICAL_ALIGN_MIDDLE;
            }
        }
        ,
        BOTTOM{

            public String getCssName() {
                return "bottom";
            }
        }
        ,
        TEXT_BOTTOM{

            public String getCssName() {
                return Style.VERTICAL_ALIGN_TEXT_BOTTOM;
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextDecoration implements HasCssName
    {
        NONE{

            public String getCssName() {
                return "none";
            }
        }
        ,
        UNDERLINE{

            public String getCssName() {
                return Style.TEXT_DECORATION_UNDERLINE;
            }
        }
        ,
        OVERLINE{

            public String getCssName() {
                return Style.TEXT_DECORATION_OVERLINE;
            }
        }
        ,
        LINE_THROUGH{

            public String getCssName() {
                return Style.TEXT_DECORATION_LINE_THROUGH;
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Position implements HasCssName
    {
        STATIC{

            public String getCssName() {
                return Style.POSITION_STATIC;
            }
        }
        ,
        RELATIVE{

            public String getCssName() {
                return Style.POSITION_RELATIVE;
            }
        }
        ,
        ABSOLUTE{

            public String getCssName() {
                return Style.POSITION_ABSOLUTE;
            }
        }
        ,
        FIXED{

            public String getCssName() {
                return Style.POSITION_FIXED;
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Overflow implements HasCssName
    {
        VISIBLE{

            public String getCssName() {
                return "visible";
            }
        }
        ,
        HIDDEN{

            public String getCssName() {
                return "hidden";
            }
        }
        ,
        SCROLL{

            public String getCssName() {
                return Style.OVERFLOW_SCROLL;
            }
        }
        ,
        AUTO{

            public String getCssName() {
                return "auto";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ListStyleType implements HasCssName
    {
        NONE{

            public String getCssName() {
                return "none";
            }
        }
        ,
        DISC{

            public String getCssName() {
                return Style.LIST_STYLE_TYPE_DISC;
            }
        }
        ,
        CIRCLE{

            public String getCssName() {
                return Style.LIST_STYLE_TYPE_CIRCLE;
            }
        }
        ,
        SQUARE{

            public String getCssName() {
                return Style.LIST_STYLE_TYPE_SQUARE;
            }
        }
        ,
        DECIMAL{

            public String getCssName() {
                return Style.LIST_STYLE_TYPE_DECIMAL;
            }
        }
        ,
        LOWER_ALPHA{

            public String getCssName() {
                return Style.LIST_STYLE_TYPE_LOWER_ALPHA;
            }
        }
        ,
        UPPER_ALPHA{

            public String getCssName() {
                return Style.LIST_STYLE_TYPE_UPPER_ALPHA;
            }
        }
        ,
        LOWER_ROMAN{

            public String getCssName() {
                return Style.LIST_STYLE_TYPE_LOWER_ROMAN;
            }
        }
        ,
        UPPER_ROMAN{

            public String getCssName() {
                return Style.LIST_STYLE_TYPE_UPPER_ROMAN;
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FontWeight implements HasCssName
    {
        NORMAL{

            public String getCssName() {
                return "normal";
            }
        }
        ,
        BOLD{

            public String getCssName() {
                return Style.FONT_WEIGHT_BOLD;
            }
        }
        ,
        BOLDER{

            public String getCssName() {
                return Style.FONT_WEIGHT_BOLDER;
            }
        }
        ,
        LIGHTER{

            public String getCssName() {
                return Style.FONT_WEIGHT_LIGHTER;
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FontStyle implements HasCssName
    {
        NORMAL{

            public String getCssName() {
                return "normal";
            }
        }
        ,
        ITALIC{

            public String getCssName() {
                return Style.FONT_STYLE_ITALIC;
            }
        }
        ,
        OBLIQUE{

            public String getCssName() {
                return Style.FONT_STYLE_OBLIQUE;
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Display implements HasCssName
    {
        NONE{

            public String getCssName() {
                return "none";
            }
        }
        ,
        BLOCK{

            public String getCssName() {
                return Style.DISPLAY_BLOCK;
            }
        }
        ,
        INLINE{

            public String getCssName() {
                return Style.DISPLAY_INLINE;
            }
        }
        ,
        INLINE_BLOCK{

            public String getCssName() {
                return Style.DISPLAY_INLINE_BLOCK;
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Cursor implements HasCssName
    {
        DEFAULT{

            public String getCssName() {
                return Style.CURSOR_DEFAULT;
            }
        }
        ,
        AUTO{

            public String getCssName() {
                return "auto";
            }
        }
        ,
        CROSSHAIR{

            public String getCssName() {
                return Style.CURSOR_CROSSHAIR;
            }
        }
        ,
        POINTER{

            public String getCssName() {
                return Style.CURSOR_POINTER;
            }
        }
        ,
        MOVE{

            public String getCssName() {
                return Style.CURSOR_MOVE;
            }
        }
        ,
        E_RESIZE{

            public String getCssName() {
                return Style.CURSOR_E_RESIZE;
            }
        }
        ,
        NE_RESIZE{

            public String getCssName() {
                return Style.CURSOR_NE_RESIZE;
            }
        }
        ,
        NW_RESIZE{

            public String getCssName() {
                return Style.CURSOR_NW_RESIZE;
            }
        }
        ,
        N_RESIZE{

            public String getCssName() {
                return Style.CURSOR_N_RESIZE;
            }
        }
        ,
        SE_RESIZE{

            public String getCssName() {
                return Style.CURSOR_SE_RESIZE;
            }
        }
        ,
        SW_RESIZE{

            public String getCssName() {
                return Style.CURSOR_SW_RESIZE;
            }
        }
        ,
        S_RESIZE{

            public String getCssName() {
                return Style.CURSOR_S_RESIZE;
            }
        }
        ,
        W_RESIZE{

            public String getCssName() {
                return Style.CURSOR_W_RESIZE;
            }
        }
        ,
        TEXT{

            public String getCssName() {
                return Style.CURSOR_TEXT;
            }
        }
        ,
        WAIT{

            public String getCssName() {
                return Style.CURSOR_WAIT;
            }
        }
        ,
        HELP{

            public String getCssName() {
                return Style.CURSOR_HELP;
            }
        }
        ,
        COL_RESIZE{

            public String getCssName() {
                return Style.CURSOR_COL_RESIZE;
            }
        }
        ,
        ROW_RESIZE{

            public String getCssName() {
                return Style.CURSOR_ROW_RESIZE;
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BorderStyle implements HasCssName
    {
        NONE{

            public String getCssName() {
                return "none";
            }
        }
        ,
        DOTTED{

            public String getCssName() {
                return Style.BORDER_STYLE_DOTTED;
            }
        }
        ,
        DASHED{

            public String getCssName() {
                return Style.BORDER_STYLE_DASHED;
            }
        }
        ,
        SOLID{

            public String getCssName() {
                return Style.BORDER_STYLE_SOLID;
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Unit {
        PX{

            public String getType() {
                return Style.UNIT_PX;
            }
        }
        ,
        PCT{

            public String getType() {
                return Style.UNIT_PCT;
            }
        }
        ,
        EM{

            public String getType() {
                return Style.UNIT_EM;
            }
        }
        ,
        EX{

            public String getType() {
                return Style.UNIT_EX;
            }
        }
        ,
        PT{

            public String getType() {
                return Style.UNIT_PT;
            }
        }
        ,
        PC{

            public String getType() {
                return Style.UNIT_PC;
            }
        }
        ,
        IN{

            public String getType() {
                return Style.UNIT_IN;
            }
        }
        ,
        CM{

            public String getType() {
                return Style.UNIT_CM;
            }
        }
        ,
        MM{

            public String getType() {
                return Style.UNIT_MM;
            }
        };


        public abstract String getType();
    }

    public static interface HasCssName {
        public String getCssName();
    }
}

