/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.rpc.client.impl;

import com.google.gwt.rpc.client.ast.ArrayValueCommand;
import com.google.gwt.rpc.client.ast.BooleanValueCommand;
import com.google.gwt.rpc.client.ast.CharValueCommand;
import com.google.gwt.rpc.client.ast.CommandSink;
import com.google.gwt.rpc.client.ast.DoubleValueCommand;
import com.google.gwt.rpc.client.ast.EnumValueCommand;
import com.google.gwt.rpc.client.ast.HasSetters;
import com.google.gwt.rpc.client.ast.IdentityValueCommand;
import com.google.gwt.rpc.client.ast.InstantiateCommand;
import com.google.gwt.rpc.client.ast.InvokeCustomFieldSerializerCommand;
import com.google.gwt.rpc.client.ast.LongValueCommand;
import com.google.gwt.rpc.client.ast.NullValueCommand;
import com.google.gwt.rpc.client.ast.StringValueCommand;
import com.google.gwt.rpc.client.ast.ValueCommand;
import com.google.gwt.rpc.client.impl.CommandSerializationStreamWriterBase;
import com.google.gwt.rpc.client.impl.HasValuesCommandSink;
import com.google.gwt.rpc.client.impl.TypeOverrides;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.rpc.SerializationException;
import java.io.Serializable;
import java.util.IdentityHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandClientSerializationStreamWriter
extends CommandSerializationStreamWriterBase {
    private static Object anObject = new Object[0];
    private final Map<Object, IdentityValueCommand> identityMap = new IdentityHashMap<Object, IdentityValueCommand>();
    private final TypeOverrides serializer;

    public CommandClientSerializationStreamWriter(TypeOverrides serializer, CommandSink sink) {
        super(sink);
        this.serializer = serializer;
    }

    @Override
    protected ValueCommand makeValue(Class<?> type, Object value) throws SerializationException {
        ValueCommand toReturn;
        if (value == null) {
            toReturn = NullValueCommand.INSTANCE;
        } else if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                toReturn = new BooleanValueCommand((Boolean)value);
            } else if (type == Void.TYPE) {
                toReturn = NullValueCommand.INSTANCE;
            } else if (type == Long.TYPE) {
                toReturn = new LongValueCommand((Long)value);
            } else if (type == Character.TYPE) {
                toReturn = new CharValueCommand((Character)value);
            } else {
                assert (value instanceof Number) : "Expecting Number; had " + value.getClass().getName();
                toReturn = new DoubleValueCommand(((Number)value).doubleValue());
            }
        } else {
            toReturn = this.identityMap.get(value);
            if (toReturn == null) {
                if (type == String.class) {
                    toReturn = new StringValueCommand((String)value);
                } else if (type.isArray()) {
                    ArrayValueCommand array = new ArrayValueCommand(type.getComponentType());
                    this.identityMap.put(value, array);
                    this.extractData(array, value);
                    toReturn = array;
                } else if (value instanceof Enum) {
                    EnumValueCommand e = new EnumValueCommand();
                    e.setValue((Enum)value);
                    toReturn = e;
                } else {
                    TypeOverrides.SerializeFunction customSerializer = this.serializer.getOverride(type.getName());
                    toReturn = customSerializer != null ? this.invokeCustomSerializer(customSerializer, type, value) : this.makeObject(type, value);
                }
            }
        }
        return toReturn;
    }

    private native void extractData(ArrayValueCommand var1, Object var2);

    private native void extractData(HasSetters var1, Object var2);

    private native void extractField(HasSetters var1, Object var2, String var3);

    private ValueCommand invokeCustomSerializer(TypeOverrides.SerializeFunction serializeFunction, Class<?> type, Object value) throws SerializationException {
        InvokeCustomFieldSerializerCommand command = new InvokeCustomFieldSerializerCommand(type, null, null);
        this.identityMap.put(value, command);
        CommandClientSerializationStreamWriter subWriter = new CommandClientSerializationStreamWriter(this.serializer, new HasValuesCommandSink(command));
        serializeFunction.serialize(subWriter, value);
        if (this.serializer.hasExtraFields(type.getName())) {
            for (String extraField : this.serializer.getExtraFields(type.getName())) {
                if (extraField == null) continue;
                this.extractField(command, value, extraField);
            }
        }
        return command;
    }

    private ValueCommand makeObject(Class<?> clazz, Object value) throws SerializationException {
        if (!(value instanceof Serializable) && !(value instanceof IsSerializable)) {
            throw new SerializationException(clazz.getName() + " is not a Serializable type");
        }
        InstantiateCommand x = new InstantiateCommand(clazz);
        this.identityMap.put(value, x);
        if (this.serializer.hasExtraFields(clazz.getName())) {
            for (String fieldName : this.serializer.getExtraFields(clazz.getName())) {
                this.extractField(x, value, fieldName);
            }
        } else {
            this.extractData(x, value);
        }
        return x;
    }

    private native ValueCommand makeValue(Object var1);

    static {
        anObject.hashCode();
    }
}

