/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.parsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.uibinder.parsers.ElementParser;
import com.google.gwt.uibinder.parsers.HtmlInterpreter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;

public class TabPanelParser
implements ElementParser {
    private static final String TAG_TAB = "Tab";
    private static final String TAG_TABHTML = "TabHTML";

    public void parse(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        for (XMLElement child : elem.consumeChildElements()) {
            String ns = child.getNamespaceUri();
            String tagName = child.getLocalName();
            if (!ns.equals(elem.getNamespaceUri())) {
                writer.die("Invalid TabPanel child namespace: " + ns);
            }
            if (!tagName.equals(TAG_TAB)) {
                writer.die("Invalid TabPanel child element: " + tagName);
            }
            String tabCaption = "";
            if (child.hasAttribute("text")) {
                tabCaption = child.consumeAttribute("text");
            }
            String tabHTML = null;
            String childFieldName = null;
            for (XMLElement tabChild : child.consumeChildElements()) {
                if (tabChild.getLocalName().equals(TAG_TABHTML)) {
                    HtmlInterpreter interpreter = HtmlInterpreter.newInterpreterForUiObject(writer, fieldName);
                    tabHTML = tabChild.consumeInnerHtml((XMLElement.Interpreter)interpreter);
                    continue;
                }
                if (childFieldName != null) {
                    writer.die("gwt:Tab may only have a single child widget");
                }
                childFieldName = writer.parseElementToField(tabChild);
            }
            if (tabHTML != null) {
                writer.addStatement("%1$s.add(%2$s, \"%3$s\", true);", new Object[]{fieldName, childFieldName, tabHTML});
                continue;
            }
            writer.addStatement("%1$s.add(%2$s, \"%3$s\");", new Object[]{fieldName, childFieldName, tabCaption});
        }
    }
}

