/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.datepicker.client;

import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.impl.ElementMapperImpl;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.UIObject;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CellGridImpl<V>
extends Grid {
    private Cell highlightedCell;
    private Cell selectedCell;
    private ElementMapperImpl<Cell> elementToCell = new ElementMapperImpl();
    private ArrayList<Cell> cellList = new ArrayList();

    protected CellGridImpl() {
        this.setCellPadding(0);
        this.setCellSpacing(0);
        this.setBorderWidth(0);
        this.sinkEvents(49);
    }

    public Cell getCell(com.google.gwt.dom.client.Element element) {
        return this.elementToCell.get((Element)element);
    }

    public Cell getCell(Event e) {
        Element td = this.getEventTargetCell(e);
        return td != null ? this.elementToCell.get(td) : null;
    }

    public Cell getCell(int i) {
        return this.cellList.get(i);
    }

    public Iterator getCells() {
        return this.cellList.iterator();
    }

    public Cell getHighlightedCell() {
        return this.highlightedCell;
    }

    public int getNumCells() {
        return this.cellList.size();
    }

    public Cell getSelectedCell() {
        return this.selectedCell;
    }

    public V getSelectedValue() {
        return this.getValue(this.selectedCell);
    }

    public V getValue(Cell cell) {
        return cell == null ? null : (V)cell.getValue();
    }

    @Override
    public void onBrowserEvent(Event event) {
        switch (DOM.eventGetType(event)) {
            case 1: {
                Cell cell = this.getCell(event);
                if (!this.isActive(cell)) break;
                this.setSelected(cell);
                break;
            }
            case 32: {
                Cell cell;
                Element e = DOM.eventGetFromElement(event);
                if (e == null || (cell = this.elementToCell.get(e)) != this.highlightedCell) break;
                this.setHighlighted(null);
                break;
            }
            case 16: {
                Cell cell;
                Element e = DOM.eventGetToElement(event);
                if (e == null || !this.isActive(cell = this.elementToCell.get(e))) break;
                this.setHighlighted(cell);
                break;
            }
        }
    }

    @Override
    public void onUnload() {
        this.setHighlighted(null);
    }

    public final void setHighlighted(Cell nextHighlighted) {
        if (nextHighlighted == this.highlightedCell) {
            return;
        }
        Cell oldHighlighted = this.highlightedCell;
        this.highlightedCell = nextHighlighted;
        if (oldHighlighted != null) {
            oldHighlighted.onHighlighted(false);
        }
        if (this.highlightedCell != null) {
            this.highlightedCell.onHighlighted(true);
        }
    }

    public final void setSelected(Cell cell) {
        Cell last = this.getSelectedCell();
        this.selectedCell = cell;
        if (last != null) {
            last.onSelected(false);
        }
        if (this.selectedCell != null) {
            this.selectedCell.onSelected(true);
        }
        this.onSelected(last, this.selectedCell);
    }

    protected void onKeyDown(Cell lastHighlighted, KeyDownEvent event) {
        if (event.isAnyModifierKeyDown()) {
            return;
        }
        int keyCode = event.getNativeKeyCode();
        if (lastHighlighted == null) {
            if (keyCode == 40 && this.cellList.size() > 0) {
                this.setHighlighted(this.cellList.get(0));
            }
        } else {
            lastHighlighted.verticalNavigation(keyCode);
        }
    }

    protected abstract void onSelected(Cell var1, Cell var2);

    private boolean isActive(Cell cell) {
        return cell != null && cell.isEnabled();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Cell
    extends UIObject {
        private boolean enabled = true;
        private V value;
        private int index;

        public Cell(com.google.gwt.dom.client.Element elem, V value) {
            this.value = value;
            Cell current = this;
            this.index = CellGridImpl.this.cellList.size();
            CellGridImpl.this.cellList.add(current);
            this.setElement(elem);
            CellGridImpl.this.elementToCell.put(current);
        }

        public V getValue() {
            return this.value;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isHighlighted() {
            return this == CellGridImpl.this.highlightedCell;
        }

        public boolean isSelected() {
            return CellGridImpl.this.selectedCell == this;
        }

        public final void setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.onEnabled(enabled);
        }

        public void verticalNavigation(int keyCode) {
            switch (keyCode) {
                case 38: {
                    CellGridImpl.this.setHighlighted(this.previousItem());
                    break;
                }
                case 40: {
                    CellGridImpl.this.setHighlighted(this.nextItem());
                    break;
                }
                case 27: {
                    break;
                }
                case 13: {
                    CellGridImpl.this.setSelected(this);
                }
            }
        }

        protected Cell nextItem() {
            if (this.index == this.getLastIndex()) {
                return (Cell)CellGridImpl.this.cellList.get(0);
            }
            return (Cell)CellGridImpl.this.cellList.get(this.index + 1);
        }

        protected void onEnabled(boolean enabled) {
            this.updateStyle();
        }

        protected void onHighlighted(boolean highlighted) {
            this.updateStyle();
        }

        protected void onSelected(boolean selected) {
            this.updateStyle();
        }

        protected Cell previousItem() {
            if (this.index != 0) {
                return (Cell)CellGridImpl.this.cellList.get(this.index - 1);
            }
            return (Cell)CellGridImpl.this.cellList.get(this.getLastIndex());
        }

        protected abstract void updateStyle();

        private int getLastIndex() {
            return CellGridImpl.this.cellList.size() - 1;
        }
    }
}

