/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dom.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.core.client.JsArrayInteger;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.HeadElement;
import com.google.gwt.dom.client.StyleElement;

public class StyleInjector {
    public static StyleElement injectStylesheet(String contents) {
        return StyleInjectorImpl.IMPL.injectStyleSheet(contents);
    }

    public static StyleElement injectStylesheetAtEnd(String contents) {
        return StyleInjectorImpl.IMPL.injectStyleSheetAtEnd(contents);
    }

    public static StyleElement injectStylesheetAtStart(String contents) {
        return StyleInjectorImpl.IMPL.injectStyleSheetAtStart(contents);
    }

    public static void setContents(StyleElement style, String contents) {
        StyleInjectorImpl.IMPL.setContents(style, contents);
    }

    private StyleInjector() {
    }

    public static class StyleInjectorImplIE
    extends StyleInjectorImpl {
        private static final int MAX_STYLE_SHEETS = 30;
        private static final JsArray<StyleElement> STYLE_ELEMENTS = (JsArray)JavaScriptObject.createArray().cast();
        private static final JsArrayInteger STYLE_ELEMENT_LENGTHS = (JsArrayInteger)JavaScriptObject.createArray().cast();

        public native void appendContents(StyleElement var1, String var2);

        public StyleElement injectStyleSheet(String contents) {
            int idx = STYLE_ELEMENTS.length();
            if (this.getDocumentStyleCount() < 30) {
                StyleElement style = this.createElement();
                this.setContents(style, contents);
                STYLE_ELEMENTS.set(idx, style);
                STYLE_ELEMENT_LENGTHS.set(idx, contents.length());
                return style;
            }
            int shortestLen = Integer.MAX_VALUE;
            int shortestIdx = -1;
            for (int i = 0; i < idx; ++i) {
                if (STYLE_ELEMENT_LENGTHS.get(i) >= shortestLen) continue;
                shortestLen = STYLE_ELEMENT_LENGTHS.get(i);
                shortestIdx = i;
            }
            assert (shortestIdx != -1);
            StyleElement style = STYLE_ELEMENTS.get(shortestIdx);
            STYLE_ELEMENT_LENGTHS.set(shortestIdx, shortestLen + contents.length());
            this.appendContents(style, contents);
            return style;
        }

        public StyleElement injectStyleSheetAtEnd(String contents) {
            if (STYLE_ELEMENTS.length() == 0) {
                return this.injectStyleSheet(contents);
            }
            int idx = STYLE_ELEMENTS.length() - 1;
            StyleElement style = STYLE_ELEMENTS.get(idx);
            STYLE_ELEMENT_LENGTHS.set(idx, STYLE_ELEMENT_LENGTHS.get(idx) + contents.length());
            this.appendContents(style, contents);
            return style;
        }

        public StyleElement injectStyleSheetAtStart(String contents) {
            if (STYLE_ELEMENTS.length() == 0) {
                return this.injectStyleSheet(contents);
            }
            StyleElement style = STYLE_ELEMENTS.get(0);
            STYLE_ELEMENT_LENGTHS.set(0, STYLE_ELEMENT_LENGTHS.get(0) + contents.length());
            this.prependContents(style, contents);
            return style;
        }

        public native void prependContents(StyleElement var1, String var2);

        public native void setContents(StyleElement var1, String var2);

        private native StyleElement createElement();

        private native int getDocumentStyleCount();
    }

    public static class StyleInjectorImpl {
        private static final StyleInjectorImpl IMPL = (StyleInjectorImpl)GWT.create(StyleInjectorImpl.class);
        private HeadElement head;

        public StyleElement injectStyleSheet(String contents) {
            StyleElement style = this.createElement(contents);
            this.getHead().appendChild(style);
            return style;
        }

        public StyleElement injectStyleSheetAtEnd(String contents) {
            return this.injectStyleSheet(contents);
        }

        public StyleElement injectStyleSheetAtStart(String contents) {
            StyleElement style = this.createElement(contents);
            this.getHead().insertBefore(style, this.head.getFirstChild());
            return style;
        }

        public void setContents(StyleElement style, String contents) {
            style.setInnerText(contents);
        }

        private StyleElement createElement(String contents) {
            StyleElement style = Document.get().createStyleElement();
            style.setPropertyString("language", "text/css");
            this.setContents(style, contents);
            return style;
        }

        private HeadElement getHead() {
            if (this.head == null) {
                Element elt = Document.get().getElementsByTagName("head").getItem(0);
                assert (elt != null) : "The host HTML page does not have a <head> element which is required by StyleInjector";
                this.head = HeadElement.as(elt);
            }
            return this.head;
        }
    }
}

