/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.layout.client;

import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.layout.client.Layout;

class LayoutImpl {
    private static DivElement fixedRuler;
    protected DivElement relativeRuler;

    LayoutImpl() {
    }

    protected static DivElement createRuler(Style.Unit widthUnit, Style.Unit heightUnit) {
        DivElement ruler = Document.get().createDivElement();
        ruler.setInnerHTML("&nbsp;");
        Style style = ruler.getStyle();
        style.setPosition(Style.Position.ABSOLUTE);
        style.setZIndex(-32767);
        style.setLeft(-10000.0, Style.Unit.PX);
        style.setWidth(1.0, widthUnit);
        style.setHeight(1.0, heightUnit);
        return ruler;
    }

    public Element attachChild(Element parent, Element child, Element before) {
        DivElement container = Document.get().createDivElement();
        container.appendChild(child);
        container.getStyle().setPosition(Style.Position.ABSOLUTE);
        container.getStyle().setOverflow(Style.Overflow.HIDDEN);
        this.fillParent(child);
        Element beforeContainer = null;
        if (before != null) {
            beforeContainer = before.getParentElement();
            assert (beforeContainer.getParentElement() == parent) : "Element to insert before must be a sibling";
        }
        parent.insertBefore(container, beforeContainer);
        return container;
    }

    public void fillParent(Element elem) {
        Style style = elem.getStyle();
        style.setPosition(Style.Position.ABSOLUTE);
        style.setLeft(0.0, Style.Unit.PX);
        style.setTop(0.0, Style.Unit.PX);
        style.setRight(0.0, Style.Unit.PX);
        style.setBottom(0.0, Style.Unit.PX);
    }

    public void finalizeLayout(Element parent) {
    }

    public double getUnitSizeInPixels(Element parent, Style.Unit unit, boolean vertical) {
        if (unit == null) {
            return 1.0;
        }
        switch (unit) {
            case PCT: {
                return (double)(vertical ? parent.getClientHeight() : parent.getClientWidth()) / 100.0;
            }
            case EM: {
                return this.relativeRuler.getOffsetWidth();
            }
            case EX: {
                return this.relativeRuler.getOffsetHeight();
            }
            case CM: {
                return fixedRuler.getOffsetWidth();
            }
            case MM: {
                return (double)fixedRuler.getOffsetWidth() / 10.0;
            }
            case IN: {
                return (double)fixedRuler.getOffsetWidth() / 2.54;
            }
            case PT: {
                return (double)fixedRuler.getOffsetWidth() / 28.4;
            }
            case PC: {
                return (double)fixedRuler.getOffsetWidth() / 2.36;
            }
        }
        return 1.0;
    }

    public void initParent(Element parent) {
        parent.getStyle().setPosition(Style.Position.RELATIVE);
        this.relativeRuler = LayoutImpl.createRuler(Style.Unit.EM, Style.Unit.EX);
        parent.appendChild(this.relativeRuler);
    }

    public void layout(Layout.Layer layer) {
        Style style = layer.container.getStyle();
        style.setProperty("left", layer.setLeft ? layer.left + layer.leftUnit.getType() : "");
        style.setProperty("top", layer.setTop ? layer.top + layer.topUnit.getType() : "");
        style.setProperty("right", layer.setRight ? layer.right + layer.rightUnit.getType() : "");
        style.setProperty("bottom", layer.setBottom ? layer.bottom + layer.bottomUnit.getType() : "");
        style.setProperty("width", layer.setWidth ? layer.width + layer.widthUnit.getType() : "");
        style.setProperty("height", layer.setHeight ? layer.height + layer.heightUnit.getType() : "");
    }

    public void onAttach(Element parent) {
    }

    public void onDetach(Element parent) {
    }

    public void removeChild(Element container, Element child) {
        container.removeFromParent();
        if (child.getParentElement() == container) {
            child.removeFromParent();
        }
        Style style = child.getStyle();
        style.clearPosition();
        style.clearLeft();
        style.clearTop();
        style.clearWidth();
        style.clearHeight();
    }

    static {
        Document doc = Document.get();
        fixedRuler = LayoutImpl.createRuler(Style.Unit.IN, Style.Unit.IN);
        doc.getBody().appendChild(fixedRuler);
    }
}

