/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.rg;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.resources.client.impl.ImageResourcePrototype;
import com.google.gwt.resources.ext.AbstractResourceGenerator;
import com.google.gwt.resources.ext.ClientBundleFields;
import com.google.gwt.resources.ext.ClientBundleRequirements;
import com.google.gwt.resources.ext.ResourceContext;
import com.google.gwt.resources.ext.ResourceGeneratorUtil;
import com.google.gwt.resources.rg.ImageBundleBuilder;
import com.google.gwt.resources.rg.UnsuitableForStripException;
import com.google.gwt.user.rebind.StringSourceWriter;
import java.awt.geom.AffineTransform;
import java.net.URL;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;

public final class ImageResourceGenerator
extends AbstractResourceGenerator {
    private Map<String, ImageBundleBuilder.ImageRect> imageRectsByName;
    private Map<ImageBundleBuilder.ImageRect, ImageBundleBuilder> buildersByImageRect;
    private Map<ImageResource.RepeatStyle, ImageBundleBuilder> buildersByRepeatStyle;
    private Map<ImageBundleBuilder, String[]> urlsByBuilder;
    private Map<ImageBundleBuilder.ImageRect, String[]> urlsByExternalImageRect;
    private Map<ImageBundleBuilder.ImageRect, ImageBundleBuilder> rtlImages;

    public String createAssignment(TreeLogger logger, ResourceContext context, JMethod method) throws UnableToCompleteException {
        String name = method.getName();
        StringSourceWriter sw = new StringSourceWriter();
        sw.println("new " + ImageResourcePrototype.class.getName() + "(");
        sw.indent();
        sw.println('\"' + name + "\",");
        ImageBundleBuilder.ImageRect rect = this.imageRectsByName.get(name);
        assert (rect != null) : "No ImageRect ever computed for " + name;
        ImageBundleBuilder builder = this.buildersByImageRect.get(rect);
        String[] urlExpressions = builder == null ? this.urlsByExternalImageRect.get(rect) : this.urlsByBuilder.get(builder);
        assert (urlExpressions != null) : "No URL expression for " + name;
        assert (urlExpressions.length == 2);
        if (urlExpressions[1] == null) {
            sw.println(urlExpressions[0] + ",");
        } else {
            sw.println("com.google.gwt.i18n.client.LocaleInfo.getCurrentLocale().isRTL() ?" + urlExpressions[1] + " : " + urlExpressions[0] + ",");
        }
        sw.println(rect.getLeft() + ", " + rect.getTop() + ", " + rect.getWidth() + ", " + rect.getHeight() + ", " + rect.isAnimated());
        sw.outdent();
        sw.print(")");
        return sw.toString();
    }

    public void createFields(TreeLogger logger, ResourceContext context, ClientBundleFields fields) throws UnableToCompleteException {
        TypeOracle typeOracle = context.getGeneratorContext().getTypeOracle();
        JClassType stringType = typeOracle.findType(String.class.getName());
        assert (stringType != null);
        IdentityHashMap<ImageBundleBuilder, String> prettyNames = new IdentityHashMap<ImageBundleBuilder, String>();
        block6: for (Map.Entry<ImageResource.RepeatStyle, ImageBundleBuilder> entry : this.buildersByRepeatStyle.entrySet()) {
            ImageBundleBuilder.Arranger arranger;
            ImageResource.RepeatStyle repeatStyle = entry.getKey();
            ImageBundleBuilder builder = entry.getValue();
            switch (repeatStyle) {
                case None: {
                    arranger = new ImageBundleBuilder.BestFitArranger();
                    break;
                }
                case Horizontal: {
                    arranger = new ImageBundleBuilder.VerticalArranger();
                    break;
                }
                case Vertical: {
                    arranger = new ImageBundleBuilder.HorizontalArranger();
                    break;
                }
                case Both: {
                    continue block6;
                }
                default: {
                    logger.log(TreeLogger.ERROR, "Unknown RepeatStyle" + (Object)((Object)repeatStyle));
                    throw new UnableToCompleteException();
                }
            }
            String bundleUrlExpression = builder.writeBundledImage(logger.branch(TreeLogger.DEBUG, "Writing image strip", null), context, arranger);
            if (bundleUrlExpression == null) continue;
            String prettyName = "imageUrl" + (Object)((Object)repeatStyle);
            prettyNames.put(builder, prettyName);
            String fieldName = fields.define((JType)stringType, prettyName, bundleUrlExpression, true, true);
            String[] strings = new String[]{fieldName, null};
            this.urlsByBuilder.put(builder, strings);
        }
        if (this.rtlImages.size() > 0) {
            String[] strings;
            HashSet<ImageBundleBuilder> rtlBuilders = new HashSet<ImageBundleBuilder>();
            for (Map.Entry<ImageBundleBuilder.ImageRect, ImageBundleBuilder> entry : this.rtlImages.entrySet()) {
                ImageBundleBuilder.ImageRect rtlImage = entry.getKey();
                AffineTransform tx = new AffineTransform();
                tx.setTransform(-1.0, 0.0, 0.0, 1.0, rtlImage.getWidth(), 0.0);
                rtlImage.setTransform(tx);
                if (this.buildersByImageRect.containsKey(rtlImage)) {
                    rtlBuilders.add(this.buildersByImageRect.get(rtlImage));
                    continue;
                }
                strings = this.urlsByExternalImageRect.get(rtlImage);
                assert (strings != null);
                byte[] imageBytes = ImageBundleBuilder.toPng(logger, rtlImage);
                strings[1] = context.deploy(rtlImage.getName() + "_rtl.png", "image/png", imageBytes, false);
            }
            for (ImageBundleBuilder builder : rtlBuilders) {
                String bundleUrlExpression = builder.writeBundledImage(logger.branch(TreeLogger.DEBUG, "Writing image strip", null), context, new ImageBundleBuilder.IdentityArranger());
                if (bundleUrlExpression == null) continue;
                String prettyName = (String)prettyNames.get(builder);
                strings = this.urlsByBuilder.get(builder);
                assert (strings != null);
                strings[1] = fields.define((JType)stringType, prettyName + "_rtl", bundleUrlExpression, true, true);
            }
        }
    }

    public void init(TreeLogger logger, ResourceContext context) {
        this.imageRectsByName = new HashMap<String, ImageBundleBuilder.ImageRect>();
        this.buildersByImageRect = new IdentityHashMap<ImageBundleBuilder.ImageRect, ImageBundleBuilder>();
        this.buildersByRepeatStyle = new EnumMap<ImageResource.RepeatStyle, ImageBundleBuilder>(ImageResource.RepeatStyle.class);
        this.rtlImages = new IdentityHashMap<ImageBundleBuilder.ImageRect, ImageBundleBuilder>();
        this.urlsByBuilder = new IdentityHashMap<ImageBundleBuilder, String[]>();
        this.urlsByExternalImageRect = new IdentityHashMap<ImageBundleBuilder.ImageRect, String[]>();
    }

    public void prepare(TreeLogger logger, ResourceContext context, ClientBundleRequirements requirements, JMethod method) throws UnableToCompleteException {
        ImageBundleBuilder.ImageRect rect;
        URL[] resources = ResourceGeneratorUtil.findResources(logger, context, method);
        if (resources.length != 1) {
            logger.log(TreeLogger.ERROR, "Exactly one image may be specified", null);
            throw new UnableToCompleteException();
        }
        ImageBundleBuilder builder = this.getBuilder(method);
        URL resource = resources[0];
        String name = method.getName();
        try {
            rect = builder.assimilate(logger, name, resource);
            if (context.supportsDataUrls() || this.getRepeatStyle(method) == ImageResource.RepeatStyle.Both) {
                builder.removeMapping(name);
                rect.setPosition(0, 0);
                throw new UnsuitableForStripException(rect);
            }
            this.buildersByImageRect.put(rect, builder);
        }
        catch (UnsuitableForStripException e) {
            String urlExpression;
            rect = e.getImageRect();
            if (rect.isAnimated()) {
                urlExpression = context.deploy(resource, false);
            } else {
                byte[] imageBytes = ImageBundleBuilder.toPng(logger, rect);
                urlExpression = context.deploy(rect.getName() + ".png", "image/png", imageBytes, false);
            }
            this.urlsByExternalImageRect.put(rect, new String[]{urlExpression, null});
        }
        this.imageRectsByName.put(name, rect);
        if (this.getFlipRtl(method)) {
            this.rtlImages.put(rect, null);
        }
    }

    private ImageBundleBuilder getBuilder(JMethod method) {
        ImageResource.RepeatStyle repeatStyle = this.getRepeatStyle(method);
        ImageBundleBuilder builder = this.buildersByRepeatStyle.get((Object)repeatStyle);
        if (builder == null) {
            builder = new ImageBundleBuilder();
            this.buildersByRepeatStyle.put(repeatStyle, builder);
        }
        return builder;
    }

    private boolean getFlipRtl(JMethod method) {
        ImageResource.ImageOptions options = (ImageResource.ImageOptions)method.getAnnotation(ImageResource.ImageOptions.class);
        if (options == null) {
            return false;
        }
        return options.flipRtl();
    }

    private ImageResource.RepeatStyle getRepeatStyle(JMethod method) {
        ImageResource.ImageOptions options = (ImageResource.ImageOptions)method.getAnnotation(ImageResource.ImageOptions.class);
        if (options == null) {
            return ImageResource.RepeatStyle.None;
        }
        return options.repeatStyle();
    }
}

