/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.HasAllMouseHandlers;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.DecoratedPopupPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHTML;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.Widget;

public class DialogBox
extends DecoratedPopupPanel
implements HasHTML,
HasText,
MouseListener {
    private static final String DEFAULT_STYLENAME = "gwt-DialogBox";
    private CaptionImpl caption = new CaptionImpl();
    private boolean dragging;
    private int dragStartX;
    private int dragStartY;
    private int windowWidth;
    private int clientLeft;
    private int clientTop;
    private HandlerRegistration resizeHandlerRegistration;

    public DialogBox() {
        this(false);
    }

    public DialogBox(boolean autoHide) {
        this(autoHide, true);
    }

    public DialogBox(boolean autoHide, boolean modal) {
        super(autoHide, modal, "dialog");
        Element td = this.getCellElement(0, 1);
        DOM.appendChild(td, this.caption.getElement());
        this.adopt(this.caption);
        this.caption.setStyleName("Caption");
        this.setStyleName(DEFAULT_STYLENAME);
        this.windowWidth = Window.getClientWidth();
        this.clientLeft = Document.get().getBodyOffsetLeft();
        this.clientTop = Document.get().getBodyOffsetTop();
        MouseHandler mouseHandler = new MouseHandler();
        this.addDomHandler(mouseHandler, MouseDownEvent.getType());
        this.addDomHandler(mouseHandler, MouseUpEvent.getType());
        this.addDomHandler(mouseHandler, MouseMoveEvent.getType());
        this.addDomHandler(mouseHandler, MouseOverEvent.getType());
        this.addDomHandler(mouseHandler, MouseOutEvent.getType());
    }

    public final Caption getCaption() {
        return this.caption;
    }

    public String getHTML() {
        return this.caption.getHTML();
    }

    public String getText() {
        return this.caption.getText();
    }

    public void hide() {
        if (this.resizeHandlerRegistration != null) {
            this.resizeHandlerRegistration.removeHandler();
            this.resizeHandlerRegistration = null;
        }
        super.hide();
    }

    public void onBrowserEvent(Event event) {
        switch (event.getTypeInt()) {
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: {
                if (this.dragging || this.isCaptionEvent(event)) break;
                return;
            }
        }
        super.onBrowserEvent(event);
    }

    @Deprecated
    public void onMouseDown(Widget sender, int x, int y) {
        this.dragging = true;
        DOM.setCapture(this.getElement());
        this.dragStartX = x;
        this.dragStartY = y;
    }

    @Deprecated
    public void onMouseEnter(Widget sender) {
    }

    @Deprecated
    public void onMouseLeave(Widget sender) {
    }

    @Deprecated
    public void onMouseMove(Widget sender, int x, int y) {
        if (this.dragging) {
            int absX = x + this.getAbsoluteLeft();
            int absY = y + this.getAbsoluteTop();
            if (absX < this.clientLeft || absX >= this.windowWidth || absY < this.clientTop) {
                return;
            }
            this.setPopupPosition(absX - this.dragStartX, absY - this.dragStartY);
        }
    }

    @Deprecated
    public void onMouseUp(Widget sender, int x, int y) {
        this.dragging = false;
        DOM.releaseCapture(this.getElement());
    }

    public void setHTML(String html) {
        this.caption.setHTML(html);
    }

    public void setText(String text) {
        this.caption.setText(text);
    }

    public void show() {
        if (this.resizeHandlerRegistration == null) {
            this.resizeHandlerRegistration = Window.addResizeHandler(new ResizeHandler(){

                public void onResize(ResizeEvent event) {
                    DialogBox.this.windowWidth = event.getWidth();
                }
            });
        }
        super.show();
    }

    protected void beginDragging(MouseDownEvent event) {
        this.onMouseDown(this.caption, event.getX(), event.getY());
    }

    protected void continueDragging(MouseMoveEvent event) {
        this.onMouseMove(this.caption, event.getX(), event.getY());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAttachChildren() {
        try {
            super.doAttachChildren();
        }
        finally {
            this.caption.onAttach();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDetachChildren() {
        try {
            super.doDetachChildren();
        }
        finally {
            this.caption.onDetach();
        }
    }

    protected void endDragging(MouseUpEvent event) {
        this.onMouseUp(this.caption, event.getX(), event.getY());
    }

    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        this.caption.ensureDebugId(baseID + "-caption");
        DialogBox.ensureDebugId(this.getCellElement(1, 1), baseID, "content");
    }

    protected void onPreviewNativeEvent(Event.NativePreviewEvent event) {
        NativeEvent nativeEvent = event.getNativeEvent();
        if (!event.isCanceled() && event.getTypeInt() == 4 && this.isCaptionEvent(nativeEvent)) {
            nativeEvent.preventDefault();
        }
        super.onPreviewNativeEvent(event);
    }

    private boolean isCaptionEvent(NativeEvent event) {
        EventTarget target = event.getEventTarget();
        if (Element.is(target)) {
            return this.getCellElement(0, 1).getParentElement().isOrHasChild(Element.as(target));
        }
        return false;
    }

    private class MouseHandler
    implements MouseDownHandler,
    MouseUpHandler,
    MouseOutHandler,
    MouseOverHandler,
    MouseMoveHandler {
        private MouseHandler() {
        }

        public void onMouseDown(MouseDownEvent event) {
            DialogBox.this.beginDragging(event);
        }

        public void onMouseMove(MouseMoveEvent event) {
            DialogBox.this.continueDragging(event);
        }

        public void onMouseOut(MouseOutEvent event) {
            DialogBox.this.onMouseLeave(DialogBox.this.caption);
        }

        public void onMouseOver(MouseOverEvent event) {
            DialogBox.this.onMouseEnter(DialogBox.this.caption);
        }

        public void onMouseUp(MouseUpEvent event) {
            DialogBox.this.endDragging(event);
        }
    }

    private static class CaptionImpl
    extends HTML
    implements Caption {
        private CaptionImpl() {
        }
    }

    public static interface Caption
    extends HasAllMouseHandlers {
    }
}

