/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.rg;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.dev.util.Util;
import com.google.gwt.dev.util.log.PrintWriterTreeLogger;
import com.google.gwt.resources.rg.UnsuitableForStripException;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;

class ImageBundleBuilder {
    static final String BUNDLE_FILE_TYPE = "png";
    static final String BUNDLE_MIME_TYPE = "image/png";
    private static final int IMAGE_MAX_SIZE = Integer.getInteger("gwt.imageResource.maxBundleSize", 256);
    private final Map<String, ImageRect> imageNameToImageRectMap = new HashMap<String, ImageRect>();
    private final Map<String, String> strongNametoCanonicalImageNameMap = new HashMap<String, String>();

    public static void main(String[] args) {
        PrintWriterTreeLogger logger = new PrintWriterTreeLogger(new PrintWriter(System.out));
        if (args.length < 2) {
            logger.log(TreeLogger.ERROR, ImageBundleBuilder.class.getSimpleName() + " <output file> <input file> ...");
            System.exit(-1);
        }
        ImageBundleBuilder builder = new ImageBundleBuilder();
        boolean fail = false;
        int j = args.length;
        for (int i = 1; i < j; ++i) {
            TreeLogger loopLogger = logger.branch(TreeLogger.DEBUG, "Processing argument " + args[i]);
            File file = new File(args[i]);
            Throwable ex = null;
            try {
                builder.assimilate(loopLogger, args[i], file.toURL());
            }
            catch (MalformedURLException e) {
                ex = e;
            }
            catch (UnableToCompleteException e) {
                ex = e;
            }
            catch (UnsuitableForStripException e) {
                ex = e;
            }
            if (ex == null) continue;
            loopLogger.log(TreeLogger.ERROR, "Unable to assimilate image", ex);
            fail = true;
        }
        if (fail) {
            System.exit(-1);
        }
        String outFile = args[0];
        try {
            BufferedImage bundledImage = builder.drawBundledImage(new BestFitArranger());
            byte[] bytes = ImageBundleBuilder.createImageBytes((TreeLogger)logger, bundledImage);
            FileOutputStream out = new FileOutputStream(outFile);
            out.write(bytes);
            out.close();
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Unable to write output file", (Throwable)e);
            System.exit(-2);
        }
        catch (UnableToCompleteException e) {
            logger.log(TreeLogger.ERROR, "Unable to draw output image", (Throwable)e);
            System.exit(-2);
        }
        System.exit(0);
    }

    public static byte[] toPng(TreeLogger logger, HasRect rect) throws UnableToCompleteException {
        BufferedImage bundledImage = new BufferedImage(rect.getWidth(), rect.getHeight(), 3);
        Graphics2D g2d = bundledImage.createGraphics();
        g2d.drawImage(rect.getImage(), rect.transform(), null);
        g2d.dispose();
        byte[] imageBytes = ImageBundleBuilder.createImageBytes(logger, bundledImage);
        return imageBytes;
    }

    private static byte[] createImageBytes(TreeLogger logger, BufferedImage bundledImage) throws UnableToCompleteException {
        byte[] imageBytes;
        try {
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bundledImage, BUNDLE_FILE_TYPE, byteOutputStream);
            imageBytes = byteOutputStream.toByteArray();
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Unable to generate file name for image bundle file", null);
            throw new UnableToCompleteException();
        }
        return imageBytes;
    }

    private static int gcd(int a, int b) {
        while (b != 0) {
            int t = b;
            b = a % b;
            a = t;
        }
        return a;
    }

    private static int lcm(int a, int b) {
        return b / ImageBundleBuilder.gcd(a, b) * a;
    }

    public ImageBundleBuilder() {
    }

    public ImageBundleBuilder(ImageBundleBuilder other) {
        for (Map.Entry<String, ImageRect> entry : other.imageNameToImageRectMap.entrySet()) {
            this.imageNameToImageRectMap.put(entry.getKey(), new ImageRect(entry.getValue()));
        }
    }

    public ImageRect assimilate(TreeLogger logger, String imageName, URL resource) throws UnableToCompleteException, UnsuitableForStripException {
        ImageRect rect = this.getMapping(imageName);
        if (rect == null) {
            String strongName = Util.computeStrongName((byte[])Util.readURLAsBytes((URL)resource));
            if (this.strongNametoCanonicalImageNameMap.containsKey(strongName)) {
                String previousImageName = this.strongNametoCanonicalImageNameMap.get(strongName);
                rect = this.getMapping(previousImageName);
                assert (rect != null);
                this.imageNameToImageRectMap.put(imageName, rect);
            } else {
                rect = this.addImage(logger, imageName, resource);
                this.imageNameToImageRectMap.put(imageName, rect);
                this.strongNametoCanonicalImageNameMap.put(strongName, imageName);
            }
        }
        return rect;
    }

    public int getImageCount() {
        return this.imageNameToImageRectMap.size();
    }

    public ImageRect getMapping(String imageName) {
        return this.imageNameToImageRectMap.get(imageName);
    }

    public ImageRect removeMapping(String imageName) {
        this.strongNametoCanonicalImageNameMap.values().remove(imageName);
        return this.imageNameToImageRectMap.remove(imageName);
    }

    public byte[] render(TreeLogger logger, Arranger arranger) throws UnableToCompleteException {
        if (this.imageNameToImageRectMap.isEmpty()) {
            return null;
        }
        BufferedImage bundledImage = this.drawBundledImage(arranger);
        byte[] imageBytes = ImageBundleBuilder.createImageBytes(logger, bundledImage);
        return imageBytes;
    }

    private ImageRect addImage(TreeLogger logger, String imageName, URL imageUrl) throws UnableToCompleteException, UnsuitableForStripException {
        logger = logger.branch(TreeLogger.TRACE, "Adding image '" + imageName + "'", null);
        BufferedImage image = null;
        try {
            MemoryCacheImageInputStream input = new MemoryCacheImageInputStream(imageUrl.openStream());
            Iterator<ImageReader> it = ImageIO.getImageReaders(input);
            while (it.hasNext()) {
                ImageReader reader = it.next();
                reader.setInput(input);
                int numImages = reader.getNumImages(true);
                if (numImages == 0) continue;
                if (numImages == 1) {
                    try {
                        image = reader.read(0);
                    }
                    catch (Exception e) {}
                    continue;
                }
                BufferedImage[] images = new BufferedImage[numImages];
                try {
                    for (int i = 0; i < numImages; ++i) {
                        images[i] = reader.read(i);
                    }
                }
                catch (Exception e) {
                    continue;
                }
                ImageRect rect = new ImageRect(imageName, images);
                throw new UnsuitableForStripException(rect);
            }
        }
        catch (IllegalArgumentException iex) {
            if (imageName.toLowerCase().endsWith(BUNDLE_FILE_TYPE) && iex.getMessage() != null && iex.getStackTrace()[0].getClassName().equals("javax.imageio.ImageTypeSpecifier$Indexed")) {
                logger.log(TreeLogger.ERROR, "Unable to read image. The image may not be in valid PNG format. This problem may also be due to a bug in versions of the JRE prior to 1.6. See http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=5098176 for more information. If this bug is the cause of the error, try resaving the image using a different image program, or upgrade to a newer JRE.", null);
                throw new UnableToCompleteException();
            }
            throw iex;
        }
        catch (IOException e) {
            logger.log(TreeLogger.ERROR, "Unable to read image resource", (Throwable)e);
            throw new UnableToCompleteException();
        }
        if (image == null) {
            logger.log(TreeLogger.ERROR, "Unrecognized image file format", null);
            throw new UnableToCompleteException();
        }
        ImageRect toReturn = new ImageRect(imageName, image);
        if (toReturn.height > IMAGE_MAX_SIZE || toReturn.width > IMAGE_MAX_SIZE) {
            throw new UnsuitableForStripException(toReturn);
        }
        return toReturn;
    }

    private BufferedImage drawBundledImage(Arranger arranger) {
        LinkedList<HasRect> imageRects = new LinkedList<HasRect>(this.imageNameToImageRectMap.values());
        Size size = arranger.arrangeImages(imageRects);
        BufferedImage bundledImage = new BufferedImage(size.width, size.height, 3);
        Graphics2D g2d = bundledImage.createGraphics();
        for (HasRect imageRect : imageRects) {
            g2d.drawImage(imageRect.getImage(), imageRect.transform(), null);
        }
        g2d.dispose();
        return bundledImage;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class VerticalArranger
    implements Arranger {
        VerticalArranger() {
        }

        @Override
        public Size arrangeImages(Collection<HasRect> rects) {
            int height = 0;
            int width = 1;
            for (HasRect rect : rects) {
                rect.setPosition(0, height);
                width = ImageBundleBuilder.lcm(width, rect.getWidth());
                height += rect.getHeight();
            }
            ArrayList<ImageRect> toAdd = new ArrayList<ImageRect>();
            for (HasRect rect : rects) {
                for (int x = rect.getWidth(); x < width; x += rect.getWidth()) {
                    ImageRect newRect = new ImageRect(rect);
                    newRect.setPosition(x, rect.getTop());
                    toAdd.add(newRect);
                }
            }
            rects.addAll(toAdd);
            return new Size(width, height);
        }
    }

    static class Size {
        private final int width;
        private final int height;

        Size(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }

    static class ImageRect
    implements HasRect {
        private boolean hasBeenPositioned;
        private final int height;
        private final int width;
        private final BufferedImage[] images;
        private int left;
        private int top;
        private final String name;
        private final AffineTransform transform = new AffineTransform();

        public ImageRect(HasRect other) {
            this.name = other.getName();
            this.height = other.getHeight();
            this.width = other.getWidth();
            this.images = other.getImages();
            this.left = other.getLeft();
            this.top = other.getTop();
            this.setTransform(other.getTransform());
        }

        public ImageRect(String name, BufferedImage image) {
            this.name = name;
            this.images = new BufferedImage[]{image};
            this.width = image.getWidth();
            this.height = image.getHeight();
        }

        public ImageRect(String name, BufferedImage[] images) {
            this.name = name;
            this.images = images;
            this.width = images[0].getWidth();
            this.height = images[0].getHeight();
        }

        public int getHeight() {
            return this.height;
        }

        public BufferedImage getImage() {
            return this.images[0];
        }

        public BufferedImage[] getImages() {
            return this.images;
        }

        public int getLeft() {
            return this.left;
        }

        public String getName() {
            return this.name;
        }

        public int getTop() {
            return this.top;
        }

        public AffineTransform getTransform() {
            return new AffineTransform(this.transform);
        }

        public int getWidth() {
            return this.width;
        }

        public boolean hasBeenPositioned() {
            return this.hasBeenPositioned;
        }

        public boolean isAnimated() {
            return this.images.length > 1;
        }

        public void setPosition(int left, int top) {
            this.hasBeenPositioned = true;
            this.left = left;
            this.top = top;
        }

        public void setTransform(AffineTransform transform) {
            this.transform.setTransform(transform);
        }

        public AffineTransform transform() {
            AffineTransform toReturn = new AffineTransform();
            toReturn.translate(this.left, this.top);
            toReturn.concatenate(this.transform);
            assert (this.checkTransform(toReturn));
            return toReturn;
        }

        private boolean checkTransform(AffineTransform tx) {
            double[] in = new double[]{0.0, 0.0, this.width, this.height};
            double[] out = new double[]{0.0, 0.0, 0.0, 0.0};
            tx.transform(in, 0, out, 0, 2);
            assert ((double)this.width == Math.abs(out[0] - out[2]));
            assert ((double)this.height == Math.abs(out[1] - out[3]));
            assert (out[0] >= 0.0);
            assert (out[1] >= 0.0);
            assert (out[2] >= 0.0);
            assert (out[3] >= 0.0);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IdentityArranger
    implements Arranger {
        IdentityArranger() {
        }

        @Override
        public Size arrangeImages(Collection<HasRect> rects) {
            int height = 0;
            int width = 0;
            for (HasRect rect : rects) {
                height = Math.max(height, rect.getTop() + rect.getHeight());
                width = Math.max(width, rect.getLeft() + rect.getWidth());
            }
            return new Size(width, height);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HorizontalArranger
    implements Arranger {
        HorizontalArranger() {
        }

        @Override
        public Size arrangeImages(Collection<HasRect> rects) {
            int height = 1;
            int width = 0;
            for (HasRect rect : rects) {
                rect.setPosition(width, 0);
                width += rect.getWidth();
                height = ImageBundleBuilder.lcm(height, rect.getHeight());
            }
            ArrayList<ImageRect> toAdd = new ArrayList<ImageRect>();
            for (HasRect rect : rects) {
                for (int y = rect.getHeight(); y < height; y += rect.getHeight()) {
                    ImageRect newRect = new ImageRect(rect);
                    newRect.setPosition(rect.getLeft(), y);
                    toAdd.add(newRect);
                }
            }
            rects.addAll(toAdd);
            return new Size(width, height);
        }
    }

    static interface HasRect {
        public int getHeight();

        public BufferedImage getImage();

        public BufferedImage[] getImages();

        public int getLeft();

        public String getName();

        public int getTop();

        public AffineTransform getTransform();

        public int getWidth();

        public boolean hasBeenPositioned();

        public void setPosition(int var1, int var2);

        public AffineTransform transform();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BestFitArranger
    implements Arranger {
        private static final Comparator<HasRect> decreasingHeightComparator = new Comparator<HasRect>(){

            @Override
            public int compare(HasRect a, HasRect b) {
                int c = b.getHeight() - a.getHeight();
                return c != 0 ? c : b.getName().compareTo(a.getName());
            }
        };
        private static final Comparator<HasRect> decreasingWidthComparator = new Comparator<HasRect>(){

            @Override
            public int compare(HasRect a, HasRect b) {
                int c = b.getWidth() - a.getWidth();
                return c != 0 ? c : b.getName().compareTo(a.getName());
            }
        };

        BestFitArranger() {
        }

        @Override
        public Size arrangeImages(Collection<HasRect> rects) {
            if (rects.size() == 0) {
                return new Size(0, 0);
            }
            ArrayList<HasRect> rectsOrderedByHeight = new ArrayList<HasRect>(rects);
            Collections.sort(rectsOrderedByHeight, decreasingHeightComparator);
            ArrayList<HasRect> rectsOrderedByWidth = new ArrayList<HasRect>(rects);
            Collections.sort(rectsOrderedByWidth, decreasingWidthComparator);
            HasRect first = rectsOrderedByHeight.get(0);
            first.setPosition(0, 0);
            int curX = first.getWidth();
            int colH = first.getHeight();
            int n = rectsOrderedByHeight.size();
            for (int i = 1; i < n; ++i) {
                if (rectsOrderedByHeight.get(i).hasBeenPositioned()) continue;
                int colW = 0;
                int curY = 0;
                ArrayList<HasRect> rectsInColumn = new ArrayList<HasRect>();
                for (int j = i; j < n; ++j) {
                    HasRect current = rectsOrderedByHeight.get(j);
                    if (current.hasBeenPositioned() || curY + current.getHeight() > colH) continue;
                    current.setPosition(curX, 0);
                    colW = Math.max(colW, current.getWidth());
                    curY += current.getHeight();
                    int pos = Collections.binarySearch(rectsInColumn, current, decreasingWidthComparator);
                    assert (pos < 0);
                    rectsInColumn.add(-1 - pos, current);
                }
                if (!rectsInColumn.isEmpty()) {
                    this.arrangeColumn(rectsInColumn, rectsOrderedByWidth);
                }
                curX += colW;
            }
            return new Size(curX, colH);
        }

        private void arrangeColumn(List<HasRect> rectsInColumn, List<HasRect> remainingRectsOrderedByWidth) {
            HasRect first = rectsInColumn.get(0);
            int columnWidth = first.getWidth();
            int curY = first.getHeight();
            int m = rectsInColumn.size();
            for (int i = 1; i < m; ++i) {
                HasRect r = rectsInColumn.get(i);
                r.setPosition(r.getLeft(), curY);
                int curX = r.getWidth();
                int n = remainingRectsOrderedByWidth.size();
                for (int j = 0; j < n; ++j) {
                    HasRect current = remainingRectsOrderedByWidth.get(j);
                    if (current.hasBeenPositioned() || curX + current.getWidth() > columnWidth || current.getHeight() > r.getHeight()) continue;
                    current.setPosition(r.getLeft() + curX, r.getTop());
                    curX += current.getWidth();
                }
                curY += r.getHeight();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Arranger {
        public Size arrangeImages(Collection<HasRect> var1);
    }
}

