/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.attributeparsers;

import com.google.gwt.core.ext.typeinfo.JEnumType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.core.ext.typeinfo.TypeOracleException;
import com.google.gwt.uibinder.attributeparsers.AttributeParser;
import com.google.gwt.uibinder.attributeparsers.BooleanAttributeParser;
import com.google.gwt.uibinder.attributeparsers.DoubleAttributeParser;
import com.google.gwt.uibinder.attributeparsers.EnumAttributeParser;
import com.google.gwt.uibinder.attributeparsers.FieldReferenceConverter;
import com.google.gwt.uibinder.attributeparsers.HorizontalAlignmentConstantParser;
import com.google.gwt.uibinder.attributeparsers.IntAttributeParser;
import com.google.gwt.uibinder.attributeparsers.IntPairParser;
import com.google.gwt.uibinder.attributeparsers.StrictAttributeParser;
import com.google.gwt.uibinder.attributeparsers.StringAttributeParser;
import com.google.gwt.uibinder.attributeparsers.VerticalAlignmentConstantParser;
import com.google.gwt.uibinder.rebind.FieldManager;
import com.google.gwt.uibinder.rebind.MortalLogger;
import java.util.HashMap;
import java.util.Map;

public class AttributeParsers {
    private static final String VERT_CONSTANT = "com.google.gwt.user.client.ui.HasVerticalAlignment.VerticalAlignmentConstant";
    private static final String HORIZ_CONSTANT = "com.google.gwt.user.client.ui.HasHorizontalAlignment.HorizontalAlignmentConstant";
    private static final String INT = "int";
    private static final String STRING = String.class.getCanonicalName();
    private static final String DOUBLE = "double";
    private static final String BOOLEAN = "boolean";
    private final MortalLogger logger;
    private final FieldReferenceConverter converter;
    private final Map<String, AttributeParser> parsers = new HashMap<String, AttributeParser>();

    public AttributeParsers(TypeOracle types, FieldManager fieldManager, MortalLogger logger) {
        this.logger = logger;
        this.converter = new FieldReferenceConverter(fieldManager);
        try {
            BooleanAttributeParser boolParser = new BooleanAttributeParser(this.converter, types.parse(BOOLEAN), logger);
            this.addAttributeParser(BOOLEAN, boolParser);
            this.addAttributeParser(Boolean.class.getCanonicalName(), boolParser);
            IntAttributeParser intParser = new IntAttributeParser(this.converter, types.parse(INT), logger);
            this.addAttributeParser(INT, intParser);
            this.addAttributeParser(Integer.class.getCanonicalName(), intParser);
            DoubleAttributeParser doubleParser = new DoubleAttributeParser(this.converter, types.parse(DOUBLE), logger);
            this.addAttributeParser(DOUBLE, doubleParser);
            this.addAttributeParser(Double.class.getCanonicalName(), doubleParser);
            this.addAttributeParser("int,int", new IntPairParser());
            this.addAttributeParser(HORIZ_CONSTANT, new HorizontalAlignmentConstantParser(this.converter, types.parse(HORIZ_CONSTANT), logger));
            this.addAttributeParser(VERT_CONSTANT, new VerticalAlignmentConstantParser(this.converter, types.parse(VERT_CONSTANT), logger));
            this.addAttributeParser(STRING, new StringAttributeParser(this.converter, types.parse(STRING)));
        }
        catch (TypeOracleException e) {
            throw new RuntimeException(e);
        }
    }

    public AttributeParser get(JType ... types) {
        if (types.length == 0) {
            throw new RuntimeException("Asked for attribute parser of no type");
        }
        AttributeParser rtn = this.getForKey(this.getParametersKey(types));
        if (rtn != null || types.length > 1) {
            return rtn;
        }
        JEnumType enumType = types[0].isEnum();
        if (enumType != null) {
            return new EnumAttributeParser(this.converter, enumType, this.logger);
        }
        return new StrictAttributeParser(this.converter, types[0], this.logger);
    }

    private void addAttributeParser(String signature, AttributeParser attributeParser) {
        this.parsers.put(signature, attributeParser);
    }

    private AttributeParser getForKey(String key) {
        return this.parsers.get(key);
    }

    private String getParametersKey(JType[] types) {
        StringBuffer b = new StringBuffer();
        for (JType t : types) {
            if (b.length() > 0) {
                b.append(',');
            }
            b.append(t.getParameterizedQualifiedSourceName());
        }
        return b.toString();
    }
}

